/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.WeakHashMap;

final class ChannelHandlerMask {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelHandlerMask.class);
    static final int MASK_EXCEPTION_CAUGHT = 1;
    static final int MASK_CHANNEL_REGISTERED = 2;
    static final int MASK_CHANNEL_UNREGISTERED = 4;
    static final int MASK_CHANNEL_ACTIVE = 8;
    static final int MASK_CHANNEL_INACTIVE = 16;
    static final int MASK_CHANNEL_READ = 32;
    static final int MASK_CHANNEL_READ_COMPLETE = 64;
    static final int MASK_USER_EVENT_TRIGGERED = 128;
    static final int MASK_CHANNEL_WRITABILITY_CHANGED = 256;
    static final int MASK_BIND = 512;
    static final int MASK_CONNECT = 1024;
    static final int MASK_DISCONNECT = 2048;
    static final int MASK_CLOSE = 4096;
    static final int MASK_DEREGISTER = 8192;
    static final int MASK_READ = 16384;
    static final int MASK_WRITE = 32768;
    static final int MASK_FLUSH = 65536;
    static final int MASK_ONLY_INBOUND = 510;
    private static final int MASK_ALL_INBOUND = 511;
    static final int MASK_ONLY_OUTBOUND = 130560;
    private static final int MASK_ALL_OUTBOUND = 130561;
    private static final FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>> MASKS = new FastThreadLocal<Map<Class<? extends ChannelHandler>, Integer>>(){

        protected final Map<Class<? extends ChannelHandler>, Integer> initialValue() {
            return new WeakHashMap<Class<? extends ChannelHandler>, Integer>(32);
        }
    };

    static int mask(Class<? extends ChannelHandler> clazz) {
        Map map = (Map)MASKS.get();
        Integer n = (Integer)map.get(clazz);
        if (n == null) {
            n = ChannelHandlerMask.mask0(clazz);
            map.put(clazz, n);
        }
        return n;
    }

    private static int mask0(Class<? extends ChannelHandler> serializable) {
        int n = 1;
        try {
            if (ChannelInboundHandler.class.isAssignableFrom((Class<?>)serializable)) {
                n = 511;
                if (ChannelHandlerMask.isSkippable(serializable, "channelRegistered", new Class[]{ChannelHandlerContext.class})) {
                    n = 509;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelUnregistered", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFFFFFB;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelActive", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFFFFF7;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelInactive", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFFFFEF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelRead", new Class[]{ChannelHandlerContext.class, Object.class})) {
                    n &= 0xFFFFFFDF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelReadComplete", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFFFFBF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "channelWritabilityChanged", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFFFEFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "userEventTriggered", new Class[]{ChannelHandlerContext.class, Object.class})) {
                    n &= 0xFFFFFF7F;
                }
            }
            if (ChannelOutboundHandler.class.isAssignableFrom((Class<?>)serializable)) {
                n |= 0x1FE01;
                if (ChannelHandlerMask.isSkippable(serializable, "bind", new Class[]{ChannelHandlerContext.class, SocketAddress.class, ChannelPromise.class})) {
                    n &= 0xFFFFFDFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "connect", new Class[]{ChannelHandlerContext.class, SocketAddress.class, SocketAddress.class, ChannelPromise.class})) {
                    n &= 0xFFFFFBFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "disconnect", new Class[]{ChannelHandlerContext.class, ChannelPromise.class})) {
                    n &= 0xFFFFF7FF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "close", new Class[]{ChannelHandlerContext.class, ChannelPromise.class})) {
                    n &= 0xFFFFEFFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "deregister", new Class[]{ChannelHandlerContext.class, ChannelPromise.class})) {
                    n &= 0xFFFFDFFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "read", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFFBFFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "write", new Class[]{ChannelHandlerContext.class, Object.class, ChannelPromise.class})) {
                    n &= 0xFFFF7FFF;
                }
                if (ChannelHandlerMask.isSkippable(serializable, "flush", new Class[]{ChannelHandlerContext.class})) {
                    n &= 0xFFFEFFFF;
                }
            }
            if (ChannelHandlerMask.isSkippable(serializable, "exceptionCaught", new Class[]{ChannelHandlerContext.class, Throwable.class})) {
                n &= 0xFFFFFFFE;
            }
        }
        catch (Exception exception) {
            serializable = exception;
            PlatformDependent.throwException((Throwable)exception);
        }
        return n;
    }

    private static boolean isSkippable(final Class<?> clazz, final String string, final Class<?> ... classArray) {
        return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

            @Override
            public final Boolean run() {
                Method method;
                try {
                    method = clazz.getMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Class {} missing method {}, assume we can not skip execution", new Object[]{clazz, string, noSuchMethodException});
                    }
                    return Boolean.FALSE;
                }
                return method.isAnnotationPresent(Skip.class);
            }
        });
    }

    private ChannelHandlerMask() {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    static @interface Skip {
    }
}

