/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.InternalThreadLocalMap;
import io.netty.util.internal.ObjectPool;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PromiseNotificationUtil;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class ChannelOutboundBuffer {
    static final int CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD = SystemPropertyUtil.getInt((String)"io.netty.transport.outboundBufferEntrySizeOverhead", (int)96);
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final FastThreadLocal<ByteBuffer[]> NIO_BUFFERS = new FastThreadLocal<ByteBuffer[]>(){

        protected final ByteBuffer[] initialValue() {
            return new ByteBuffer[1024];
        }
    };
    private final Channel channel;
    private Entry flushedEntry;
    private Entry unflushedEntry;
    private Entry tailEntry;
    private int flushed;
    private int nioBufferCount;
    private long nioBufferSize;
    private boolean inFail;
    private static final AtomicLongFieldUpdater<ChannelOutboundBuffer> TOTAL_PENDING_SIZE_UPDATER = AtomicLongFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "totalPendingSize");
    private volatile long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> UNWRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "unwritable");
    private volatile int unwritable;
    private volatile Runnable fireChannelWritabilityChangedTask;

    ChannelOutboundBuffer(AbstractChannel abstractChannel) {
        this.channel = abstractChannel;
    }

    public final void addMessage(Object object, int n, ChannelPromise object2) {
        Entry entry = Entry.newInstance(object, n, ChannelOutboundBuffer.total(object), (ChannelPromise)object2);
        if (this.tailEntry == null) {
            this.flushedEntry = null;
        } else {
            object2 = this.tailEntry;
            this.tailEntry.next = entry;
        }
        this.tailEntry = entry;
        if (this.unflushedEntry == null) {
            this.unflushedEntry = entry;
        }
        if (object instanceof AbstractReferenceCountedByteBuf) {
            ((AbstractReferenceCountedByteBuf)object).touch();
        } else {
            ReferenceCountUtil.touch((Object)object);
        }
        this.incrementPendingOutboundBytes(entry.pendingSize, false);
    }

    public final void addFlush() {
        Entry entry = this.unflushedEntry;
        if (entry != null) {
            if (this.flushedEntry == null) {
                this.flushedEntry = entry;
            }
            do {
                ++this.flushed;
                if (entry.promise.setUncancellable()) continue;
                int n = entry.cancel();
                this.decrementPendingOutboundBytes(n, false, true);
            } while ((entry = entry.next) != null);
            this.unflushedEntry = null;
        }
    }

    final void incrementPendingOutboundBytes(long l) {
        this.incrementPendingOutboundBytes(l, true);
    }

    private void incrementPendingOutboundBytes(long l, boolean bl) {
        if (l == 0L) {
            return;
        }
        long l2 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, l);
        if (l2 > (long)this.channel.config().getWriteBufferHighWaterMark()) {
            this.setUnwritable(bl);
        }
    }

    final void decrementPendingOutboundBytes(long l) {
        this.decrementPendingOutboundBytes(l, true, true);
    }

    private void decrementPendingOutboundBytes(long l, boolean bl, boolean bl2) {
        if (l == 0L) {
            return;
        }
        long l2 = TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -l);
        if (bl2 && l2 < (long)this.channel.config().getWriteBufferLowWaterMark()) {
            this.setWritable(bl);
        }
    }

    private static long total(Object object) {
        if (object instanceof ByteBuf) {
            return ((ByteBuf)object).readableBytes();
        }
        if (object instanceof FileRegion) {
            return ((FileRegion)object).count();
        }
        if (object instanceof ByteBufHolder) {
            return ((ByteBufHolder)object).content().readableBytes();
        }
        return -1L;
    }

    public final Object current() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return null;
        }
        return entry.msg;
    }

    public final long currentProgress() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return 0L;
        }
        return entry.progress;
    }

    public final void progress(long l) {
        long l2;
        Entry entry = this.flushedEntry;
        assert (entry != null);
        ChannelPromise channelPromise = entry.promise;
        entry.progress = l2 = entry.progress + l;
        assert (channelPromise != null);
        Class<?> clazz = channelPromise.getClass();
        if (clazz == VoidChannelPromise.class || clazz == DefaultChannelPromise.class) {
            return;
        }
        if (channelPromise instanceof DefaultChannelProgressivePromise) {
            ((DefaultChannelProgressivePromise)channelPromise).tryProgress(l2, entry.total);
            return;
        }
        if (channelPromise instanceof ChannelProgressivePromise) {
            ((ChannelProgressivePromise)channelPromise).tryProgress(l2, entry.total);
        }
    }

    public final boolean remove() {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = entry.msg;
        ChannelPromise channelPromise = entry.promise;
        int n = entry.pendingSize;
        this.removeEntry(entry);
        if (!entry.cancelled) {
            if (object instanceof AbstractReferenceCountedByteBuf) {
                try {
                    ((AbstractReferenceCountedByteBuf)object).release();
                }
                catch (Throwable throwable) {
                    logger.warn("Failed to release a ByteBuf: {}", object, (Object)throwable);
                }
            } else {
                ReferenceCountUtil.safeRelease((Object)object);
            }
            ChannelOutboundBuffer.safeSuccess(channelPromise);
            this.decrementPendingOutboundBytes(n, false, true);
        }
        entry.unguardedRecycle();
        return true;
    }

    public final boolean remove(Throwable throwable) {
        return this.remove0(throwable, true);
    }

    private boolean remove0(Throwable throwable, boolean bl) {
        Entry entry = this.flushedEntry;
        if (entry == null) {
            this.clearNioBuffers();
            return false;
        }
        Object object = entry.msg;
        ChannelPromise channelPromise = entry.promise;
        int n = entry.pendingSize;
        this.removeEntry(entry);
        if (!entry.cancelled) {
            ReferenceCountUtil.safeRelease((Object)object);
            ChannelOutboundBuffer.safeFail(channelPromise, throwable);
            this.decrementPendingOutboundBytes(n, false, bl);
        }
        entry.unguardedRecycle();
        return true;
    }

    private void removeEntry(Entry entry) {
        if (--this.flushed == 0) {
            this.flushedEntry = null;
            if (entry == this.tailEntry) {
                this.tailEntry = null;
                this.unflushedEntry = null;
                return;
            }
        } else {
            this.flushedEntry = entry.next;
        }
    }

    public final void removeBytes(long l) {
        block5: {
            int n;
            Object object;
            while (true) {
                if (!((object = this.current()) instanceof ByteBuf)) {
                    assert (l == 0L);
                    break block5;
                }
                object = (ByteBuf)object;
                n = object.readerIndex();
                int n2 = object.writerIndex() - n;
                if ((long)n2 > l) break;
                if (l != 0L) {
                    this.progress(n2);
                    l -= (long)n2;
                }
                this.remove();
            }
            if (l != 0L) {
                object.readerIndex(n + (int)l);
                this.progress(l);
            }
        }
        this.clearNioBuffers();
    }

    private void clearNioBuffers() {
        int n = this.nioBufferCount;
        if (n > 0) {
            this.nioBufferCount = 0;
            Arrays.fill((Object[])NIO_BUFFERS.get(), 0, n, null);
        }
    }

    public final ByteBuffer[] nioBuffers() {
        return this.nioBuffers(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public final ByteBuffer[] nioBuffers(int n, long l) {
        assert (n > 0);
        assert (l > 0L);
        long l2 = 0L;
        int n2 = 0;
        InternalThreadLocalMap internalThreadLocalMap = InternalThreadLocalMap.get();
        ByteBuffer[] byteBufferArray = (ByteBuffer[])NIO_BUFFERS.get(internalThreadLocalMap);
        Entry entry = this.flushedEntry;
        while (this.isFlushedEntry(entry) && entry.msg instanceof ByteBuf) {
            if (!entry.cancelled) {
                ByteBuf byteBuf = (ByteBuf)entry.msg;
                int n3 = byteBuf.readerIndex();
                int n4 = byteBuf.writerIndex() - n3;
                if (n4 > 0) {
                    int n5;
                    if (l - (long)n4 < l2 && n2 != 0) break;
                    l2 += (long)n4;
                    int n6 = entry.count;
                    if (n6 == -1) {
                        entry.count = n6 = byteBuf.nioBufferCount();
                    }
                    if ((n5 = Math.min(n, n2 + n6)) > byteBufferArray.length) {
                        byteBufferArray = ChannelOutboundBuffer.expandNioBufferArray(byteBufferArray, n5, n2);
                        NIO_BUFFERS.set(internalThreadLocalMap, (Object)byteBufferArray);
                    }
                    if (n6 == 1) {
                        ByteBuffer byteBuffer = entry.buf;
                        if (byteBuffer == null) {
                            entry.buf = byteBuffer = byteBuf.internalNioBuffer(n3, n4);
                        }
                        byteBufferArray[n2++] = byteBuffer;
                    } else {
                        n2 = ChannelOutboundBuffer.nioBuffers(entry, byteBuf, byteBufferArray, n2, n);
                    }
                    if (n2 >= n) break;
                }
            }
            entry = entry.next;
        }
        this.nioBufferCount = n2;
        this.nioBufferSize = l2;
        return byteBufferArray;
    }

    private static int nioBuffers(Entry entry, ByteBuf object, ByteBuffer[] byteBufferArray, int n, int n2) {
        ByteBuffer[] byteBufferArray2 = entry.bufs;
        if (entry.bufs == null) {
            entry.bufs = byteBufferArray2 = object.nioBuffers();
        }
        for (int i = 0; i < byteBufferArray2.length && n < n2 && (object = byteBufferArray2[i]) != null; ++i) {
            if (!((Buffer)object).hasRemaining()) continue;
            byteBufferArray[n++] = object;
        }
        return n;
    }

    private static ByteBuffer[] expandNioBufferArray(ByteBuffer[] byteBufferArray, int n, int n2) {
        int n3 = byteBufferArray.length;
        do {
            if ((n3 <<= 1) >= 0) continue;
            throw new IllegalStateException();
        } while (n > n3);
        ByteBuffer[] byteBufferArray2 = new ByteBuffer[n3];
        System.arraycopy(byteBufferArray, 0, byteBufferArray2, 0, n2);
        return byteBufferArray2;
    }

    public final int nioBufferCount() {
        return this.nioBufferCount;
    }

    public final long nioBufferSize() {
        return this.nioBufferSize;
    }

    public final boolean isWritable() {
        return this.unwritable == 0;
    }

    public final boolean getUserDefinedWritability(int n) {
        return (this.unwritable & ChannelOutboundBuffer.writabilityMask(n)) == 0;
    }

    public final void setUserDefinedWritability(int n, boolean bl) {
        if (bl) {
            this.setUserDefinedWritability(n);
            return;
        }
        this.clearUserDefinedWritability(n);
    }

    private void setUserDefinedWritability(int n) {
        int n2;
        int n3;
        n = ~ChannelOutboundBuffer.writabilityMask(n);
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 & n)) {
        }
        if (n3 != 0 && n2 == 0) {
            this.fireChannelWritabilityChanged(true);
            return;
        }
    }

    private void clearUserDefinedWritability(int n) {
        int n2;
        int n3;
        n = ChannelOutboundBuffer.writabilityMask(n);
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n3 = this.unwritable, n2 = n3 | n)) {
        }
        if (n3 == 0 && n2 != 0) {
            this.fireChannelWritabilityChanged(true);
            return;
        }
    }

    private static int writabilityMask(int n) {
        if (n <= 0 || n > 31) {
            throw new IllegalArgumentException("index: " + n + " (expected: 1~31)");
        }
        return 1 << n;
    }

    private void setWritable(boolean bl) {
        int n;
        int n2;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n2 = this.unwritable, n = n2 & 0xFFFFFFFE)) {
        }
        if (n2 != 0 && n == 0) {
            this.fireChannelWritabilityChanged(bl);
            return;
        }
    }

    private void setUnwritable(boolean bl) {
        int n;
        int n2;
        while (!UNWRITABLE_UPDATER.compareAndSet(this, n2 = this.unwritable, n = n2 | 1)) {
        }
        if (n2 == 0) {
            this.fireChannelWritabilityChanged(bl);
            return;
        }
    }

    private void fireChannelWritabilityChanged(boolean bl) {
        final ChannelPipeline channelPipeline = this.channel.pipeline();
        if (bl) {
            Runnable runnable = this.fireChannelWritabilityChangedTask;
            if (runnable == null) {
                this.fireChannelWritabilityChangedTask = runnable = new Runnable(){

                    @Override
                    public void run() {
                        channelPipeline.fireChannelWritabilityChanged();
                    }
                };
            }
            this.channel.eventLoop().execute(runnable);
            return;
        }
        channelPipeline.fireChannelWritabilityChanged();
    }

    public final int size() {
        return this.flushed;
    }

    public final boolean isEmpty() {
        return this.flushed == 0;
    }

    final void failFlushed(Throwable throwable, boolean bl) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove0(throwable, bl)) {
            }
            return;
        }
        finally {
            this.inFail = false;
        }
    }

    final void close(final Throwable throwable, final boolean bl) {
        if (this.inFail) {
            this.channel.eventLoop().execute(new Runnable(){

                @Override
                public void run() {
                    ChannelOutboundBuffer.this.close(throwable, bl);
                }
            });
            return;
        }
        this.inFail = true;
        if (!bl && this.channel.isOpen()) {
            throw new IllegalStateException("close() must be invoked after the channel is closed.");
        }
        if (!this.isEmpty()) {
            throw new IllegalStateException("close() must be invoked after all flushed writes are handled.");
        }
        try {
            for (Entry entry = this.unflushedEntry; entry != null; entry = entry.unguardedRecycleAndGetNext()) {
                int n = entry.pendingSize;
                TOTAL_PENDING_SIZE_UPDATER.addAndGet(this, -n);
                if (entry.cancelled) continue;
                ReferenceCountUtil.safeRelease((Object)entry.msg);
                ChannelOutboundBuffer.safeFail(entry.promise, throwable);
            }
        }
        finally {
            this.inFail = false;
        }
        this.clearNioBuffers();
    }

    final void close(ClosedChannelException closedChannelException) {
        this.close(closedChannelException, false);
    }

    private static void safeSuccess(ChannelPromise channelPromise) {
        PromiseNotificationUtil.trySuccess((Promise)channelPromise, null, (InternalLogger)(channelPromise instanceof VoidChannelPromise ? null : logger));
    }

    private static void safeFail(ChannelPromise channelPromise, Throwable throwable) {
        PromiseNotificationUtil.tryFailure((Promise)channelPromise, (Throwable)throwable, (InternalLogger)(channelPromise instanceof VoidChannelPromise ? null : logger));
    }

    @Deprecated
    public final void recycle() {
    }

    public final long totalPendingWriteBytes() {
        return this.totalPendingSize;
    }

    public final long bytesBeforeUnwritable() {
        long l = (long)this.channel.config().getWriteBufferHighWaterMark() - this.totalPendingSize + 1L;
        if (l > 0L && this.isWritable()) {
            return l;
        }
        return 0L;
    }

    public final long bytesBeforeWritable() {
        long l = this.totalPendingSize - (long)this.channel.config().getWriteBufferLowWaterMark() + 1L;
        if (l <= 0L || this.isWritable()) {
            return 0L;
        }
        return l;
    }

    public final void forEachFlushedMessage(MessageProcessor messageProcessor) {
        ObjectUtil.checkNotNull((Object)messageProcessor, (String)"processor");
        Entry entry = this.flushedEntry;
        if (entry == null) {
            return;
        }
        do {
            if (entry.cancelled || messageProcessor.processMessage(entry.msg)) continue;
            return;
        } while (this.isFlushedEntry(entry = entry.next));
    }

    private boolean isFlushedEntry(Entry entry) {
        return entry != null && entry != this.unflushedEntry;
    }

    static final class Entry {
        private static final ObjectPool<Entry> RECYCLER = ObjectPool.newPool((ObjectPool.ObjectCreator)new ObjectPool.ObjectCreator<Entry>(){

            public final Entry newObject(ObjectPool.Handle<Entry> handle) {
                return new Entry(handle);
            }
        });
        private final Recycler.EnhancedHandle<Entry> handle;
        Entry next;
        Object msg;
        ByteBuffer[] bufs;
        ByteBuffer buf;
        ChannelPromise promise;
        long progress;
        long total;
        int pendingSize;
        int count = -1;
        boolean cancelled;

        private Entry(ObjectPool.Handle<Entry> handle) {
            this.handle = (Recycler.EnhancedHandle)handle;
        }

        static Entry newInstance(Object object, int n, long l, ChannelPromise channelPromise) {
            Entry entry = (Entry)RECYCLER.get();
            ((Entry)RECYCLER.get()).msg = object;
            entry.pendingSize = n + CHANNEL_OUTBOUND_BUFFER_ENTRY_OVERHEAD;
            entry.total = l;
            entry.promise = channelPromise;
            return entry;
        }

        final int cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                int n = this.pendingSize;
                ReferenceCountUtil.safeRelease((Object)this.msg);
                this.msg = Unpooled.EMPTY_BUFFER;
                this.pendingSize = 0;
                this.total = 0L;
                this.progress = 0L;
                this.bufs = null;
                this.buf = null;
                return n;
            }
            return 0;
        }

        final void unguardedRecycle() {
            this.next = null;
            this.bufs = null;
            this.buf = null;
            this.msg = null;
            this.promise = null;
            this.progress = 0L;
            this.total = 0L;
            this.pendingSize = 0;
            this.count = -1;
            this.cancelled = false;
            this.handle.unguardedRecycle((Object)this);
        }

        final Entry unguardedRecycleAndGetNext() {
            Entry entry = this.next;
            this.unguardedRecycle();
            return entry;
        }
    }

    public static interface MessageProcessor {
        public boolean processMessage(Object var1);
    }
}

