/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.AbstractNioMessageChannel;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.DatagramChannelConfig;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannelConfig;
import io.netty.channel.socket.nio.ProtocolFamilyConverter;
import io.netty.util.UncheckedBooleanSupplier;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SocketUtils;
import io.netty.util.internal.StringUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.MembershipKey;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class NioDatagramChannel
extends AbstractNioMessageChannel
implements DatagramChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(true, 16);
    private static final SelectorProvider DEFAULT_SELECTOR_PROVIDER = SelectorProvider.provider();
    private static final String EXPECTED_TYPES = " (expected: " + StringUtil.simpleClassName(DatagramPacket.class) + ", " + StringUtil.simpleClassName(AddressedEnvelope.class) + '<' + StringUtil.simpleClassName(ByteBuf.class) + ", " + StringUtil.simpleClassName(SocketAddress.class) + ">, " + StringUtil.simpleClassName(ByteBuf.class) + ')';
    private final DatagramChannelConfig config;
    private Map<InetAddress, List<MembershipKey>> memberships;

    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider selectorProvider) {
        try {
            return selectorProvider.openDatagramChannel();
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    private static java.nio.channels.DatagramChannel newSocket(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        if (internetProtocolFamily == null) {
            return NioDatagramChannel.newSocket(selectorProvider);
        }
        NioDatagramChannel.checkJavaVersion();
        try {
            return selectorProvider.openDatagramChannel(ProtocolFamilyConverter.convert(internetProtocolFamily));
        }
        catch (IOException iOException) {
            throw new ChannelException("Failed to open a socket.", iOException);
        }
    }

    private static void checkJavaVersion() {
        if (PlatformDependent.javaVersion() < 7) {
            throw new UnsupportedOperationException("Only supported on java 7+.");
        }
    }

    public NioDatagramChannel() {
        this(NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER));
    }

    public NioDatagramChannel(SelectorProvider selectorProvider) {
        this(NioDatagramChannel.newSocket(selectorProvider));
    }

    public NioDatagramChannel(InternetProtocolFamily internetProtocolFamily) {
        this(NioDatagramChannel.newSocket(DEFAULT_SELECTOR_PROVIDER, internetProtocolFamily));
    }

    public NioDatagramChannel(SelectorProvider selectorProvider, InternetProtocolFamily internetProtocolFamily) {
        this(NioDatagramChannel.newSocket(selectorProvider, internetProtocolFamily));
    }

    public NioDatagramChannel(java.nio.channels.DatagramChannel datagramChannel) {
        super(null, datagramChannel, 1);
        this.config = new NioDatagramChannelConfig(this, datagramChannel);
    }

    @Override
    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public final DatagramChannelConfig config() {
        return this.config;
    }

    @Override
    public final boolean isActive() {
        java.nio.channels.DatagramChannel datagramChannel = this.javaChannel();
        return datagramChannel.isOpen() && (this.config.getOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION) != false && this.isRegistered() || datagramChannel.socket().isBound());
    }

    @Override
    public final boolean isConnected() {
        return this.javaChannel().isConnected();
    }

    @Override
    protected final java.nio.channels.DatagramChannel javaChannel() {
        return (java.nio.channels.DatagramChannel)super.javaChannel();
    }

    @Override
    protected final SocketAddress localAddress0() {
        return this.javaChannel().socket().getLocalSocketAddress();
    }

    @Override
    protected final SocketAddress remoteAddress0() {
        return this.javaChannel().socket().getRemoteSocketAddress();
    }

    @Override
    protected final void doBind(SocketAddress socketAddress) {
        this.doBind0(socketAddress);
    }

    private void doBind0(SocketAddress socketAddress) {
        if (PlatformDependent.javaVersion() >= 7) {
            SocketUtils.bind((java.nio.channels.DatagramChannel)this.javaChannel(), (SocketAddress)socketAddress);
            return;
        }
        this.javaChannel().socket().bind(socketAddress);
    }

    @Override
    protected final boolean doConnect(SocketAddress socketAddress, SocketAddress socketAddress2) {
        if (socketAddress2 != null) {
            this.doBind0(socketAddress2);
        }
        boolean bl = false;
        try {
            this.javaChannel().connect(socketAddress);
            bl = true;
            return true;
        }
        catch (Throwable throwable) {
            if (!bl) {
                this.doClose();
            }
            throw throwable;
        }
    }

    @Override
    protected final void doFinishConnect() {
        throw new Error();
    }

    @Override
    protected final void doDisconnect() {
        this.javaChannel().disconnect();
    }

    @Override
    protected final void doClose() {
        this.javaChannel().close();
    }

    @Override
    protected final int doReadMessages(List<Object> list) {
        int n;
        Object object;
        boolean bl;
        RecvByteBufAllocator.Handle handle;
        DatagramChannelConfig datagramChannelConfig;
        Object object2;
        block7: {
            object2 = this.javaChannel();
            datagramChannelConfig = this.config();
            handle = this.unsafe().recvBufAllocHandle();
            datagramChannelConfig = handle.allocate(datagramChannelConfig.getAllocator());
            handle.attemptedBytesRead(datagramChannelConfig.writableBytes());
            bl = true;
            DatagramChannelConfig datagramChannelConfig2 = datagramChannelConfig;
            object = datagramChannelConfig2.internalNioBuffer(datagramChannelConfig2.writerIndex(), datagramChannelConfig.writableBytes());
            n = ((Buffer)object).position();
            object2 = (InetSocketAddress)((java.nio.channels.DatagramChannel)object2).receive((ByteBuffer)object);
            if (object2 != null) break block7;
            datagramChannelConfig.release();
            return 0;
        }
        try {
            handle.lastBytesRead(((Buffer)object).position() - n);
            DatagramChannelConfig datagramChannelConfig3 = datagramChannelConfig;
            list.add(new DatagramPacket(datagramChannelConfig3.writerIndex(datagramChannelConfig3.writerIndex() + handle.lastBytesRead()), this.localAddress(), (InetSocketAddress)object2));
            bl = false;
            return 1;
        }
        catch (Throwable throwable) {
            object = throwable;
            PlatformDependent.throwException((Throwable)throwable);
            return -1;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        finally {
            if (bl) {
                datagramChannelConfig.release();
            }
        }
    }

    @Override
    protected final boolean doWriteMessage(Object object, ChannelOutboundBuffer object2) {
        ByteBuffer byteBuffer;
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            object = addressedEnvelope.recipient();
            object2 = (ByteBuf)addressedEnvelope.content();
        } else {
            object2 = (ByteBuf)object;
            object = null;
        }
        int n = object2.readableBytes();
        if (n == 0) {
            return true;
        }
        if (object2.nioBufferCount() == 1) {
            ChannelOutboundBuffer channelOutboundBuffer = object2;
            byteBuffer = channelOutboundBuffer.internalNioBuffer(channelOutboundBuffer.readerIndex(), n);
        } else {
            ChannelOutboundBuffer channelOutboundBuffer = object2;
            byteBuffer = channelOutboundBuffer.nioBuffer(channelOutboundBuffer.readerIndex(), n);
        }
        object2 = byteBuffer;
        int n2 = object != null ? this.javaChannel().send((ByteBuffer)object2, (SocketAddress)object) : this.javaChannel().write((ByteBuffer)object2);
        return n2 > 0;
    }

    private static void checkUnresolved(AddressedEnvelope<?, ?> addressedEnvelope) {
        if (addressedEnvelope.recipient() instanceof InetSocketAddress && ((InetSocketAddress)addressedEnvelope.recipient()).isUnresolved()) {
            throw new UnresolvedAddressException();
        }
    }

    @Override
    protected final Object filterOutboundMessage(Object object) {
        if (object instanceof DatagramPacket) {
            DatagramPacket datagramPacket = (DatagramPacket)object;
            NioDatagramChannel.checkUnresolved(datagramPacket);
            object = (ByteBuf)datagramPacket.content();
            if (NioDatagramChannel.isSingleDirectBuffer((ByteBuf)object)) {
                return datagramPacket;
            }
            return new DatagramPacket(this.newDirectBuffer(datagramPacket, (ByteBuf)object), (InetSocketAddress)datagramPacket.recipient());
        }
        if (object instanceof ByteBuf) {
            ByteBuf byteBuf = (ByteBuf)object;
            if (NioDatagramChannel.isSingleDirectBuffer(byteBuf)) {
                return byteBuf;
            }
            return this.newDirectBuffer(byteBuf);
        }
        if (object instanceof AddressedEnvelope) {
            AddressedEnvelope addressedEnvelope = (AddressedEnvelope)object;
            NioDatagramChannel.checkUnresolved(addressedEnvelope);
            if (addressedEnvelope.content() instanceof ByteBuf) {
                object = (ByteBuf)addressedEnvelope.content();
                if (NioDatagramChannel.isSingleDirectBuffer((ByteBuf)object)) {
                    return addressedEnvelope;
                }
                return new DefaultAddressedEnvelope(this.newDirectBuffer(addressedEnvelope, (ByteBuf)object), addressedEnvelope.recipient());
            }
        }
        throw new UnsupportedOperationException("unsupported message type: " + StringUtil.simpleClassName((Object)object) + EXPECTED_TYPES);
    }

    private static boolean isSingleDirectBuffer(ByteBuf byteBuf) {
        return byteBuf.isDirect() && byteBuf.nioBufferCount() == 1;
    }

    @Override
    protected final boolean continueOnWriteError() {
        return true;
    }

    @Override
    public final InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public final InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress) {
        return this.joinGroup(inetAddress, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            NetworkInterface networkInterface = this.config.getNetworkInterface();
            if (networkInterface == null) {
                networkInterface = NetworkInterface.getByInetAddress(this.localAddress().getAddress());
            }
            return this.joinGroup(inetAddress, networkInterface, null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.joinGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.joinGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.joinGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture joinGroup(InetAddress inetAddress, NetworkInterface object, InetAddress object2, ChannelPromise channelPromise) {
        NioDatagramChannel.checkJavaVersion();
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)object, (String)"networkInterface");
        try {
            object = object2 == null ? this.javaChannel().join(inetAddress, (NetworkInterface)object) : this.javaChannel().join(inetAddress, (NetworkInterface)object, (InetAddress)object2);
            object2 = this;
            synchronized (object2) {
                List<MembershipKey> list = null;
                if (this.memberships == null) {
                    this.memberships = new HashMap<InetAddress, List<MembershipKey>>();
                } else {
                    list = this.memberships.get(inetAddress);
                }
                if (list == null) {
                    list = new ArrayList<MembershipKey>();
                    this.memberships.put(inetAddress, list);
                }
                list.add((MembershipKey)object);
            }
            channelPromise.setSuccess();
        }
        catch (Throwable throwable) {
            channelPromise.setFailure(throwable);
        }
        return channelPromise;
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress) {
        return this.leaveGroup(inetAddress, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, ChannelPromise channelPromise) {
        try {
            return this.leaveGroup(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), null, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface) {
        return this.leaveGroup(inetSocketAddress, networkInterface, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetSocketAddress inetSocketAddress, NetworkInterface networkInterface, ChannelPromise channelPromise) {
        return this.leaveGroup(inetSocketAddress.getAddress(), networkInterface, null, channelPromise);
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.leaveGroup(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture leaveGroup(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2, ChannelPromise channelPromise) {
        NioDatagramChannel.checkJavaVersion();
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            List<MembershipKey> list;
            if (this.memberships != null && (list = this.memberships.get(inetAddress)) != null) {
                Iterator<MembershipKey> iterator = list.iterator();
                while (iterator.hasNext()) {
                    MembershipKey membershipKey = iterator.next();
                    if (!networkInterface.equals(membershipKey.networkInterface()) || (inetAddress2 != null || membershipKey.sourceAddress() != null) && (inetAddress2 == null || !inetAddress2.equals(membershipKey.sourceAddress()))) continue;
                    membershipKey.drop();
                    iterator.remove();
                }
                if (list.isEmpty()) {
                    this.memberships.remove(inetAddress);
                }
            }
        }
        channelPromise.setSuccess();
        return channelPromise;
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, NetworkInterface networkInterface, InetAddress inetAddress2) {
        return this.block(inetAddress, networkInterface, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture block(InetAddress iterator, NetworkInterface networkInterface, InetAddress inetAddress, ChannelPromise channelPromise) {
        NioDatagramChannel.checkJavaVersion();
        ObjectUtil.checkNotNull((Object)iterator, (String)"multicastAddress");
        ObjectUtil.checkNotNull((Object)inetAddress, (String)"sourceToBlock");
        ObjectUtil.checkNotNull((Object)networkInterface, (String)"networkInterface");
        NioDatagramChannel nioDatagramChannel = this;
        synchronized (nioDatagramChannel) {
            if (this.memberships != null) {
                iterator = this.memberships.get(iterator);
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    MembershipKey membershipKey = iterator.next();
                    if (!networkInterface.equals(membershipKey.networkInterface())) continue;
                    try {
                        membershipKey.block(inetAddress);
                    }
                    catch (IOException iOException) {
                        channelPromise.setFailure(iOException);
                    }
                }
            }
        }
        channelPromise.setSuccess();
        return channelPromise;
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2) {
        return this.block(inetAddress, inetAddress2, this.newPromise());
    }

    @Override
    public final ChannelFuture block(InetAddress inetAddress, InetAddress inetAddress2, ChannelPromise channelPromise) {
        try {
            return this.block(inetAddress, NetworkInterface.getByInetAddress(this.localAddress().getAddress()), inetAddress2, channelPromise);
        }
        catch (SocketException socketException) {
            channelPromise.setFailure(socketException);
            return channelPromise;
        }
    }

    @Override
    @Deprecated
    protected final void setReadPending(boolean bl) {
        super.setReadPending(bl);
    }

    final void clearReadPending0() {
        this.clearReadPending();
    }

    @Override
    protected final boolean closeOnReadError(Throwable throwable) {
        if (throwable instanceof SocketException) {
            return false;
        }
        return super.closeOnReadError(throwable);
    }

    @Override
    protected final boolean continueReading(RecvByteBufAllocator.Handle handle) {
        if (handle instanceof RecvByteBufAllocator.ExtendedHandle) {
            return ((RecvByteBufAllocator.ExtendedHandle)handle).continueReading(UncheckedBooleanSupplier.TRUE_SUPPLIER);
        }
        return handle.continueReading();
    }
}

