/*
 * Decompiled with CFR 0.152.
 */
package kotlin.internal.jdk8;

import java.time.Instant;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.internal.jdk7.JDK7PlatformImplementations;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.jdk8.PlatformThreadLocalRandom;
import kotlin.ranges.IntRange;
import kotlin.text.MatchGroup;
import kotlin.time.Clock;
import kotlin.time.jdk8.InstantConversionsJDK8Kt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0010\u0018\u00002\u00020\u0001:\u0001\u0012B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0017\u00a8\u0006\u0013"}, d2={"Lkotlin/internal/jdk8/JDK8PlatformImplementations;", "Lkotlin/internal/jdk7/JDK7PlatformImplementations;", "<init>", "()V", "sdkIsNullOrAtLeast", "", "version", "", "getMatchResultNamedGroup", "Lkotlin/text/MatchGroup;", "matchResult", "Ljava/util/regex/MatchResult;", "name", "", "defaultPlatformRandom", "Lkotlin/random/Random;", "getSystemClock", "Lkotlin/time/Clock;", "ReflectSdkVersion", "kotlin-stdlib-jdk8"})
public class JDK8PlatformImplementations
extends JDK7PlatformImplementations {
    private final boolean sdkIsNullOrAtLeast(int n) {
        return ReflectSdkVersion.sdkVersion == null || ReflectSdkVersion.sdkVersion >= n;
    }

    @Override
    public MatchGroup getMatchResultNamedGroup(MatchResult matchResult, String string) {
        Intrinsics.checkNotNullParameter(matchResult, "");
        Intrinsics.checkNotNullParameter(string, "");
        Matcher matcher = matchResult instanceof Matcher ? (Matcher)matchResult : null;
        if (matcher == null) {
            throw new UnsupportedOperationException("Retrieving groups by name is not supported on this platform.");
        }
        matchResult = matcher;
        IntRange intRange = new IntRange(((Matcher)matchResult).start(string), ((Matcher)matchResult).end(string) - 1);
        if (intRange.getStart() >= 0) {
            String string2 = ((Matcher)matchResult).group(string);
            Intrinsics.checkNotNullExpressionValue(string2, "");
            return new MatchGroup(string2, intRange);
        }
        return null;
    }

    @Override
    public Random defaultPlatformRandom() {
        if (this.sdkIsNullOrAtLeast(34)) {
            return new PlatformThreadLocalRandom();
        }
        return super.defaultPlatformRandom();
    }

    @Override
    public Clock getSystemClock() {
        if (this.sdkIsNullOrAtLeast(26)) {
            return new Clock(){

                public final kotlin.time.Instant now() {
                    Instant instant = Instant.now();
                    Intrinsics.checkNotNullExpressionValue(instant, "");
                    return InstantConversionsJDK8Kt.toKotlinInstant(instant);
                }
            };
        }
        return new Clock(){

            public final kotlin.time.Instant now() {
                return kotlin.time.Instant.Companion.fromEpochMilliseconds(System.currentTimeMillis());
            }
        };
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lkotlin/internal/jdk8/JDK8PlatformImplementations$ReflectSdkVersion;", "", "<init>", "()V", "sdkVersion", "", "Ljava/lang/Integer;", "kotlin-stdlib-jdk8"})
    private static final class ReflectSdkVersion {
        public static final ReflectSdkVersion INSTANCE;
        public static final Integer sdkVersion;

        private ReflectSdkVersion() {
        }

        static {
            int n;
            Object object;
            INSTANCE = new ReflectSdkVersion();
            try {
                object = Class.forName("android.os.Build$VERSION").getField("SDK_INT").get(null);
                object = object instanceof Integer ? (Integer)object : null;
            }
            catch (Throwable throwable) {
                object = null;
            }
            sdkVersion = object != null ? ((n = ((Number)object).intValue()) > 0 ? object : null) : null;
        }
    }
}

