/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

public final class CleartextHttp2ServerUpgradeHandler
extends ByteToMessageDecoder {
    private static final ByteBuf CONNECTION_PREFACE = Unpooled.unreleasableBuffer((ByteBuf)Http2CodecUtil.connectionPrefaceBuf()).asReadOnly();
    private final HttpServerCodec httpServerCodec;
    private final HttpServerUpgradeHandler httpServerUpgradeHandler;
    private final ChannelHandler http2ServerHandler;

    public CleartextHttp2ServerUpgradeHandler(HttpServerCodec httpServerCodec, HttpServerUpgradeHandler httpServerUpgradeHandler, ChannelHandler channelHandler) {
        this.httpServerCodec = (HttpServerCodec)ObjectUtil.checkNotNull((Object)httpServerCodec, (String)"httpServerCodec");
        this.httpServerUpgradeHandler = (HttpServerUpgradeHandler)ObjectUtil.checkNotNull((Object)httpServerUpgradeHandler, (String)"httpServerUpgradeHandler");
        this.http2ServerHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)channelHandler, (String)"http2ServerHandler");
    }

    public final void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), null, (ChannelHandler)this.httpServerUpgradeHandler).addAfter(channelHandlerContext.name(), null, (ChannelHandler)this.httpServerCodec);
    }

    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        int n = CONNECTION_PREFACE.readableBytes();
        int n2 = Math.min(byteBuf.readableBytes(), n);
        ByteBuf byteBuf2 = CONNECTION_PREFACE;
        ByteBuf byteBuf3 = byteBuf;
        if (!ByteBufUtil.equals((ByteBuf)byteBuf2, (int)byteBuf2.readerIndex(), (ByteBuf)byteBuf3, (int)byteBuf3.readerIndex(), (int)n2)) {
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
            return;
        }
        if (n2 == n) {
            channelHandlerContext.pipeline().remove((ChannelHandler)this.httpServerCodec).remove((ChannelHandler)this.httpServerUpgradeHandler);
            channelHandlerContext.pipeline().addAfter(channelHandlerContext.name(), null, this.http2ServerHandler);
            channelHandlerContext.pipeline().remove((ChannelHandler)this);
            channelHandlerContext.fireUserEventTriggered((Object)PriorKnowledgeUpgradeEvent.INSTANCE);
        }
    }

    public static final class PriorKnowledgeUpgradeEvent {
        private static final PriorKnowledgeUpgradeEvent INSTANCE = new PriorKnowledgeUpgradeEvent();

        private PriorKnowledgeUpgradeEvent() {
        }
    }
}

