/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackHeaderField;
import io.netty.handler.codec.http2.HpackHuffmanEncoder;
import io.netty.handler.codec.http2.HpackStaticTable;
import io.netty.handler.codec.http2.HpackUtil;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import java.util.Iterator;
import java.util.Map;

final class HpackEncoder {
    static final int NOT_FOUND = -1;
    static final int HUFF_CODE_THRESHOLD = 512;
    private final NameEntry[] nameEntries;
    private final NameValueEntry[] nameValueEntries;
    private final NameValueEntry head;
    private NameValueEntry latest;
    private final HpackHuffmanEncoder hpackHuffmanEncoder;
    private final byte hashMask;
    private final boolean ignoreMaxHeaderListSize;
    private final int huffCodeThreshold;
    private long size;
    private long maxHeaderTableSize;
    private long maxHeaderListSize;

    HpackEncoder() {
        this(false);
    }

    HpackEncoder(boolean bl) {
        this(bl, 64, 512);
    }

    HpackEncoder(boolean bl, int n, int n2) {
        AsciiString asciiString = AsciiString.EMPTY_STRING;
        this.latest = this.head = new NameValueEntry(-1, (CharSequence)asciiString, (CharSequence)asciiString, Integer.MAX_VALUE, null);
        this.hpackHuffmanEncoder = new HpackHuffmanEncoder();
        this.ignoreMaxHeaderListSize = bl;
        this.maxHeaderTableSize = 4096L;
        this.maxHeaderListSize = 0xFFFFFFFFL;
        this.nameEntries = new NameEntry[MathUtil.findNextPositivePowerOfTwo((int)Math.max(2, Math.min(n, 128)))];
        this.nameValueEntries = new NameValueEntry[this.nameEntries.length];
        this.hashMask = (byte)(this.nameEntries.length - 1);
        this.huffCodeThreshold = n2;
    }

    public final void encodeHeaders(int n, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        if (this.ignoreMaxHeaderListSize) {
            this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, sensitivityDetector);
            return;
        }
        this.encodeHeadersEnforceMaxHeaderListSize(n, byteBuf, http2Headers, sensitivityDetector);
    }

    private void encodeHeadersEnforceMaxHeaderListSize(int n, ByteBuf byteBuf, Http2Headers http2Headers, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        long l = 0L;
        Iterator<Map.Entry<CharSequence, CharSequence>> iterator = http2Headers.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            CharSequence charSequence = object.getKey();
            if ((l += HpackHeaderField.sizeOf(charSequence, (CharSequence)(object = object.getValue()))) <= this.maxHeaderListSize) continue;
            Http2CodecUtil.headerListSizeExceeded(n, this.maxHeaderListSize, false);
        }
        this.encodeHeadersIgnoreMaxHeaderListSize(byteBuf, http2Headers, sensitivityDetector);
    }

    private void encodeHeadersIgnoreMaxHeaderListSize(ByteBuf byteBuf, Http2Headers object, Http2HeadersEncoder.SensitivityDetector sensitivityDetector) {
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            CharSequence charSequence = (CharSequence)object2.getKey();
            object2 = (CharSequence)object2.getValue();
            this.encodeHeader(byteBuf, charSequence, (CharSequence)object2, sensitivityDetector.isSensitive(charSequence, (CharSequence)object2), HpackHeaderField.sizeOf(charSequence, (CharSequence)object2));
        }
    }

    private void encodeHeader(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, boolean n, long l) {
        int n2;
        if (n) {
            n = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NEVER, n);
            return;
        }
        if (this.maxHeaderTableSize == 0L) {
            n = HpackStaticTable.getIndexInsensitive(charSequence, charSequence2);
            if (n == -1) {
                int n3 = HpackStaticTable.getIndex(charSequence);
                this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n3);
                return;
            }
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n);
            return;
        }
        if (l > this.maxHeaderTableSize) {
            n = this.getNameIndex(charSequence);
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.NONE, n);
            return;
        }
        n = AsciiString.hashCode((CharSequence)charSequence);
        NameValueEntry nameValueEntry = this.getEntryInsensitive(charSequence, n, charSequence2, n2 = AsciiString.hashCode((CharSequence)charSequence2));
        if (nameValueEntry != null) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, this.getIndexPlusOffset(nameValueEntry.counter));
            return;
        }
        int n4 = HpackStaticTable.getIndexInsensitive(charSequence, charSequence2);
        if (n4 != -1) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n4);
            return;
        }
        this.ensureCapacity(l);
        this.encodeAndAddEntries(byteBuf, charSequence, n, charSequence2, n2);
        this.size += l;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void encodeAndAddEntries(ByteBuf byteBuf, CharSequence charSequence, int n, CharSequence charSequence2, int n2) {
        int n3 = HpackStaticTable.getIndex(charSequence);
        int n4 = this.latestCounter() - 1;
        if (n3 != -1) {
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, n3);
            this.addNameValueEntry(HpackStaticTable.getEntry((int)n3).name, charSequence2, n, n2, n4);
            return;
        }
        NameEntry nameEntry = this.getEntry(charSequence, n);
        if (nameEntry == null) {
            this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, -1);
            this.addNameEntry(charSequence, n, n4);
            this.addNameValueEntry(charSequence, charSequence2, n, n2, n4);
            return;
        }
        this.encodeLiteral(byteBuf, charSequence, charSequence2, HpackUtil.IndexType.INCREMENTAL, this.getIndexPlusOffset(nameEntry.counter));
        this.addNameValueEntry(nameEntry.name, charSequence2, n, n2, n4);
        nameEntry.counter = n4;
    }

    public final void setMaxHeaderTableSize(ByteBuf byteBuf, long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header Table Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        if (this.maxHeaderTableSize == l) {
            return;
        }
        this.maxHeaderTableSize = l;
        this.ensureCapacity(0L);
        HpackEncoder.encodeInteger(byteBuf, 32, 5, l);
    }

    public final long getMaxHeaderTableSize() {
        return this.maxHeaderTableSize;
    }

    public final void setMaxHeaderListSize(long l) {
        if (l < 0L || l > 0xFFFFFFFFL) {
            throw Http2Exception.connectionError(Http2Error.PROTOCOL_ERROR, "Header List Size must be >= %d and <= %d but was %d", 0L, 0xFFFFFFFFL, l);
        }
        this.maxHeaderListSize = l;
    }

    public final long getMaxHeaderListSize() {
        return this.maxHeaderListSize;
    }

    private static void encodeInteger(ByteBuf byteBuf, int n, int n2, int n3) {
        HpackEncoder.encodeInteger(byteBuf, n, n2, (long)n3);
    }

    private static void encodeInteger(ByteBuf byteBuf, int n, int n2, long l) {
        assert (n2 >= 0 && n2 <= 8) : "N: " + n2;
        if (l < (long)(n2 = 255 >>> 8 - n2)) {
            byteBuf.writeByte((int)((long)n | l));
            return;
        }
        byteBuf.writeByte(n | n2);
        long l2 = l - (long)n2;
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            byteBuf.writeByte((int)(l2 & 0x7FL | 0x80L));
            l2 >>>= 7;
        }
        byteBuf.writeByte((int)l2);
    }

    private void encodeStringLiteral(ByteBuf byteBuf, CharSequence charSequence) {
        int n;
        if (charSequence.length() >= this.huffCodeThreshold && (n = this.hpackHuffmanEncoder.getEncodedLength(charSequence)) < charSequence.length()) {
            HpackEncoder.encodeInteger(byteBuf, 128, 7, n);
            this.hpackHuffmanEncoder.encode(byteBuf, charSequence);
            return;
        }
        HpackEncoder.encodeInteger(byteBuf, 0, 7, charSequence.length());
        if (charSequence instanceof AsciiString) {
            charSequence = (AsciiString)charSequence;
            byteBuf.writeBytes(charSequence.array(), charSequence.arrayOffset(), charSequence.length());
            return;
        }
        byteBuf.writeCharSequence(charSequence, CharsetUtil.ISO_8859_1);
    }

    private void encodeLiteral(ByteBuf byteBuf, CharSequence charSequence, CharSequence charSequence2, HpackUtil.IndexType indexType, int n) {
        boolean bl = n != -1;
        switch (indexType) {
            case INCREMENTAL: {
                HpackEncoder.encodeInteger(byteBuf, 64, 6, bl ? n : 0);
                break;
            }
            case NONE: {
                HpackEncoder.encodeInteger(byteBuf, 0, 4, bl ? n : 0);
                break;
            }
            case NEVER: {
                HpackEncoder.encodeInteger(byteBuf, 16, 4, bl ? n : 0);
                break;
            }
            default: {
                throw new Error("should not reach here");
            }
        }
        if (!bl) {
            this.encodeStringLiteral(byteBuf, charSequence);
        }
        this.encodeStringLiteral(byteBuf, charSequence2);
    }

    private int getNameIndex(CharSequence object) {
        int n = HpackStaticTable.getIndex((CharSequence)object);
        if (n != -1) {
            return n;
        }
        CharSequence charSequence = object;
        object = this.getEntry(charSequence, AsciiString.hashCode((CharSequence)charSequence));
        if (object == null) {
            return -1;
        }
        return this.getIndexPlusOffset(((NameEntry)object).counter);
    }

    private void ensureCapacity(long l) {
        while (this.maxHeaderTableSize - this.size < l) {
            this.remove();
        }
    }

    final int length() {
        if (this.isEmpty()) {
            return 0;
        }
        HpackEncoder hpackEncoder = this;
        return hpackEncoder.getIndex(hpackEncoder.head.after.counter);
    }

    final long size() {
        return this.size;
    }

    final HpackHeaderField getHeaderField(int n) {
        NameValueEntry nameValueEntry = this.head;
        while (n++ < this.length()) {
            nameValueEntry = nameValueEntry.after;
        }
        return nameValueEntry;
    }

    private NameValueEntry getEntryInsensitive(CharSequence charSequence, int n, CharSequence charSequence2, int n2) {
        n = HpackEncoder.hash(n, n2);
        NameValueEntry nameValueEntry = this.nameValueEntries[this.bucket(n)];
        while (nameValueEntry != null) {
            if (nameValueEntry.hash == n && HpackUtil.equalsVariableTime(charSequence2, nameValueEntry.value) && HpackUtil.equalsVariableTime(charSequence, nameValueEntry.name)) {
                return nameValueEntry;
            }
            nameValueEntry = nameValueEntry.next;
        }
        return null;
    }

    private NameEntry getEntry(CharSequence charSequence, int n) {
        NameEntry nameEntry = this.nameEntries[this.bucket(n)];
        while (nameEntry != null) {
            if (nameEntry.hash == n && HpackUtil.equalsConstantTime(charSequence, nameEntry.name) != 0) {
                return nameEntry;
            }
            nameEntry = nameEntry.next;
        }
        return null;
    }

    private int getIndexPlusOffset(int n) {
        return this.getIndex(n) + HpackStaticTable.length;
    }

    private int getIndex(int n) {
        return n - this.latestCounter() + 1;
    }

    private int latestCounter() {
        return this.latest.counter;
    }

    private void addNameEntry(CharSequence charSequence, int n, int n2) {
        int n3 = this.bucket(n);
        this.nameEntries[n3] = new NameEntry(n, charSequence, n2, this.nameEntries[n3]);
    }

    private void addNameValueEntry(CharSequence object, CharSequence charSequence, int n, int n2, int n3) {
        n = HpackEncoder.hash(n, n2);
        n2 = this.bucket(n);
        this.nameValueEntries[n2] = object = new NameValueEntry(n, (CharSequence)object, charSequence, n3, this.nameValueEntries[n2]);
        this.latest.after = object;
        this.latest = object;
    }

    private void remove() {
        NameValueEntry nameValueEntry = this.head.after;
        this.removeNameValueEntry(nameValueEntry);
        this.removeNameEntryMatchingCounter(nameValueEntry.name, nameValueEntry.counter);
        this.head.after = nameValueEntry.after;
        nameValueEntry.unlink();
        this.size -= (long)nameValueEntry.size();
        if (this.isEmpty()) {
            this.latest = this.head;
        }
    }

    private boolean isEmpty() {
        return this.size == 0L;
    }

    private void removeNameValueEntry(NameValueEntry nameValueEntry) {
        int n = this.bucket(nameValueEntry.hash);
        NameValueEntry nameValueEntry2 = this.nameValueEntries[n];
        if (nameValueEntry2 == nameValueEntry) {
            this.nameValueEntries[n] = nameValueEntry.next;
            return;
        }
        while (nameValueEntry2.next != nameValueEntry) {
            nameValueEntry2 = nameValueEntry2.next;
        }
        nameValueEntry2.next = nameValueEntry.next;
    }

    private void removeNameEntryMatchingCounter(CharSequence charSequence, int n) {
        int n2 = AsciiString.hashCode((CharSequence)charSequence);
        NameEntry nameEntry = this.nameEntries[n2 = this.bucket(n2)];
        if (nameEntry == null) {
            return;
        }
        if (n == nameEntry.counter) {
            this.nameEntries[n2] = nameEntry.next;
            nameEntry.unlink();
            return;
        }
        NameEntry nameEntry2 = nameEntry;
        nameEntry = nameEntry.next;
        while (nameEntry != null) {
            if (n == nameEntry.counter) {
                nameEntry2.next = nameEntry.next;
                nameEntry.unlink();
                return;
            }
            nameEntry2 = nameEntry;
            nameEntry = nameEntry.next;
        }
    }

    private int bucket(int n) {
        return n & this.hashMask;
    }

    private static int hash(int n, int n2) {
        return n * 31 + n2;
    }

    private static final class NameValueEntry
    extends HpackHeaderField {
        NameValueEntry after;
        NameValueEntry next;
        final int hash;
        final int counter;

        NameValueEntry(int n, CharSequence charSequence, CharSequence charSequence2, int n2, NameValueEntry nameValueEntry) {
            super(charSequence, charSequence2);
            this.next = nameValueEntry;
            this.hash = n;
            this.counter = n2;
        }

        final void unlink() {
            this.after = null;
            this.next = null;
        }
    }

    private static final class NameEntry {
        NameEntry next;
        final CharSequence name;
        final int hash;
        int counter;

        NameEntry(int n, CharSequence charSequence, int n2, NameEntry nameEntry) {
            this.hash = n;
            this.name = charSequence;
            this.counter = n2;
            this.next = nameEntry;
        }

        final void unlink() {
            this.next = null;
        }
    }
}

