/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ServerChannel;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.channel.socket.ChannelOutputShutdownEvent;
import io.netty.handler.codec.http2.AbstractHttp2StreamChannel;
import io.netty.handler.codec.http2.Http2ChannelDuplexHandler;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Frame;
import io.netty.handler.codec.http2.Http2FrameCodec;
import io.netty.handler.codec.http2.Http2FrameStream;
import io.netty.handler.codec.http2.Http2FrameStreamEvent;
import io.netty.handler.codec.http2.Http2FrameStreamException;
import io.netty.handler.codec.http2.Http2FrameStreamVisitor;
import io.netty.handler.codec.http2.Http2GoAwayFrame;
import io.netty.handler.codec.http2.Http2MultiplexActiveStreamsException;
import io.netty.handler.codec.http2.Http2PriorityFrame;
import io.netty.handler.codec.http2.Http2ResetFrame;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.handler.codec.http2.Http2StreamFrame;
import io.netty.handler.codec.http2.Http2WindowUpdateFrame;
import io.netty.handler.codec.http2.MaxCapacityQueue;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.ArrayDeque;
import java.util.Queue;
import javax.net.ssl.SSLException;

public final class Http2MultiplexHandler
extends Http2ChannelDuplexHandler {
    static final ChannelFutureListener CHILD_CHANNEL_REGISTRATION_LISTENER = new ChannelFutureListener(){

        public final void operationComplete(ChannelFuture channelFuture) {
            Http2MultiplexHandler.registerDone(channelFuture);
        }
    };
    private final ChannelHandler inboundStreamHandler;
    private final ChannelHandler upgradeStreamHandler;
    private final Queue<AbstractHttp2StreamChannel> readCompletePendingQueue = new MaxCapacityQueue<AbstractHttp2StreamChannel>(new ArrayDeque(8), 100);
    private boolean parentReadInProgress;
    private int idCount;
    private volatile ChannelHandlerContext ctx;

    public Http2MultiplexHandler(ChannelHandler channelHandler) {
        this(channelHandler, null);
    }

    public Http2MultiplexHandler(ChannelHandler channelHandler, ChannelHandler channelHandler2) {
        this.inboundStreamHandler = (ChannelHandler)ObjectUtil.checkNotNull((Object)channelHandler, (String)"inboundStreamHandler");
        this.upgradeStreamHandler = channelHandler2;
    }

    static void registerDone(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            if ((channelFuture = channelFuture.channel()).isRegistered()) {
                channelFuture.close();
                return;
            }
            channelFuture.unsafe().closeForcibly();
        }
    }

    @Override
    protected final void handlerAdded0(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.executor() != channelHandlerContext.channel().eventLoop()) {
            throw new IllegalStateException("EventExecutor must be EventLoop of Channel");
        }
        this.ctx = channelHandlerContext;
    }

    @Override
    protected final void handlerRemoved0(ChannelHandlerContext channelHandlerContext) {
        this.readCompletePendingQueue.clear();
    }

    public final void channelRead(ChannelHandlerContext object, Object object2) {
        this.parentReadInProgress = true;
        if (object2 instanceof Http2StreamFrame) {
            if (object2 instanceof Http2WindowUpdateFrame) {
                return;
            }
            object = (Http2StreamFrame)object2;
            Object object3 = (Http2FrameCodec.DefaultHttp2FrameStream)object.stream();
            object3 = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object3).attachment;
            if (object2 instanceof Http2ResetFrame || object2 instanceof Http2PriorityFrame) {
                ((AbstractHttp2StreamChannel)object3).pipeline().fireUserEventTriggered(object2);
                return;
            }
            ((AbstractHttp2StreamChannel)object3).fireChildRead((Http2Frame)object);
            return;
        }
        if (object2 instanceof Http2GoAwayFrame) {
            this.onHttp2GoAwayFrame((ChannelHandlerContext)object, (Http2GoAwayFrame)object2);
        }
        object.fireChannelRead(object2);
    }

    public final void channelWritabilityChanged(ChannelHandlerContext channelHandlerContext) {
        if (channelHandlerContext.channel().isWritable()) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.WRITABLE_VISITOR);
        }
        channelHandlerContext.fireChannelWritabilityChanged();
    }

    public final void userEventTriggered(ChannelHandlerContext object, Object object2) {
        if (object2 instanceof Http2FrameStreamEvent) {
            object2 = (Http2FrameStreamEvent)object2;
            Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream = (Http2FrameCodec.DefaultHttp2FrameStream)((Http2FrameStreamEvent)object2).stream();
            if (((Http2FrameStreamEvent)object2).type() == Http2FrameStreamEvent.Type.State) {
                switch (defaultHttp2FrameStream.state()) {
                    case HALF_CLOSED_LOCAL: {
                        if (defaultHttp2FrameStream.id() != 1) break;
                    }
                    case HALF_CLOSED_REMOTE: 
                    case OPEN: {
                        if (defaultHttp2FrameStream.attachment != null) break;
                        if (defaultHttp2FrameStream.id() == 1 && !Http2MultiplexHandler.isServer((ChannelHandlerContext)object)) {
                            if (this.upgradeStreamHandler == null) {
                                throw Http2Exception.connectionError(Http2Error.INTERNAL_ERROR, "Client is misconfigured for upgrade requests", new Object[0]);
                            }
                            object2 = new Http2MultiplexHandlerStreamChannel(defaultHttp2FrameStream, this.upgradeStreamHandler);
                            ((AbstractHttp2StreamChannel)object2).closeOutbound();
                        } else {
                            object2 = new Http2MultiplexHandlerStreamChannel(defaultHttp2FrameStream, this.inboundStreamHandler);
                        }
                        object = object.channel().eventLoop().register((Channel)object2);
                        if (object.isDone()) {
                            Http2MultiplexHandler.registerDone((ChannelFuture)object);
                            return;
                        }
                        object.addListener((GenericFutureListener)CHILD_CHANNEL_REGISTRATION_LISTENER);
                        return;
                    }
                    case CLOSED: {
                        object = (AbstractHttp2StreamChannel)defaultHttp2FrameStream.attachment;
                        if (object == null) break;
                        ((AbstractHttp2StreamChannel)object).streamClosed();
                    }
                }
            }
            return;
        }
        if (object2 == ChannelInputShutdownReadComplete.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_INPUT_SHUTDOWN_READ_COMPLETE_VISITOR);
        } else if (object2 == ChannelOutputShutdownEvent.INSTANCE) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.CHANNEL_OUTPUT_SHUTDOWN_EVENT_VISITOR);
        } else if (object2 == SslCloseCompletionEvent.SUCCESS) {
            this.forEachActiveStream(AbstractHttp2StreamChannel.SSL_CLOSE_COMPLETION_EVENT_VISITOR);
        }
        object.fireUserEventTriggered(object2);
    }

    final Http2StreamChannel newOutboundStream() {
        Http2MultiplexHandler http2MultiplexHandler = this;
        return http2MultiplexHandler.new Http2MultiplexHandlerStreamChannel((Http2FrameCodec.DefaultHttp2FrameStream)http2MultiplexHandler.newStream(), null);
    }

    public final void exceptionCaught(ChannelHandlerContext object, Throwable throwable) {
        if (throwable instanceof Http2FrameStreamException) {
            object = (Http2FrameStreamException)throwable;
            Object object2 = ((Http2FrameStreamException)object).stream();
            object2 = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object2).attachment;
            try {
                ((AbstractHttp2StreamChannel)object2).pipeline().fireExceptionCaught(throwable.getCause());
                return;
            }
            finally {
                ((AbstractHttp2StreamChannel)object2).closeWithError(((Http2FrameStreamException)object).error());
            }
        }
        if (throwable instanceof Http2MultiplexActiveStreamsException) {
            this.fireExceptionCaughtForActiveStream(throwable.getCause());
            return;
        }
        if (throwable.getCause() instanceof SSLException) {
            this.fireExceptionCaughtForActiveStream(throwable);
        }
        object.fireExceptionCaught(throwable);
    }

    private void fireExceptionCaughtForActiveStream(final Throwable throwable) {
        this.forEachActiveStream(new Http2FrameStreamVisitor(){

            @Override
            public boolean visit(Http2FrameStream object) {
                object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
                ((AbstractHttp2StreamChannel)object).pipeline().fireExceptionCaught(throwable);
                return true;
            }
        });
    }

    private static boolean isServer(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext.channel().parent() instanceof ServerChannel;
    }

    private void onHttp2GoAwayFrame(ChannelHandlerContext channelHandlerContext, final Http2GoAwayFrame http2GoAwayFrame) {
        if (http2GoAwayFrame.lastStreamId() == Integer.MAX_VALUE) {
            return;
        }
        try {
            final boolean bl = Http2MultiplexHandler.isServer(channelHandlerContext);
            this.forEachActiveStream(new Http2FrameStreamVisitor(){

                @Override
                public boolean visit(Http2FrameStream object) {
                    int n = object.id();
                    if (n > http2GoAwayFrame.lastStreamId() && Http2CodecUtil.isStreamIdValid(n, bl)) {
                        object = (AbstractHttp2StreamChannel)((Http2FrameCodec.DefaultHttp2FrameStream)object).attachment;
                        ((AbstractHttp2StreamChannel)object).pipeline().fireUserEventTriggered((Object)http2GoAwayFrame.retainedDuplicate());
                    }
                    return true;
                }
            });
            return;
        }
        catch (Http2Exception http2Exception) {
            channelHandlerContext.fireExceptionCaught((Throwable)http2Exception);
            channelHandlerContext.close();
            return;
        }
    }

    public final void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.processPendingReadCompleteQueue();
        channelHandlerContext.fireChannelReadComplete();
    }

    private void processPendingReadCompleteQueue() {
        this.parentReadInProgress = true;
        AbstractHttp2StreamChannel abstractHttp2StreamChannel = this.readCompletePendingQueue.poll();
        if (abstractHttp2StreamChannel != null) {
            try {
                do {
                    abstractHttp2StreamChannel.fireChildReadComplete();
                } while ((abstractHttp2StreamChannel = this.readCompletePendingQueue.poll()) != null);
            }
            finally {
                this.parentReadInProgress = false;
                this.readCompletePendingQueue.clear();
                this.ctx.flush();
            }
        } else {
            this.parentReadInProgress = false;
        }
    }

    private final class Http2MultiplexHandlerStreamChannel
    extends AbstractHttp2StreamChannel {
        Http2MultiplexHandlerStreamChannel(Http2FrameCodec.DefaultHttp2FrameStream defaultHttp2FrameStream, ChannelHandler channelHandler) {
            super(defaultHttp2FrameStream, ++Http2MultiplexHandler.this.idCount, channelHandler);
        }

        @Override
        protected final boolean isParentReadInProgress() {
            return Http2MultiplexHandler.this.parentReadInProgress;
        }

        @Override
        protected final void addChannelToReadCompletePendingQueue() {
            while (!Http2MultiplexHandler.this.readCompletePendingQueue.offer(this)) {
                Http2MultiplexHandler.this.processPendingReadCompleteQueue();
            }
        }

        @Override
        protected final ChannelHandlerContext parentContext() {
            return Http2MultiplexHandler.this.ctx;
        }
    }
}

