/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2MultiplexCodec;
import io.netty.handler.codec.http2.Http2MultiplexHandler;
import io.netty.handler.codec.http2.Http2StreamChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.channels.ClosedChannelException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Http2StreamChannelBootstrap {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Http2StreamChannelBootstrap.class);
    private static final Map.Entry<ChannelOption<?>, Object>[] EMPTY_OPTION_ARRAY = new Map.Entry[0];
    private static final Map.Entry<AttributeKey<?>, Object>[] EMPTY_ATTRIBUTE_ARRAY = new Map.Entry[0];
    private final Map<ChannelOption<?>, Object> options = new LinkedHashMap();
    private final Map<AttributeKey<?>, Object> attrs = new ConcurrentHashMap();
    private final Channel channel;
    private volatile ChannelHandler handler;
    private volatile ChannelHandlerContext multiplexCtx;

    public Http2StreamChannelBootstrap(Channel channel) {
        this.channel = (Channel)ObjectUtil.checkNotNull((Object)channel, (String)"channel");
    }

    public final <T> Http2StreamChannelBootstrap option(ChannelOption<T> channelOption, T t) {
        ObjectUtil.checkNotNull(channelOption, (String)"option");
        Map<ChannelOption<?>, Object> map = this.options;
        synchronized (map) {
            if (t == null) {
                this.options.remove(channelOption);
            } else {
                this.options.put(channelOption, t);
            }
        }
        return this;
    }

    public final <T> Http2StreamChannelBootstrap attr(AttributeKey<T> attributeKey, T t) {
        ObjectUtil.checkNotNull(attributeKey, (String)"key");
        if (t == null) {
            this.attrs.remove(attributeKey);
        } else {
            this.attrs.put(attributeKey, t);
        }
        return this;
    }

    public final Http2StreamChannelBootstrap handler(ChannelHandler channelHandler) {
        this.handler = (ChannelHandler)ObjectUtil.checkNotNull((Object)channelHandler, (String)"handler");
        return this;
    }

    public final Future<Http2StreamChannel> open() {
        Http2StreamChannelBootstrap http2StreamChannelBootstrap = this;
        return http2StreamChannelBootstrap.open((Promise<Http2StreamChannel>)http2StreamChannelBootstrap.channel.eventLoop().newPromise());
    }

    public final Future<Http2StreamChannel> open(final Promise<Http2StreamChannel> promise) {
        try {
            final ChannelHandlerContext channelHandlerContext = this.findCtx();
            EventExecutor eventExecutor = channelHandlerContext.executor();
            if (eventExecutor.inEventLoop()) {
                this.open0(channelHandlerContext, promise);
            } else {
                eventExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (Http2StreamChannelBootstrap.this.channel.isActive()) {
                            Http2StreamChannelBootstrap.this.open0(channelHandlerContext, (Promise<Http2StreamChannel>)promise);
                            return;
                        }
                        promise.setFailure((Throwable)new ClosedChannelException());
                    }
                });
            }
        }
        catch (Throwable throwable) {
            promise.setFailure(throwable);
        }
        return promise;
    }

    private ChannelHandlerContext findCtx() {
        ChannelHandlerContext channelHandlerContext = this.multiplexCtx;
        if (channelHandlerContext != null && !channelHandlerContext.isRemoved()) {
            return channelHandlerContext;
        }
        ChannelPipeline channelPipeline = this.channel.pipeline();
        channelHandlerContext = channelPipeline.context(Http2MultiplexCodec.class);
        if (channelHandlerContext == null) {
            channelHandlerContext = channelPipeline.context(Http2MultiplexHandler.class);
        }
        if (channelHandlerContext == null) {
            if (this.channel.isActive()) {
                throw new IllegalStateException(StringUtil.simpleClassName(Http2MultiplexCodec.class) + " or " + StringUtil.simpleClassName(Http2MultiplexHandler.class) + " must be in the ChannelPipeline of Channel " + this.channel);
            }
            throw new ClosedChannelException();
        }
        this.multiplexCtx = channelHandlerContext;
        return channelHandlerContext;
    }

    @Deprecated
    public final void open0(ChannelHandlerContext channelHandlerContext, final Promise<Http2StreamChannel> promise) {
        Http2StreamChannel http2StreamChannel;
        assert (channelHandlerContext.executor().inEventLoop());
        if (!promise.setUncancellable()) {
            return;
        }
        try {
            http2StreamChannel = channelHandlerContext.handler() instanceof Http2MultiplexCodec ? ((Http2MultiplexCodec)channelHandlerContext.handler()).newOutboundStream() : ((Http2MultiplexHandler)channelHandlerContext.handler()).newOutboundStream();
        }
        catch (Exception exception) {
            promise.setFailure((Throwable)exception);
            return;
        }
        try {
            this.init(http2StreamChannel);
        }
        catch (Exception exception) {
            http2StreamChannel.unsafe().closeForcibly();
            promise.setFailure((Throwable)exception);
            return;
        }
        channelHandlerContext = channelHandlerContext.channel().eventLoop().register((Channel)http2StreamChannel);
        channelHandlerContext.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) {
                if (channelFuture.isSuccess()) {
                    promise.setSuccess((Object)http2StreamChannel);
                    return;
                }
                if (channelFuture.isCancelled()) {
                    promise.cancel(false);
                    return;
                }
                if (http2StreamChannel.isRegistered()) {
                    http2StreamChannel.close();
                } else {
                    http2StreamChannel.unsafe().closeForcibly();
                }
                promise.setFailure(channelFuture.cause());
            }
        });
    }

    private void init(Channel channel) {
        Map.Entry<ChannelOption<?>, Object>[] entryArray = channel.pipeline();
        Object object = this.handler;
        if (object != null) {
            entryArray.addLast(new ChannelHandler[]{object});
        }
        object = this.options;
        synchronized (object) {
            entryArray = this.options.entrySet().toArray(EMPTY_OPTION_ARRAY);
        }
        Http2StreamChannelBootstrap.setChannelOptions(channel, entryArray);
        Http2StreamChannelBootstrap.setAttributes(channel, this.attrs.entrySet().toArray(EMPTY_ATTRIBUTE_ARRAY));
    }

    private static void setChannelOptions(Channel channel, Map.Entry<ChannelOption<?>, Object>[] entryArray) {
        for (Map.Entry<ChannelOption<?>, Object> entry : entryArray) {
            Http2StreamChannelBootstrap.setChannelOption(channel, entry.getKey(), entry.getValue());
        }
    }

    private static void setChannelOption(Channel channel, ChannelOption<?> channelOption, Object object) {
        try {
            ChannelOption<?> channelOption2 = channelOption;
            if (!channel.config().setOption(channelOption2, object)) {
                logger.warn("Unknown channel option '{}' for channel '{}'", channelOption, (Object)channel);
            }
            return;
        }
        catch (Throwable throwable) {
            logger.warn("Failed to set channel option '{}' with value '{}' for channel '{}'", new Object[]{channelOption, object, channel, throwable});
            return;
        }
    }

    private static void setAttributes(Channel channel, Map.Entry<AttributeKey<?>, Object>[] entryArray) {
        for (Map.Entry<AttributeKey<?>, Object> entry : entryArray) {
            AttributeKey<?> attributeKey = entry.getKey();
            channel.attr(attributeKey).set(entry.getValue());
        }
    }
}

