/*
 * Decompiled with CFR 0.152.
 */
package org.nibor.autolink.internal;

import org.nibor.autolink.LinkSpan;
import org.nibor.autolink.LinkType;
import org.nibor.autolink.internal.LinkSpanImpl;
import org.nibor.autolink.internal.Scanner;
import org.nibor.autolink.internal.Scanners;

public class EmailScanner
implements Scanner {
    private final boolean domainMustHaveDot;

    public EmailScanner(boolean bl) {
        this.domainMustHaveDot = bl;
    }

    @Override
    public LinkSpan scan(CharSequence charSequence, int n, int n2) {
        int n3;
        int n4 = n - 1;
        if ((n2 = this.findFirst(charSequence, n4, n2)) == -1) {
            return null;
        }
        if ((n3 = this.findLast(charSequence, ++n)) == -1) {
            return null;
        }
        return new LinkSpanImpl(LinkType.EMAIL, n2, n3 + 1);
    }

    private int findFirst(CharSequence charSequence, int n, int n2) {
        int n3 = -1;
        boolean bl = true;
        while (n >= n2) {
            char c = charSequence.charAt(n);
            if (this.localAtomAllowed(c)) {
                n3 = n;
                bl = false;
            } else {
                if (c != '.' || bl) break;
                bl = true;
            }
            --n;
        }
        return n3;
    }

    private int findLast(CharSequence charSequence, int n) {
        boolean bl = true;
        boolean bl2 = false;
        int n2 = -1;
        int n3 = -1;
        while (n < charSequence.length()) {
            char c = charSequence.charAt(n);
            if (bl) {
                if (!this.subDomainAllowed(c)) break;
                n3 = n;
                bl = false;
                bl2 = true;
            } else if (c == '.') {
                if (!bl2) break;
                bl = true;
                if (n2 == -1) {
                    n2 = n;
                }
            } else if (c == '-') {
                bl2 = false;
            } else {
                if (!this.subDomainAllowed(c)) break;
                n3 = n;
                bl2 = true;
            }
            ++n;
        }
        if (this.domainMustHaveDot && (n2 == -1 || n2 > n3)) {
            return -1;
        }
        return n3;
    }

    private boolean localAtomAllowed(char c) {
        if (Scanners.isAlnum(c) || Scanners.isNonAscii(c)) {
            return true;
        }
        switch (c) {
            case '!': 
            case '#': 
            case '$': 
            case '%': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '=': 
            case '?': 
            case '^': 
            case '_': 
            case '`': 
            case '{': 
            case '|': 
            case '}': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private boolean subDomainAllowed(char c) {
        return Scanners.isAlnum(c) || Scanners.isNonAscii(c);
    }
}

