/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassOrPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.DescriptorVisibility;
import kotlin.reflect.jvm.internal.impl.descriptors.Modality;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.descriptors.NotFoundClasses$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterUtilsKt;
import kotlin.reflect.jvm.internal.impl.descriptors.ValueClassRepresentation;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.ClassDescriptorBase;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.EmptyPackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.impl.TypeParameterDescriptorImpl;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.storage.MemoizedFunctionToNotNull;
import kotlin.reflect.jvm.internal.impl.storage.StorageManager;
import kotlin.reflect.jvm.internal.impl.types.ClassTypeConstructorImpl;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;

public final class NotFoundClasses {
    private final StorageManager storageManager;
    private final ModuleDescriptor module;
    private final MemoizedFunctionToNotNull<FqName, PackageFragmentDescriptor> packageFragments;
    private final MemoizedFunctionToNotNull<ClassRequest, ClassDescriptor> classes;

    public NotFoundClasses(StorageManager object, ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"");
        this.storageManager = object;
        this.module = moduleDescriptor;
        object = this;
        this.packageFragments = this.storageManager.createMemoizedFunction(new NotFoundClasses$$Lambda$0((NotFoundClasses)object));
        object = this;
        this.classes = this.storageManager.createMemoizedFunction(new NotFoundClasses$$Lambda$1((NotFoundClasses)object));
    }

    public final ClassDescriptor getClass(ClassId classId, List<Integer> list) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        return (ClassDescriptor)this.classes.invoke(new ClassRequest(classId, list));
    }

    private static final PackageFragmentDescriptor packageFragments$lambda$0(NotFoundClasses notFoundClasses, FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"");
        return new EmptyPackageFragmentDescriptor(notFoundClasses.module, fqName);
    }

    private static final ClassDescriptor classes$lambda$2(NotFoundClasses notFoundClasses, ClassRequest object) {
        Object object2;
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        ClassId classId = ((ClassRequest)object).component1();
        object = ((ClassRequest)object).component2();
        if (classId.isLocal()) {
            throw new UnsupportedOperationException("Unresolved local class: " + classId);
        }
        Object object3 = classId.getOuterClassId();
        object2 = object3 != null && (object3 = notFoundClasses.getClass((ClassId)(object2 = object3), CollectionsKt.drop((Iterable)((Iterable)object), (int)1))) != null ? (ClassOrPackageFragmentDescriptor)object3 : (ClassOrPackageFragmentDescriptor)notFoundClasses.packageFragments.invoke(classId.getPackageFqName());
        boolean bl = classId.isNestedClass();
        Integer n = (Integer)CollectionsKt.firstOrNull((List)object);
        return new MockClassDescriptor(notFoundClasses.storageManager, (DeclarationDescriptor)object2, classId.getShortClassName(), bl, n != null ? n : 0);
    }

    static /* synthetic */ PackageFragmentDescriptor accessor$NotFoundClasses$lambda0(NotFoundClasses notFoundClasses, FqName fqName) {
        return NotFoundClasses.packageFragments$lambda$0(notFoundClasses, fqName);
    }

    static /* synthetic */ ClassDescriptor accessor$NotFoundClasses$lambda1(NotFoundClasses notFoundClasses, ClassRequest classRequest) {
        return NotFoundClasses.classes$lambda$2(notFoundClasses, classRequest);
    }

    private static final class ClassRequest {
        private final ClassId classId;
        private final List<Integer> typeParametersCount;

        public ClassRequest(ClassId classId, List<Integer> list) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"");
            Intrinsics.checkNotNullParameter(list, (String)"");
            this.classId = classId;
            this.typeParametersCount = list;
        }

        public final ClassId component1() {
            return this.classId;
        }

        public final List<Integer> component2() {
            return this.typeParametersCount;
        }

        public final String toString() {
            return "ClassRequest(classId=" + this.classId + ", typeParametersCount=" + this.typeParametersCount + ')';
        }

        public final int hashCode() {
            int n = this.classId.hashCode();
            n = n * 31 + ((Object)this.typeParametersCount).hashCode();
            return n;
        }

        public final boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ClassRequest)) {
                return false;
            }
            object = (ClassRequest)object;
            if (!Intrinsics.areEqual((Object)this.classId, (Object)((ClassRequest)object).classId)) {
                return false;
            }
            return Intrinsics.areEqual(this.typeParametersCount, ((ClassRequest)object).typeParametersCount);
        }
    }

    public static final class MockClassDescriptor
    extends ClassDescriptorBase {
        private final boolean isInner;
        private final List<TypeParameterDescriptor> declaredTypeParameters;
        private final ClassTypeConstructorImpl typeConstructor;

        /*
         * WARNING - void declaration
         */
        public MockClassDescriptor(StorageManager storageManager, DeclarationDescriptor object, Name iterator2, boolean bl, int n) {
            void mockClassDescriptor;
            Intrinsics.checkNotNullParameter((Object)storageManager, (String)"");
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            Intrinsics.checkNotNullParameter(iterator2, (String)"");
            super(storageManager, (DeclarationDescriptor)object, (Name)((Object)iterator2), SourceElement.NO_SOURCE, false);
            this.isInner = bl;
            object = (Iterable)RangesKt.until((int)0, (int)mockClassDescriptor);
            MockClassDescriptor mockClassDescriptor2 = this;
            iterator2 = object;
            object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                int n2 = ((IntIterator)iterator2).nextInt();
                Object object2 = object;
                object2.add(TypeParameterDescriptorImpl.createWithDefaultBound(this, Annotations.Companion.getEMPTY(), false, Variance.INVARIANT, Name.identifier("T" + n2), n2, storageManager));
            }
            mockClassDescriptor2.declaredTypeParameters = (List)object;
            this.typeConstructor = new ClassTypeConstructorImpl(this, TypeParameterUtilsKt.computeConstructorTypeParameters(this), SetsKt.setOf((Object)DescriptorUtilsKt.getModule(this).getBuiltIns().getAnyType()), storageManager);
        }

        @Override
        public final ClassKind getKind() {
            return ClassKind.CLASS;
        }

        @Override
        public final Modality getModality() {
            return Modality.FINAL;
        }

        @Override
        public final DescriptorVisibility getVisibility() {
            DescriptorVisibility descriptorVisibility = DescriptorVisibilities.PUBLIC;
            Intrinsics.checkNotNullExpressionValue((Object)descriptorVisibility, (String)"");
            return descriptorVisibility;
        }

        @Override
        public final ClassTypeConstructorImpl getTypeConstructor() {
            return this.typeConstructor;
        }

        @Override
        public final List<TypeParameterDescriptor> getDeclaredTypeParameters() {
            return this.declaredTypeParameters;
        }

        @Override
        public final boolean isInner() {
            return this.isInner;
        }

        @Override
        public final boolean isCompanionObject() {
            return false;
        }

        @Override
        public final boolean isData() {
            return false;
        }

        @Override
        public final boolean isInline() {
            return false;
        }

        @Override
        public final boolean isFun() {
            return false;
        }

        @Override
        public final boolean isValue() {
            return false;
        }

        @Override
        public final boolean isExpect() {
            return false;
        }

        @Override
        public final boolean isActual() {
            return false;
        }

        @Override
        public final boolean isExternal() {
            return false;
        }

        @Override
        public final Annotations getAnnotations() {
            return Annotations.Companion.getEMPTY();
        }

        @Override
        protected final MemberScope.Empty getUnsubstitutedMemberScope(KotlinTypeRefiner kotlinTypeRefiner) {
            Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
            return MemberScope.Empty.INSTANCE;
        }

        @Override
        public final MemberScope.Empty getStaticScope() {
            return MemberScope.Empty.INSTANCE;
        }

        @Override
        public final Collection<ClassConstructorDescriptor> getConstructors() {
            return SetsKt.emptySet();
        }

        @Override
        public final ClassConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
            return null;
        }

        @Override
        public final ClassDescriptor getCompanionObjectDescriptor() {
            return null;
        }

        @Override
        public final Collection<ClassDescriptor> getSealedSubclasses() {
            return CollectionsKt.emptyList();
        }

        @Override
        public final ValueClassRepresentation<SimpleType> getValueClassRepresentation() {
            return null;
        }

        public final String toString() {
            return "class " + this.getName() + " (not found)";
        }
    }
}

