/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.descriptors.java;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibilities;
import kotlin.reflect.jvm.internal.impl.descriptors.Visibility;

public final class JavaVisibilities {
    public static final JavaVisibilities INSTANCE = new JavaVisibilities();

    private JavaVisibilities() {
    }

    public static final class PackageVisibility
    extends Visibility {
        public static final PackageVisibility INSTANCE = new PackageVisibility();

        private PackageVisibility() {
            super("package", false);
        }

        @Override
        public final Integer compareTo(Visibility visibility) {
            Intrinsics.checkNotNullParameter((Object)visibility, (String)"");
            if (this == visibility) {
                return 0;
            }
            if (Visibilities.INSTANCE.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        public final Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        public final String getInternalDisplayName() {
            return "public/*package*/";
        }
    }

    public static final class ProtectedAndPackage
    extends Visibility {
        public static final ProtectedAndPackage INSTANCE = new ProtectedAndPackage();

        private ProtectedAndPackage() {
            super("protected_and_package", true);
        }

        @Override
        public final Integer compareTo(Visibility visibility) {
            Intrinsics.checkNotNullParameter((Object)visibility, (String)"");
            if (Intrinsics.areEqual((Object)this, (Object)visibility)) {
                return 0;
            }
            if (visibility == Visibilities.Internal.INSTANCE) {
                return null;
            }
            if (Visibilities.INSTANCE.isPrivate(visibility)) {
                return 1;
            }
            return -1;
        }

        @Override
        public final Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        public final String getInternalDisplayName() {
            return "protected/*protected and package*/";
        }
    }

    public static final class ProtectedStaticVisibility
    extends Visibility {
        public static final ProtectedStaticVisibility INSTANCE = new ProtectedStaticVisibility();

        private ProtectedStaticVisibility() {
            super("protected_static", true);
        }

        @Override
        public final Visibility normalize() {
            return Visibilities.Protected.INSTANCE;
        }

        @Override
        public final String getInternalDisplayName() {
            return "protected/*protected static*/";
        }
    }
}

