/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableMemberDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.Named;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyAccessorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithDifferentJvmName;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinMethodsWithSpecialGenericSignature;
import kotlin.reflect.jvm.internal.impl.load.java.BuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.ClassicBuiltinSpecialProperties;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialBuiltinMembers$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.load.java.SpecialGenericSignatures;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.checker.TypeCheckingProcedure;

public final class SpecialBuiltinMembers {
    public static final <T extends CallableMemberDescriptor> T getOverriddenBuiltinWithDifferentJvmName(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        if (!SpecialGenericSignatures.Companion.getORIGINAL_SHORT_NAMES().contains(((Named)t).getName()) && !BuiltinSpecialProperties.INSTANCE.getSPECIAL_SHORT_NAMES().contains(DescriptorUtilsKt.getPropertyIfAccessor(t).getName())) {
            return null;
        }
        T t2 = t;
        if (t2 instanceof PropertyDescriptor || t2 instanceof PropertyAccessorDescriptor) {
            return (T)DescriptorUtilsKt.firstOverridden$default(t, false, SpecialBuiltinMembers$$Lambda$0.INSTANCE, 1, null);
        }
        if (t2 instanceof SimpleFunctionDescriptor) {
            return (T)DescriptorUtilsKt.firstOverridden$default(t, false, SpecialBuiltinMembers$$Lambda$1.INSTANCE, 1, null);
        }
        return null;
    }

    public static final boolean doesOverrideBuiltinWithDifferentJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor) != null;
    }

    public static final <T extends CallableMemberDescriptor> T getOverriddenSpecialBuiltin(T t) {
        Intrinsics.checkNotNullParameter(t, (String)"");
        T t2 = SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(t);
        if (t2 != null) {
            t = t2;
            return t;
        }
        Name name = ((Named)t).getName();
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
        if (!BuiltinMethodsWithSpecialGenericSignature.INSTANCE.getSameAsBuiltinMethodWithErasedValueParameters(name)) {
            return null;
        }
        return (T)DescriptorUtilsKt.firstOverridden$default(t, false, SpecialBuiltinMembers$$Lambda$2.INSTANCE, 1, null);
    }

    public static final String getJvmMethodNameIfSpecial(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        CallableMemberDescriptor callableMemberDescriptor2 = SpecialBuiltinMembers.getOverriddenBuiltinThatAffectsJvmName(callableMemberDescriptor);
        if (callableMemberDescriptor2 == null || (callableMemberDescriptor2 = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor2)) == null) {
            return null;
        }
        callableMemberDescriptor = callableMemberDescriptor2;
        CallableMemberDescriptor callableMemberDescriptor3 = callableMemberDescriptor2;
        if (callableMemberDescriptor2 instanceof PropertyDescriptor) {
            return ClassicBuiltinSpecialProperties.INSTANCE.getBuiltinSpecialPropertyGetterName(callableMemberDescriptor);
        }
        if (callableMemberDescriptor3 instanceof SimpleFunctionDescriptor) {
            Name name = BuiltinMethodsWithDifferentJvmName.INSTANCE.getJvmName((SimpleFunctionDescriptor)callableMemberDescriptor);
            if (name != null) {
                return name.asString();
            }
        }
        return null;
    }

    private static final CallableMemberDescriptor getOverriddenBuiltinThatAffectsJvmName(CallableMemberDescriptor callableMemberDescriptor) {
        if (KotlinBuiltIns.isBuiltIn(callableMemberDescriptor)) {
            return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName(callableMemberDescriptor);
        }
        return null;
    }

    public static final boolean hasRealKotlinSuperClassWithOverrideOf(ClassDescriptor classDescriptor, CallableDescriptor annotated) {
        Intrinsics.checkNotNullParameter((Object)classDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"");
        DeclarationDescriptor declarationDescriptor = annotated.getContainingDeclaration();
        Intrinsics.checkNotNull((Object)declarationDescriptor);
        SimpleType simpleType = ((ClassDescriptor)declarationDescriptor).getDefaultType();
        Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"");
        annotated = simpleType;
        classDescriptor = DescriptorUtils.getSuperClassDescriptor(classDescriptor);
        while (classDescriptor != null) {
            boolean bl;
            if (!(classDescriptor instanceof JavaClassDescriptor) && (bl = TypeCheckingProcedure.findCorrespondingSupertype(classDescriptor.getDefaultType(), (KotlinType)annotated) != null)) {
                return !KotlinBuiltIns.isBuiltIn(classDescriptor);
            }
            classDescriptor = DescriptorUtils.getSuperClassDescriptor(classDescriptor);
        }
        return false;
    }

    public static final boolean isFromJava(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        callableMemberDescriptor = DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor);
        return callableMemberDescriptor.getContainingDeclaration() instanceof JavaClassDescriptor;
    }

    public static final boolean isFromJavaOrBuiltins(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return SpecialBuiltinMembers.isFromJava(callableMemberDescriptor) || KotlinBuiltIns.isBuiltIn(callableMemberDescriptor);
    }

    private static final boolean getOverriddenBuiltinWithDifferentJvmName$lambda$0(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return ClassicBuiltinSpecialProperties.INSTANCE.hasBuiltinSpecialPropertyFqName(DescriptorUtilsKt.getPropertyIfAccessor(callableMemberDescriptor));
    }

    private static final boolean getOverriddenBuiltinWithDifferentJvmName$lambda$1(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return BuiltinMethodsWithDifferentJvmName.INSTANCE.isBuiltinFunctionWithDifferentNameInJvm((SimpleFunctionDescriptor)callableMemberDescriptor);
    }

    private static final boolean getOverriddenSpecialBuiltin$lambda$3(CallableMemberDescriptor callableMemberDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableMemberDescriptor, (String)"");
        return KotlinBuiltIns.isBuiltIn(callableMemberDescriptor) && BuiltinMethodsWithSpecialGenericSignature.getSpecialSignatureInfo(callableMemberDescriptor) != null;
    }

    static /* synthetic */ boolean accessor$SpecialBuiltinMembers$lambda0(CallableMemberDescriptor callableMemberDescriptor) {
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName$lambda$0(callableMemberDescriptor);
    }

    static /* synthetic */ boolean accessor$SpecialBuiltinMembers$lambda1(CallableMemberDescriptor callableMemberDescriptor) {
        return SpecialBuiltinMembers.getOverriddenBuiltinWithDifferentJvmName$lambda$1(callableMemberDescriptor);
    }

    static /* synthetic */ boolean accessor$SpecialBuiltinMembers$lambda2(CallableMemberDescriptor callableMemberDescriptor) {
        return SpecialBuiltinMembers.getOverriddenSpecialBuiltin$lambda$3(callableMemberDescriptor);
    }
}

