/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.SimpleFunctionDescriptor;
import kotlin.reflect.jvm.internal.impl.incremental.components.LookupLocation;
import kotlin.reflect.jvm.internal.impl.incremental.components.NoLookupLocation;
import kotlin.reflect.jvm.internal.impl.load.java.components.DescriptorResolverUtils;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.JavaClassDescriptor;
import kotlin.reflect.jvm.internal.impl.load.java.descriptors.UtilKt;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.LazyJavaResolverContext;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.ClassDeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.DeclaredMemberIndex;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticClassScope$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.load.java.lazy.descriptors.LazyJavaStaticScope;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorFactory;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.DescriptorKindFilter;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScopeImpl;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.utils.DFS;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public final class LazyJavaStaticClassScope
extends LazyJavaStaticScope {
    private final JavaClass jClass;
    private final JavaClassDescriptor ownerDescriptor;

    public LazyJavaStaticClassScope(LazyJavaResolverContext lazyJavaResolverContext, JavaClass javaClass, JavaClassDescriptor javaClassDescriptor) {
        Intrinsics.checkNotNullParameter((Object)lazyJavaResolverContext, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaClass, (String)"");
        Intrinsics.checkNotNullParameter((Object)javaClassDescriptor, (String)"");
        super(lazyJavaResolverContext);
        this.jClass = javaClass;
        this.ownerDescriptor = javaClassDescriptor;
    }

    @Override
    protected final JavaClassDescriptor getOwnerDescriptor() {
        return this.ownerDescriptor;
    }

    @Override
    protected final ClassDeclaredMemberIndex computeMemberIndex() {
        return new ClassDeclaredMemberIndex(this.jClass, LazyJavaStaticClassScope$$Lambda$0.INSTANCE);
    }

    @Override
    protected final Set<Name> computeFunctionNames(DescriptorKindFilter object, Function1<? super Name, Boolean> object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object2 = object = CollectionsKt.toMutableSet((Iterable)((DeclaredMemberIndex)this.getDeclaredMemberIndex().invoke()).getMethodNames());
        LazyJavaStaticClassScope lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope(this.getOwnerDescriptor());
        Set set = lazyJavaStaticClassScope != null ? ((MemberScopeImpl)lazyJavaStaticClassScope).getFunctionNames() : null;
        if (set == null) {
            set = SetsKt.emptySet();
        }
        object.addAll(set);
        if (this.jClass.isEnum()) {
            Object[] objectArray = new Name[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = StandardNames.ENUM_VALUE_OF;
            objectArray2[1] = StandardNames.ENUM_VALUES;
            object2.addAll(CollectionsKt.listOf((Object[])objectArray2));
        }
        object2.addAll((Collection)this.getC().getComponents().getSyntheticPartsProvider().getStaticFunctionNames(this.getOwnerDescriptor(), this.getC()));
        return object;
    }

    @Override
    protected final Set<Name> computePropertyNames(DescriptorKindFilter object, Function1<? super Name, Boolean> object2) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object2 = object = CollectionsKt.toMutableSet((Iterable)((DeclaredMemberIndex)this.getDeclaredMemberIndex().invoke()).getFieldNames());
        LazyJavaStaticClassScope lazyJavaStaticClassScope = this;
        lazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes(lazyJavaStaticClassScope.getOwnerDescriptor(), (Set)object2, LazyJavaStaticClassScope$$Lambda$1.INSTANCE);
        if (this.jClass.isEnum()) {
            object2.add(StandardNames.ENUM_ENTRIES);
        }
        return object;
    }

    @Override
    protected final Set<Name> computeClassNames(DescriptorKindFilter descriptorKindFilter, Function1<? super Name, Boolean> function1) {
        Intrinsics.checkNotNullParameter((Object)descriptorKindFilter, (String)"");
        return SetsKt.emptySet();
    }

    @Override
    public final ClassifierDescriptor getContributedClassifier(Name name, LookupLocation lookupLocation) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter((Object)lookupLocation, (String)"");
        return null;
    }

    @Override
    protected final void computeNonDeclaredFunctions(Collection<SimpleFunctionDescriptor> collection, Name name) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Set<SimpleFunctionDescriptor> set = this.getStaticFunctionsFromJavaSuperClasses(name, this.getOwnerDescriptor());
        Collection<SimpleFunctionDescriptor> collection2 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, (Collection)set, collection, this.getOwnerDescriptor(), this.getC().getComponents().getErrorReporter(), this.getC().getComponents().getKotlinTypeChecker().getOverridingUtil());
        Intrinsics.checkNotNullExpressionValue(collection2, (String)"");
        collection.addAll(collection2);
        if (this.jClass.isEnum()) {
            if (Intrinsics.areEqual((Object)name, (Object)StandardNames.ENUM_VALUE_OF)) {
                SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumValueOfMethod(this.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"");
                collection.add(simpleFunctionDescriptor);
                return;
            }
            if (Intrinsics.areEqual((Object)name, (Object)StandardNames.ENUM_VALUES)) {
                SimpleFunctionDescriptor simpleFunctionDescriptor = DescriptorFactory.createEnumValuesMethod(this.getOwnerDescriptor());
                Intrinsics.checkNotNullExpressionValue((Object)simpleFunctionDescriptor, (String)"");
                collection.add(simpleFunctionDescriptor);
            }
        }
    }

    @Override
    protected final void computeImplicitlyDeclaredFunctions(Collection<SimpleFunctionDescriptor> collection, Name name) {
        Intrinsics.checkNotNullParameter(collection, (String)"");
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        this.getC().getComponents().getSyntheticPartsProvider().generateStaticFunctions(this.getOwnerDescriptor(), name, collection, this.getC());
    }

    @Override
    protected final void computeNonDeclaredProperties(Name name, Collection<PropertyDescriptor> collection) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"");
        Intrinsics.checkNotNullParameter(collection, (String)"");
        LazyJavaStaticClassScope lazyJavaStaticClassScope = this;
        Iterator iterator2 = name;
        iterator2 = lazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes(lazyJavaStaticClassScope.getOwnerDescriptor(), new LinkedHashSet(), new LazyJavaStaticClassScope$$Lambda$2((Name)((Object)iterator2)));
        if (!collection.isEmpty()) {
            Collection<PropertyDescriptor> collection2 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, (Collection)((Object)iterator2), collection, this.getOwnerDescriptor(), this.getC().getComponents().getErrorReporter(), this.getC().getComponents().getKotlinTypeChecker().getOverridingUtil());
            Intrinsics.checkNotNullExpressionValue(collection2, (String)"");
            collection.addAll(collection2);
        } else {
            Object object;
            iterator2 = (Iterable)((Object)iterator2);
            Collection<PropertyDescriptor> collection3 = collection;
            Object object2 = new LinkedHashMap();
            iterator2 = iterator2.iterator();
            while (iterator2.hasNext()) {
                Object v;
                Object object3 = iterator2.next();
                object = (PropertyDescriptor)object3;
                Object object4 = object2;
                Object object5 = object4.get(object = this.getRealOriginal((PropertyDescriptor)object));
                if (object5 == null) {
                    object5 = new ArrayList();
                    object4.put(object, object5);
                    v = object5;
                } else {
                    v = object5;
                }
                object = (List)v;
                object.add(object3);
            }
            iterator2 = object2;
            object2 = new ArrayList();
            for (Map.Entry entry : iterator2.entrySet()) {
                object = entry;
                Collection<PropertyDescriptor> collection4 = DescriptorResolverUtils.resolveOverridesForStaticMembers(name, (Collection)object.getValue(), collection, this.getOwnerDescriptor(), this.getC().getComponents().getErrorReporter(), this.getC().getComponents().getKotlinTypeChecker().getOverridingUtil());
                Intrinsics.checkNotNullExpressionValue(collection4, (String)"");
                object = collection4;
                CollectionsKt.addAll((Collection)object2, (Iterable)object);
            }
            collection3.addAll((List)object2);
        }
        if (this.jClass.isEnum() && Intrinsics.areEqual((Object)name, (Object)StandardNames.ENUM_ENTRIES)) {
            kotlin.reflect.jvm.internal.impl.utils.CollectionsKt.addIfNotNull(collection, DescriptorFactory.createEnumEntriesProperty(this.getOwnerDescriptor()));
        }
    }

    private final Set<SimpleFunctionDescriptor> getStaticFunctionsFromJavaSuperClasses(Name name, ClassDescriptor object) {
        LazyJavaStaticClassScope lazyJavaStaticClassScope = UtilKt.getParentJavaStaticClassScope((ClassDescriptor)object);
        if (lazyJavaStaticClassScope == null) {
            return SetsKt.emptySet();
        }
        object = lazyJavaStaticClassScope;
        return CollectionsKt.toSet((Iterable)((MemberScopeImpl)lazyJavaStaticClassScope).getContributedFunctions(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS));
    }

    private final <R> Set<R> flatMapJavaStaticSupertypesScopes(ClassDescriptor classDescriptor, Set<R> set, Function1<? super MemberScope, ? extends Collection<? extends R>> function1) {
        DFS.dfs(CollectionsKt.listOf((Object)classDescriptor), LazyJavaStaticClassScope$$Lambda$3.INSTANCE, new DFS.AbstractNodeHandler<ClassDescriptor, Unit>(classDescriptor, set, function1){
            final /* synthetic */ ClassDescriptor $root;
            final /* synthetic */ Set<R> $result;
            final /* synthetic */ Function1<MemberScope, Collection<R>> $onJavaStaticScope;
            {
                this.$root = classDescriptor;
                this.$result = set;
                this.$onJavaStaticScope = function1;
            }

            public final boolean beforeChildren(ClassDescriptor object) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                if (object == this.$root) {
                    return true;
                }
                MemberScope memberScope = object.getStaticScope();
                Intrinsics.checkNotNullExpressionValue((Object)memberScope, (String)"");
                object = memberScope;
                if (memberScope instanceof LazyJavaStaticScope) {
                    this.$result.addAll((Collection)this.$onJavaStaticScope.invoke(object));
                    return false;
                }
                return true;
            }

            public final void result() {
            }
        });
        return set;
    }

    private final PropertyDescriptor getRealOriginal(PropertyDescriptor object) {
        if (object.getKind().isReal()) {
            return object;
        }
        Collection<? extends PropertyDescriptor> collection = object.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        Object object2 = object = (Iterable)collection;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (PropertyDescriptor)object3;
            Object object4 = object;
            Intrinsics.checkNotNull(object3);
            object4.add(this.getRealOriginal((PropertyDescriptor)object3));
        }
        return (PropertyDescriptor)CollectionsKt.single((List)CollectionsKt.distinct((Iterable)((List)object)));
    }

    private static final boolean computeMemberIndex$lambda$0(JavaMember javaMember) {
        Intrinsics.checkNotNullParameter((Object)javaMember, (String)"");
        return javaMember.isStatic();
    }

    private static final Collection computePropertyNames$lambda$3$lambda$2(MemberScope memberScope) {
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        return memberScope.getVariableNames();
    }

    private static final Collection computeNonDeclaredProperties$lambda$4(Name name, MemberScope memberScope) {
        Intrinsics.checkNotNullParameter((Object)memberScope, (String)"");
        return memberScope.getContributedVariables(name, NoLookupLocation.WHEN_GET_SUPER_MEMBERS);
    }

    private static final ClassDescriptor flatMapJavaStaticSupertypesScopes$lambda$8$lambda$7(KotlinType annotated) {
        if ((annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            return (ClassDescriptor)annotated;
        }
        return null;
    }

    private static final Iterable flatMapJavaStaticSupertypesScopes$lambda$8(ClassDescriptor classDescriptor) {
        Collection<KotlinType> collection = classDescriptor.getTypeConstructor().getSupertypes();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"");
        return SequencesKt.asIterable((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)collection), (Function1)LazyJavaStaticClassScope$$Lambda$4.INSTANCE));
    }

    static /* synthetic */ boolean accessor$LazyJavaStaticClassScope$lambda0(JavaMember javaMember) {
        return LazyJavaStaticClassScope.computeMemberIndex$lambda$0(javaMember);
    }

    static /* synthetic */ Collection accessor$LazyJavaStaticClassScope$lambda1(MemberScope memberScope) {
        return LazyJavaStaticClassScope.computePropertyNames$lambda$3$lambda$2(memberScope);
    }

    static /* synthetic */ Collection accessor$LazyJavaStaticClassScope$lambda2(Name name, MemberScope memberScope) {
        return LazyJavaStaticClassScope.computeNonDeclaredProperties$lambda$4(name, memberScope);
    }

    static /* synthetic */ Iterable accessor$LazyJavaStaticClassScope$lambda3(ClassDescriptor classDescriptor) {
        return LazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes$lambda$8(classDescriptor);
    }

    static /* synthetic */ ClassDescriptor accessor$LazyJavaStaticClassScope$lambda4(KotlinType kotlinType) {
        return LazyJavaStaticClassScope.flatMapJavaStaticSupertypesScopes$lambda$8$lambda$7(kotlinType);
    }
}

