/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.java.structure;

import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClass;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaClassifierType;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMember;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaMethod;
import kotlin.reflect.jvm.internal.impl.load.java.structure.JavaValueParameter;
import kotlin.reflect.jvm.internal.impl.name.FqName;

public final class JavaLoadingKt {
    public static final boolean isObjectMethodInInterface(JavaMember javaMember) {
        Intrinsics.checkNotNullParameter((Object)javaMember, (String)"");
        return javaMember.getContainingClass().isInterface() && javaMember instanceof JavaMethod && JavaLoadingKt.isObjectMethod((JavaMethod)javaMember);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isObjectMethod(JavaMethod javaMethod) {
        String string = javaMethod.getName().asString();
        switch (string.hashCode()) {
            case 147696667: {
                if (string.equals("hashCode")) return javaMethod.getValueParameters().isEmpty();
                return false;
            }
            case -1295482945: {
                if (string.equals("equals")) return JavaLoadingKt.isMethodWithOneObjectParameter(javaMethod);
                return false;
            }
            case -1776922004: {
                if (!string.equals("toString")) return false;
                return javaMethod.getValueParameters().isEmpty();
            }
        }
        return false;
    }

    private static final boolean isMethodWithOneObjectParameter(JavaMethod object) {
        object = object.getValueParameters();
        JavaValueParameter javaValueParameter = (JavaValueParameter)CollectionsKt.singleOrNull(object);
        object = javaValueParameter != null ? javaValueParameter.getType() : null;
        JavaClassifierType javaClassifierType = object instanceof JavaClassifierType ? (JavaClassifierType)object : null;
        if (javaClassifierType == null) {
            return false;
        }
        object = javaClassifierType;
        object = javaClassifierType.getClassifier();
        if (object instanceof JavaClass) {
            return (object = ((JavaClass)object).getFqName()) != null && Intrinsics.areEqual((Object)((FqName)object).asString(), (Object)"java.lang.Object");
        }
        return false;
    }
}

