/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.SpecialJvmAnnotations;
import kotlin.reflect.jvm.internal.impl.descriptors.SourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.AbstractBinaryClassAnnotationLoaderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmPackagePartSource;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinder;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinClassFinderKt;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinaryClass;
import kotlin.reflect.jvm.internal.impl.load.kotlin.KotlinJvmBinarySourceElement;
import kotlin.reflect.jvm.internal.impl.load.kotlin.MemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.NameResolver;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoBufUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.JvmProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.ClassMapperLite;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMemberSignature;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlin.reflect.jvm.internal.impl.metadata.jvm.deserialization.JvmProtoBufUtil;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.protobuf.GeneratedMessageLite;
import kotlin.reflect.jvm.internal.impl.protobuf.MessageLite;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmClassName;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotatedCallableKind;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.AnnotationLoader;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoContainer;
import kotlin.text.StringsKt;

public abstract class AbstractBinaryClassAnnotationLoader<A, S extends AnnotationsContainer<? extends A>>
implements AnnotationLoader<A> {
    public static final Companion Companion = new Companion(null);
    private final KotlinClassFinder kotlinClassFinder;

    public AbstractBinaryClassAnnotationLoader(KotlinClassFinder kotlinClassFinder) {
        Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
        this.kotlinClassFinder = kotlinClassFinder;
    }

    protected final KotlinClassFinder getKotlinClassFinder() {
        return this.kotlinClassFinder;
    }

    public abstract JvmMetadataVersion getJvmMetadataVersion();

    protected abstract S getAnnotationsContainer(KotlinJvmBinaryClass var1);

    protected abstract KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotation(ClassId var1, SourceElement var2, List<A> var3);

    @Override
    public abstract A loadAnnotation(ProtoBuf.Annotation var1, NameResolver var2);

    protected final KotlinJvmBinaryClass.AnnotationArgumentVisitor loadAnnotationIfNotSpecial(ClassId classId, SourceElement sourceElement, List<A> list) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"");
        Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        if (SpecialJvmAnnotations.INSTANCE.getSPECIAL_ANNOTATIONS().contains(classId)) {
            return null;
        }
        return this.loadAnnotation(classId, sourceElement, list);
    }

    private final KotlinJvmBinaryClass toBinaryClass(ProtoContainer.Class object) {
        KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = (object = ((ProtoContainer)object).getSource()) instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)object : null;
        if (kotlinJvmBinarySourceElement != null) {
            return kotlinJvmBinarySourceElement.getBinaryClass();
        }
        return null;
    }

    protected byte[] getCachedFileContent(KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)kotlinJvmBinaryClass, (String)"");
        return null;
    }

    @Override
    public List<A> loadClassAnnotations(ProtoContainer.Class object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.toBinaryClass((ProtoContainer.Class)object);
        if (kotlinJvmBinaryClass == null) {
            throw new IllegalStateException(("Class for loading annotations is not found: " + ((ProtoContainer)object).debugFqName()).toString());
        }
        object = kotlinJvmBinaryClass;
        ArrayList arrayList = new ArrayList(1);
        object.loadClassAnnotations(new KotlinJvmBinaryClass.AnnotationVisitor(this, arrayList){
            final /* synthetic */ AbstractBinaryClassAnnotationLoader<A, S> this$0;
            final /* synthetic */ ArrayList<A> $result;
            {
                this.this$0 = abstractBinaryClassAnnotationLoader;
                this.$result = arrayList;
            }

            public final KotlinJvmBinaryClass.AnnotationArgumentVisitor visitAnnotation(ClassId classId, SourceElement sourceElement) {
                Intrinsics.checkNotNullParameter((Object)classId, (String)"");
                Intrinsics.checkNotNullParameter((Object)sourceElement, (String)"");
                return this.this$0.loadAnnotationIfNotSpecial(classId, sourceElement, (List)this.$result);
            }

            public final void visitEnd() {
            }
        }, this.getCachedFileContent((KotlinJvmBinaryClass)object));
        return arrayList;
    }

    @Override
    public List<A> loadCallableAnnotations(ProtoContainer protoContainer, MessageLite object, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        if (annotatedCallableKind == AnnotatedCallableKind.PROPERTY) {
            return this.loadPropertyAnnotations(protoContainer, (ProtoBuf.Property)object, PropertyRelatedElement.PROPERTY);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, (MessageLite)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        object = memberSignature;
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, false, false, null, false, 60, null);
    }

    @Override
    public List<A> loadPropertyBackingFieldAnnotations(ProtoContainer protoContainer, ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        return this.loadPropertyAnnotations(protoContainer, property, PropertyRelatedElement.BACKING_FIELD);
    }

    @Override
    public List<A> loadPropertyDelegateFieldAnnotations(ProtoContainer protoContainer, ProtoBuf.Property property) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)property, (String)"");
        return this.loadPropertyAnnotations(protoContainer, property, PropertyRelatedElement.DELEGATE_FIELD);
    }

    private final List<A> loadPropertyAnnotations(ProtoContainer protoContainer, ProtoBuf.Property object, PropertyRelatedElement propertyRelatedElement) {
        Boolean bl = Flags.IS_CONST.get(((ProtoBuf.Property)object).getFlags());
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"");
        boolean bl2 = bl;
        boolean bl3 = JvmProtoBufUtil.isMovedFromInterfaceCompanion((ProtoBuf.Property)object);
        if (propertyRelatedElement == PropertyRelatedElement.PROPERTY) {
            MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default((ProtoBuf.Property)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), false, true, false, 40, null);
            if (memberSignature == null) {
                return CollectionsKt.emptyList();
            }
            object = memberSignature;
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, true, false, bl2, bl3, 8, null);
        }
        MemberSignature memberSignature = AbstractBinaryClassAnnotationLoaderKt.getPropertySignature$default((ProtoBuf.Property)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), true, false, false, 48, null);
        if (memberSignature == null) {
            return CollectionsKt.emptyList();
        }
        object = memberSignature;
        boolean bl4 = StringsKt.contains$default((CharSequence)memberSignature.getSignature(), (CharSequence)"$delegate", (boolean)false, (int)2, null);
        if (bl4 != (propertyRelatedElement == PropertyRelatedElement.DELEGATE_FIELD)) {
            return CollectionsKt.emptyList();
        }
        return this.findClassAndLoadMemberAnnotations(protoContainer, (MemberSignature)object, true, true, bl2, bl3);
    }

    @Override
    public List<A> loadEnumEntryAnnotations(ProtoContainer protoContainer, ProtoBuf.EnumEntry object) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        object = MemberSignature.Companion.fromFieldNameAndDesc(protoContainer.getNameResolver().getString(((ProtoBuf.EnumEntry)object).getName()), ClassMapperLite.mapClass(((ProtoContainer.Class)protoContainer).getClassId().asString()));
        return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, false, false, null, false, 60, null);
    }

    private final List<A> findClassAndLoadMemberAnnotations(ProtoContainer object, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4) {
        KotlinJvmBinaryClass kotlinJvmBinaryClass = this.findClassWithAnnotationsAndInitializers((ProtoContainer)object, Companion.getSpecialCaseContainerClass((ProtoContainer)object, bl, bl2, bl3, bl4, this.kotlinClassFinder, this.getJvmMetadataVersion()));
        if (kotlinJvmBinaryClass == null) {
            return CollectionsKt.emptyList();
        }
        object = kotlinJvmBinaryClass;
        List list = ((AnnotationsContainer)this.getAnnotationsContainer((KotlinJvmBinaryClass)object)).getMemberAnnotations().get(memberSignature);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    static /* synthetic */ List findClassAndLoadMemberAnnotations$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, ProtoContainer protoContainer, MemberSignature memberSignature, boolean bl, boolean bl2, Boolean bl3, boolean bl4, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: findClassAndLoadMemberAnnotations");
        }
        if ((n & 4) != 0) {
            bl = false;
        }
        if ((n & 8) != 0) {
            bl2 = false;
        }
        if ((n & 0x10) != 0) {
            bl3 = null;
        }
        if ((n & 0x20) != 0) {
            bl4 = false;
        }
        return abstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations(protoContainer, memberSignature, bl, bl2, bl3, bl4);
    }

    @Override
    public List<A> loadValueParameterAnnotations(ProtoContainer protoContainer, MessageLite messageLite, AnnotatedCallableKind object, int n, ProtoBuf.ValueParameter valueParameter) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)valueParameter, (String)"");
        object = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, messageLite, protoContainer.getNameResolver(), protoContainer.getTypeTable(), object, false, 16, null);
        if (object != null) {
            int n2 = n + this.computeJvmParameterIndexShift(protoContainer, messageLite);
            MemberSignature memberSignature = MemberSignature.Companion.fromMethodSignatureAndParameterIndex((MemberSignature)object, n2);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, memberSignature, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    private final int computeJvmParameterIndexShift(ProtoContainer protoContainer, MessageLite messageLite) {
        MessageLite messageLite2 = messageLite;
        if (messageLite2 instanceof ProtoBuf.Function) {
            if (ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Function)messageLite)) {
                return 1;
            }
            return 0;
        }
        if (messageLite2 instanceof ProtoBuf.Property) {
            if (ProtoTypeTableUtilKt.hasReceiver((ProtoBuf.Property)messageLite)) {
                return 1;
            }
            return 0;
        }
        if (messageLite2 instanceof ProtoBuf.Constructor) {
            Intrinsics.checkNotNull((Object)protoContainer);
            if (((ProtoContainer.Class)protoContainer).getKind() == ProtoBuf.Class.Kind.ENUM_CLASS) {
                return 2;
            }
            if (((ProtoContainer.Class)protoContainer).isInner()) {
                return 1;
            }
            return 0;
        }
        throw new UnsupportedOperationException("Unsupported message: " + messageLite.getClass());
    }

    @Override
    public List<A> loadExtensionReceiverParameterAnnotations(ProtoContainer protoContainer, MessageLite object, AnnotatedCallableKind annotatedCallableKind) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        object = AbstractBinaryClassAnnotationLoader.getCallableSignature$default(this, (MessageLite)object, protoContainer.getNameResolver(), protoContainer.getTypeTable(), annotatedCallableKind, false, 16, null);
        if (object != null) {
            object = MemberSignature.Companion.fromMethodSignatureAndParameterIndex((MemberSignature)object, 0);
            return AbstractBinaryClassAnnotationLoader.findClassAndLoadMemberAnnotations$default(this, protoContainer, (MemberSignature)object, false, false, null, false, 60, null);
        }
        return CollectionsKt.emptyList();
    }

    @Override
    public List<A> loadTypeAnnotations(ProtoBuf.Type object, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        List<ProtoBuf.Annotation> list = ((GeneratedMessageLite.ExtendableMessage)object).getExtension(JvmProtoBuf.typeAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Object object2 = object = (Iterable)list;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (ProtoBuf.Annotation)object3;
            Object object4 = object;
            Intrinsics.checkNotNull(object3);
            object4.add(this.loadAnnotation((ProtoBuf.Annotation)object3, nameResolver));
        }
        return (List)object;
    }

    @Override
    public List<A> loadTypeParameterAnnotations(ProtoBuf.TypeParameter object, NameResolver nameResolver) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        List<ProtoBuf.Annotation> list = ((GeneratedMessageLite.ExtendableMessage)object).getExtension(JvmProtoBuf.typeParameterAnnotation);
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Object object2 = object = (Iterable)list;
        object = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object, (int)10));
        object2 = object2.iterator();
        while (object2.hasNext()) {
            Object object3 = object2.next();
            object3 = (ProtoBuf.Annotation)object3;
            Object object4 = object;
            Intrinsics.checkNotNull(object3);
            object4.add(this.loadAnnotation((ProtoBuf.Annotation)object3, nameResolver));
        }
        return (List)object;
    }

    protected final KotlinJvmBinaryClass findClassWithAnnotationsAndInitializers(ProtoContainer protoContainer, KotlinJvmBinaryClass kotlinJvmBinaryClass) {
        Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
        KotlinJvmBinaryClass kotlinJvmBinaryClass2 = kotlinJvmBinaryClass;
        if (kotlinJvmBinaryClass2 == null) {
            if (protoContainer instanceof ProtoContainer.Class) {
                return this.toBinaryClass((ProtoContainer.Class)protoContainer);
            }
            kotlinJvmBinaryClass2 = null;
        }
        return kotlinJvmBinaryClass2;
    }

    protected final MemberSignature getCallableSignature(MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)messageLite, (String)"");
        Intrinsics.checkNotNullParameter((Object)nameResolver, (String)"");
        Intrinsics.checkNotNullParameter((Object)typeTable, (String)"");
        Intrinsics.checkNotNullParameter((Object)((Object)annotatedCallableKind), (String)"");
        MessageLite messageLite2 = messageLite;
        if (messageLite2 instanceof ProtoBuf.Constructor) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmConstructorSignature((ProtoBuf.Constructor)messageLite, nameResolver, typeTable);
            if (method == null) {
                return null;
            }
            return MemberSignature.Companion.fromJvmMemberSignature(method);
        }
        if (messageLite2 instanceof ProtoBuf.Function) {
            JvmMemberSignature.Method method = JvmProtoBufUtil.INSTANCE.getJvmMethodSignature((ProtoBuf.Function)messageLite, nameResolver, typeTable);
            if (method == null) {
                return null;
            }
            return MemberSignature.Companion.fromJvmMemberSignature(method);
        }
        if (messageLite2 instanceof ProtoBuf.Property) {
            GeneratedMessageLite.ExtendableMessage extendableMessage = (GeneratedMessageLite.ExtendableMessage)messageLite;
            GeneratedMessageLite.GeneratedExtension<ProtoBuf.Property, JvmProtoBuf.JvmPropertySignature> generatedExtension = JvmProtoBuf.propertySignature;
            Intrinsics.checkNotNullExpressionValue(generatedExtension, (String)"");
            JvmProtoBuf.JvmPropertySignature jvmPropertySignature = ProtoBufUtilKt.getExtensionOrNull(extendableMessage, generatedExtension);
            if (jvmPropertySignature == null) {
                return null;
            }
            messageLite2 = jvmPropertySignature;
            switch (WhenMappings.$EnumSwitchMapping$0[annotatedCallableKind.ordinal()]) {
                case 1: {
                    if (((JvmProtoBuf.JvmPropertySignature)messageLite2).hasGetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = ((JvmProtoBuf.JvmPropertySignature)messageLite2).getGetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"");
                        return MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                    }
                    return null;
                }
                case 2: {
                    if (((JvmProtoBuf.JvmPropertySignature)messageLite2).hasSetter()) {
                        JvmProtoBuf.JvmMethodSignature jvmMethodSignature = ((JvmProtoBuf.JvmPropertySignature)messageLite2).getSetter();
                        Intrinsics.checkNotNullExpressionValue((Object)jvmMethodSignature, (String)"");
                        return MemberSignature.Companion.fromMethod(nameResolver, jvmMethodSignature);
                    }
                    return null;
                }
                case 3: {
                    return AbstractBinaryClassAnnotationLoaderKt.getPropertySignature((ProtoBuf.Property)messageLite, nameResolver, typeTable, true, true, bl);
                }
            }
            return null;
        }
        return null;
    }

    public static /* synthetic */ MemberSignature getCallableSignature$default(AbstractBinaryClassAnnotationLoader abstractBinaryClassAnnotationLoader, MessageLite messageLite, NameResolver nameResolver, TypeTable typeTable, AnnotatedCallableKind annotatedCallableKind, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCallableSignature");
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        return abstractBinaryClassAnnotationLoader.getCallableSignature(messageLite, nameResolver, typeTable, annotatedCallableKind, bl);
    }

    protected final boolean isImplicitRepeatableContainer(ClassId object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        if (((ClassId)object).getOuterClassId() == null || !Intrinsics.areEqual((Object)((ClassId)object).getShortClassName().asString(), (Object)"Container")) {
            return false;
        }
        return (object = KotlinClassFinderKt.findKotlinClass(this.kotlinClassFinder, (ClassId)object, this.getJvmMetadataVersion())) != null && SpecialJvmAnnotations.INSTANCE.isAnnotatedWithContainerMetaAnnotation((KotlinJvmBinaryClass)object);
    }

    public static abstract class AnnotationsContainer<A> {
        public abstract Map<MemberSignature, List<A>> getMemberAnnotations();
    }

    public static final class Companion {
        private Companion() {
        }

        public final KotlinJvmBinaryClass getSpecialCaseContainerClass(ProtoContainer protoContainer, boolean bl, boolean bl2, Boolean bl3, boolean bl4, KotlinClassFinder kotlinClassFinder, JvmMetadataVersion jvmMetadataVersion) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)protoContainer, (String)"");
            Intrinsics.checkNotNullParameter((Object)kotlinClassFinder, (String)"");
            Intrinsics.checkNotNullParameter((Object)jvmMetadataVersion, (String)"");
            if (bl) {
                if (bl3 == null) {
                    String string = "isConst should not be null for property (container=" + protoContainer + ')';
                    throw new IllegalStateException(string.toString());
                }
                if (protoContainer instanceof ProtoContainer.Class && ((ProtoContainer.Class)protoContainer).getKind() == ProtoBuf.Class.Kind.INTERFACE) {
                    ClassId classId = ((ProtoContainer.Class)protoContainer).getClassId();
                    Name name = Name.identifier("DefaultImpls");
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                    return KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, classId.createNestedClassId(name), jvmMetadataVersion);
                }
                if (bl3.booleanValue() && protoContainer instanceof ProtoContainer.Package) {
                    Object object2 = protoContainer.getSource();
                    JvmPackagePartSource jvmPackagePartSource = object2 instanceof JvmPackagePartSource ? (JvmPackagePartSource)object2 : null;
                    object2 = jvmPackagePartSource != null ? jvmPackagePartSource.getFacadeClassName() : null;
                    if (object2 != null) {
                        String string = ((JvmClassName)object2).getInternalName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
                        return KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, ClassId.Companion.topLevel(new FqName(StringsKt.replace$default((String)string, (char)'/', (char)'.', (boolean)false, (int)4, null))), jvmMetadataVersion);
                    }
                }
            }
            if (bl2 && protoContainer instanceof ProtoContainer.Class && ((ProtoContainer.Class)protoContainer).getKind() == ProtoBuf.Class.Kind.COMPANION_OBJECT && (object = ((ProtoContainer.Class)protoContainer).getOuterClass()) != null && (((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.CLASS || ((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.ENUM_CLASS || bl4 && (((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.INTERFACE || ((ProtoContainer.Class)object).getKind() == ProtoBuf.Class.Kind.ANNOTATION_CLASS))) {
                KotlinJvmBinarySourceElement kotlinJvmBinarySourceElement = (object = ((ProtoContainer)object).getSource()) instanceof KotlinJvmBinarySourceElement ? (KotlinJvmBinarySourceElement)object : null;
                if (kotlinJvmBinarySourceElement != null) {
                    return kotlinJvmBinarySourceElement.getBinaryClass();
                }
                return null;
            }
            if (protoContainer instanceof ProtoContainer.Package && protoContainer.getSource() instanceof JvmPackagePartSource) {
                SourceElement sourceElement = protoContainer.getSource();
                Intrinsics.checkNotNull((Object)sourceElement);
                JvmPackagePartSource jvmPackagePartSource = (JvmPackagePartSource)sourceElement;
                KotlinJvmBinaryClass kotlinJvmBinaryClass = jvmPackagePartSource.getKnownJvmBinaryClass();
                if (kotlinJvmBinaryClass == null) {
                    kotlinJvmBinaryClass = KotlinClassFinderKt.findKotlinClass(kotlinClassFinder, jvmPackagePartSource.getClassId(), jvmMetadataVersion);
                }
                return kotlinJvmBinaryClass;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    private static final class PropertyRelatedElement
    extends Enum<PropertyRelatedElement> {
        public static final /* enum */ PropertyRelatedElement PROPERTY = new PropertyRelatedElement();
        public static final /* enum */ PropertyRelatedElement BACKING_FIELD = new PropertyRelatedElement();
        public static final /* enum */ PropertyRelatedElement DELEGATE_FIELD = new PropertyRelatedElement();
        private static final /* synthetic */ PropertyRelatedElement[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PropertyRelatedElement[] values() {
            return (PropertyRelatedElement[])$VALUES.clone();
        }

        public static PropertyRelatedElement valueOf(String string) {
            return Enum.valueOf(PropertyRelatedElement.class, string);
        }

        private static final /* synthetic */ PropertyRelatedElement[] $values() {
            PropertyRelatedElement[] propertyRelatedElementArray = new PropertyRelatedElement[3];
            PropertyRelatedElement[] propertyRelatedElementArray2 = propertyRelatedElementArray;
            propertyRelatedElementArray[0] = PROPERTY;
            propertyRelatedElementArray2[1] = BACKING_FIELD;
            propertyRelatedElementArray2[2] = DELEGATE_FIELD;
            return propertyRelatedElementArray2;
        }

        static {
            $VALUES = PropertyRelatedElement.$values();
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[AnnotatedCallableKind.values().length];
            try {
                nArray[AnnotatedCallableKind.PROPERTY_GETTER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AnnotatedCallableKind.PROPERTY_SETTER.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[AnnotatedCallableKind.PROPERTY.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

