/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.load.kotlin;

import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.SuspendFunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassKind;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ConstructorDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PropertyGetterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmDescriptorTypeWriter;
import kotlin.reflect.jvm.internal.impl.load.kotlin.JvmTypeFactory;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfiguration;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingConfigurationImpl;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeMappingMode;
import kotlin.reflect.jvm.internal.impl.load.kotlin.TypeSignatureMappingKt;
import kotlin.reflect.jvm.internal.impl.name.FqName;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.name.SpecialNames;
import kotlin.reflect.jvm.internal.impl.resolve.InlineClassesUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.ExpandedTypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.TypeSystemCommonBackendContext;
import kotlin.reflect.jvm.internal.impl.types.TypeUtils;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.SimpleClassicTypeSystemContext;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.model.KotlinTypeMarker;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.reflect.jvm.internal.impl.utils.FunctionsKt;
import kotlin.text.StringsKt;

public final class DescriptorBasedTypeSignatureMappingKt {
    public static final <T> T mapType(KotlinType jvmDescriptorTypeWriter, JvmTypeFactory<T> jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration<? extends T> typeMappingConfiguration, JvmDescriptorTypeWriter<T> jvmDescriptorTypeWriter2, Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> function3) {
        while (true) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)jvmDescriptorTypeWriter, (String)"");
            Intrinsics.checkNotNullParameter(jvmTypeFactory, (String)"");
            Intrinsics.checkNotNullParameter((Object)typeMappingMode, (String)"");
            Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"");
            Intrinsics.checkNotNullParameter(function3, (String)"");
            Object object2 = typeMappingConfiguration.preprocessType((KotlinType)((Object)jvmDescriptorTypeWriter));
            if (object2 != null) {
                object = object2;
                jvmDescriptorTypeWriter = object;
                continue;
            }
            if (FunctionTypesKt.isSuspendFunctionType((KotlinType)((Object)jvmDescriptorTypeWriter))) {
                jvmDescriptorTypeWriter = SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType((KotlinType)((Object)jvmDescriptorTypeWriter));
                continue;
            }
            object = SimpleClassicTypeSystemContext.INSTANCE;
            object2 = TypeSignatureMappingKt.mapBuiltInType((TypeSystemCommonBackendContext)object, (KotlinTypeMarker)((Object)jvmDescriptorTypeWriter), jvmTypeFactory, typeMappingMode);
            if (object2 != null) {
                object = object2;
                object = TypeSignatureMappingKt.boxTypeIfNeeded(jvmTypeFactory, object, typeMappingMode.getNeedPrimitiveBoxing());
                function3.invoke((Object)jvmDescriptorTypeWriter, object, (Object)typeMappingMode);
                return (T)object;
            }
            object2 = ((KotlinType)((Object)jvmDescriptorTypeWriter)).getConstructor();
            if (object2 instanceof IntersectionTypeConstructor) {
                KotlinType kotlinType = ((IntersectionTypeConstructor)object2).getAlternativeType();
                if (kotlinType == null) {
                    kotlinType = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)object2).getSupertypes());
                }
                object2 = kotlinType;
                jvmDescriptorTypeWriter = TypeUtilsKt.replaceArgumentsWithStarProjections(kotlinType);
                continue;
            }
            ClassifierDescriptor classifierDescriptor = object2.getDeclarationDescriptor();
            if (classifierDescriptor == null) {
                throw new UnsupportedOperationException("no descriptor for type constructor of " + jvmDescriptorTypeWriter);
            }
            object2 = classifierDescriptor;
            if (ErrorUtils.isError(classifierDescriptor)) {
                object = jvmTypeFactory.createObjectType("error/NonExistentClass");
                typeMappingConfiguration.processErrorType((KotlinType)((Object)jvmDescriptorTypeWriter), (ClassDescriptor)object2);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = jvmDescriptorTypeWriter2;
                if (jvmDescriptorTypeWriter3 != null) {
                    jvmDescriptorTypeWriter3.writeClass(object);
                }
                return (T)object;
            }
            if (object2 instanceof ClassDescriptor && KotlinBuiltIns.isArray((KotlinType)((Object)jvmDescriptorTypeWriter))) {
                if (((KotlinType)((Object)jvmDescriptorTypeWriter)).getArguments().size() != 1) {
                    throw new UnsupportedOperationException("arrays must have one type argument");
                }
                object = ((KotlinType)((Object)jvmDescriptorTypeWriter)).getArguments().get(0);
                KotlinType kotlinType = object.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"");
                jvmDescriptorTypeWriter = kotlinType;
                if (object.getProjectionKind() == Variance.IN_VARIANCE) {
                    object = jvmTypeFactory.createObjectType("java/lang/Object");
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter4 = jvmDescriptorTypeWriter2;
                    if (jvmDescriptorTypeWriter4 != null) {
                        JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter5 = jvmDescriptorTypeWriter4;
                        jvmDescriptorTypeWriter = jvmDescriptorTypeWriter4;
                        jvmDescriptorTypeWriter4.writeArrayType();
                        jvmDescriptorTypeWriter.writeClass(object);
                        jvmDescriptorTypeWriter.writeArrayEnd();
                    }
                } else {
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter6 = jvmDescriptorTypeWriter2;
                    if (jvmDescriptorTypeWriter6 != null) {
                        jvmDescriptorTypeWriter6.writeArrayType();
                    }
                    Variance variance = object.getProjectionKind();
                    Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"");
                    object = DescriptorBasedTypeSignatureMappingKt.mapType(jvmDescriptorTypeWriter, jvmTypeFactory, typeMappingMode.toGenericArgumentMode(variance, true), typeMappingConfiguration, jvmDescriptorTypeWriter2, function3);
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter7 = jvmDescriptorTypeWriter2;
                    if (jvmDescriptorTypeWriter7 != null) {
                        jvmDescriptorTypeWriter7.writeArrayEnd();
                    }
                }
                return jvmTypeFactory.createFromString("[" + jvmTypeFactory.toString(object));
            }
            if (object2 instanceof ClassDescriptor) {
                T t;
                if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)object2) && !typeMappingMode.getNeedInlineClassWrapping() && (object = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, (KotlinTypeMarker)((Object)jvmDescriptorTypeWriter))) != null) {
                    typeMappingMode = typeMappingMode.wrapInlineClassesMode();
                    jvmDescriptorTypeWriter = object;
                    continue;
                }
                if (typeMappingMode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)object2)) {
                    t = jvmTypeFactory.getJavaLangClassType();
                } else {
                    ClassDescriptor classDescriptor = ((ClassDescriptor)object2).getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"");
                    t = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                    if (t == null) {
                        ClassDescriptor classDescriptor2;
                        if (((ClassDescriptor)object2).getKind() == ClassKind.ENUM_ENTRY) {
                            DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)object2).getContainingDeclaration();
                            Intrinsics.checkNotNull((Object)declarationDescriptor);
                            classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                        } else {
                            classDescriptor2 = (ClassDescriptor)object2;
                        }
                        ClassDescriptor classDescriptor3 = classDescriptor2;
                        ClassDescriptor classDescriptor4 = classDescriptor3.getOriginal();
                        Intrinsics.checkNotNullExpressionValue((Object)classDescriptor4, (String)"");
                        t = jvmTypeFactory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor4, typeMappingConfiguration));
                    }
                }
                object = t;
                function3.invoke((Object)jvmDescriptorTypeWriter, object, (Object)typeMappingMode);
                return (T)object;
            }
            if (object2 instanceof TypeParameterDescriptor) {
                object = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)object2);
                object = ((KotlinType)((Object)jvmDescriptorTypeWriter)).isMarkedNullable() ? TypeUtilsKt.makeNullable((KotlinType)object) : object;
                Function3<Object, Object, Object, Unit> function32 = FunctionsKt.getDO_NOTHING_3();
                jvmDescriptorTypeWriter = DescriptorBasedTypeSignatureMappingKt.mapType((KotlinType)object, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, null, function32);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter8 = jvmDescriptorTypeWriter2;
                if (jvmDescriptorTypeWriter8 != null) {
                    Name name = object2.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                    jvmDescriptorTypeWriter8.writeTypeVariable(name, jvmDescriptorTypeWriter);
                }
                return (T)jvmDescriptorTypeWriter;
            }
            if (!(object2 instanceof TypeAliasDescriptor) || !typeMappingMode.getMapTypeAliases()) break;
            jvmDescriptorTypeWriter = ((TypeAliasDescriptor)object2).getExpandedType();
        }
        throw new UnsupportedOperationException("Unknown type " + jvmDescriptorTypeWriter);
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    public static final boolean hasVoidReturnType(CallableDescriptor callableDescriptor) {
        Intrinsics.checkNotNullParameter((Object)callableDescriptor, (String)"");
        if (callableDescriptor instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = callableDescriptor.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        if (KotlinBuiltIns.isUnit(kotlinType)) {
            KotlinType kotlinType2 = callableDescriptor.getReturnType();
            Intrinsics.checkNotNull((Object)kotlinType2);
            if (!TypeUtils.isNullableType(kotlinType2) && !(callableDescriptor instanceof PropertyGetterDescriptor)) {
                return true;
            }
        }
        return false;
    }

    public static final String computeInternalName(ClassDescriptor object, TypeMappingConfiguration<?> typeMappingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"");
        Object object2 = typeMappingConfiguration.getPredefinedFullInternalNameForClass((ClassDescriptor)object);
        if (object2 != null) {
            object = object2;
            return object;
        }
        DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
        object2 = declarationDescriptor;
        String string = SpecialNames.safeIdentifier(object.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        String string2 = string;
        if (object2 instanceof PackageFragmentDescriptor) {
            object = ((PackageFragmentDescriptor)object2).getFqName();
            if (((FqName)object).isRoot()) {
                return string2;
            }
            return StringsKt.replace$default((String)((FqName)object).asString(), (char)'.', (char)'/', (boolean)false, (int)4, null) + '/' + string2;
        }
        ClassDescriptor classDescriptor = object2 instanceof ClassDescriptor ? (ClassDescriptor)object2 : null;
        if (classDescriptor == null) {
            throw new IllegalArgumentException("Unexpected container: " + object2 + " for " + object);
        }
        object = classDescriptor;
        String string3 = typeMappingConfiguration.getPredefinedInternalNameForClass((ClassDescriptor)object);
        if (string3 == null) {
            string3 = DescriptorBasedTypeSignatureMappingKt.computeInternalName((ClassDescriptor)object, typeMappingConfiguration);
        }
        object = string3;
        return (String)object + '$' + string2;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

