/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.renderer;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.name.Name;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.RenderingUtilsKt;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;

public interface ClassifierNamePolicy {
    public String renderClassifier(ClassifierDescriptor var1, DescriptorRenderer var2);

    public static final class FULLY_QUALIFIED
    implements ClassifierNamePolicy {
        public static final FULLY_QUALIFIED INSTANCE = new FULLY_QUALIFIED();

        private FULLY_QUALIFIED() {
        }

        @Override
        public final String renderClassifier(ClassifierDescriptor classifierDescriptor, DescriptorRenderer descriptorRenderer) {
            Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
            if (classifierDescriptor instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)classifierDescriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                return descriptorRenderer.renderName(name, false);
            }
            FqNameUnsafe fqNameUnsafe = DescriptorUtils.getFqName(classifierDescriptor);
            Intrinsics.checkNotNullExpressionValue((Object)fqNameUnsafe, (String)"");
            return descriptorRenderer.renderFqName(fqNameUnsafe);
        }
    }

    public static final class SHORT
    implements ClassifierNamePolicy {
        public static final SHORT INSTANCE = new SHORT();

        private SHORT() {
        }

        @Override
        public final String renderClassifier(ClassifierDescriptor declarationDescriptor, DescriptorRenderer object) {
            Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)object, (String)"");
            if (declarationDescriptor instanceof TypeParameterDescriptor) {
                Name name = ((TypeParameterDescriptor)declarationDescriptor).getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
                return ((DescriptorRenderer)object).renderName(name, false);
            }
            object = new ArrayList();
            declarationDescriptor = declarationDescriptor;
            do {
                ((ArrayList)object).add(declarationDescriptor.getName());
            } while ((declarationDescriptor = declarationDescriptor.getContainingDeclaration()) instanceof ClassDescriptor);
            return RenderingUtilsKt.renderFqName(CollectionsKt.asReversedMutable((List)((List)object)));
        }
    }

    public static final class SOURCE_CODE_QUALIFIED
    implements ClassifierNamePolicy {
        public static final SOURCE_CODE_QUALIFIED INSTANCE = new SOURCE_CODE_QUALIFIED();

        private SOURCE_CODE_QUALIFIED() {
        }

        @Override
        public final String renderClassifier(ClassifierDescriptor classifierDescriptor, DescriptorRenderer descriptorRenderer) {
            Intrinsics.checkNotNullParameter((Object)classifierDescriptor, (String)"");
            Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
            return this.qualifiedNameForSourceCode(classifierDescriptor);
        }

        private final String qualifiedNameForSourceCode(ClassifierDescriptor object) {
            Name name = object.getName();
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"");
            String string = RenderingUtilsKt.render(name);
            if (object instanceof TypeParameterDescriptor) {
                return string;
            }
            DeclarationDescriptor declarationDescriptor = object.getContainingDeclaration();
            Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"");
            object = this.qualifierName(declarationDescriptor);
            if (object != null && !Intrinsics.areEqual((Object)object, (Object)"")) {
                return (String)object + '.' + string;
            }
            return string;
        }

        private final String qualifierName(DeclarationDescriptor declarationDescriptor) {
            DeclarationDescriptor declarationDescriptor2 = declarationDescriptor;
            if (declarationDescriptor2 instanceof ClassDescriptor) {
                return this.qualifiedNameForSourceCode((ClassifierDescriptor)declarationDescriptor);
            }
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                return RenderingUtilsKt.render(((PackageFragmentDescriptor)declarationDescriptor).getFqName().toUnsafe());
            }
            return null;
        }
    }
}

