/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.FunctionTypesKt;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.CallableDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.FindClassInModuleKt;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeAliasDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.metadata.ProtoBuf;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.Flags;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.ProtoTypeTableUtilKt;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.resolve.descriptorUtil.DescriptorUtilsKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationContext;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.NameResolverUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ProtoEnumFlags;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.SuspendFunctionTypeUtilKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$0;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$1;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$2;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$3;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializer$$Lambda$4;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.TypeDeserializerKt;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedAnnotations;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedTypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeKt;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionForAbsentTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributeTranslator;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;

public final class TypeDeserializer {
    private final DeserializationContext c;
    private final TypeDeserializer parent;
    private final String debugName;
    private final String containerPresentableName;
    private final Function1<Integer, ClassifierDescriptor> classifierDescriptors;
    private final Function1<Integer, ClassifierDescriptor> typeAliasDescriptors;
    private final Map<Integer, TypeParameterDescriptor> typeParameterDescriptors;

    public TypeDeserializer(DeserializationContext linkedHashMap, TypeDeserializer object, List<ProtoBuf.TypeParameter> list, String string, String object2) {
        Map map;
        Intrinsics.checkNotNullParameter((Object)linkedHashMap, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        Intrinsics.checkNotNullParameter((Object)object2, (String)"");
        this.c = linkedHashMap;
        this.parent = object;
        this.debugName = string;
        this.containerPresentableName = object2;
        linkedHashMap = this;
        this.classifierDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues(new TypeDeserializer$$Lambda$0((TypeDeserializer)((Object)linkedHashMap)));
        linkedHashMap = this;
        this.typeAliasDescriptors = this.c.getStorageManager().createMemoizedFunctionWithNullableValues(new TypeDeserializer$$Lambda$1((TypeDeserializer)((Object)linkedHashMap)));
        TypeDeserializer typeDeserializer = this;
        if (list.isEmpty()) {
            map = MapsKt.emptyMap();
        } else {
            linkedHashMap = new LinkedHashMap();
            object = ((Iterable)list).iterator();
            int n = 0;
            TypeDeserializer typeDeserializer2 = typeDeserializer;
            while (object.hasNext()) {
                int n2 = n++;
                object2 = (ProtoBuf.TypeParameter)object.next();
                ((Map)linkedHashMap).put(((ProtoBuf.TypeParameter)object2).getId(), new DeserializedTypeParameterDescriptor(this.c, (ProtoBuf.TypeParameter)object2, n2));
            }
            typeDeserializer = typeDeserializer2;
            map = linkedHashMap;
        }
        typeDeserializer.typeParameterDescriptors = map;
    }

    public final List<TypeParameterDescriptor> getOwnTypeParameters() {
        return CollectionsKt.toList((Iterable)this.typeParameterDescriptors.values());
    }

    public final KotlinType type(ProtoBuf.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        if (type.hasFlexibleTypeCapabilitiesId()) {
            String string = this.c.getNameResolver().getString(type.getFlexibleTypeCapabilitiesId());
            SimpleType simpleType = TypeDeserializer.simpleType$default(this, type, false, 2, null);
            ProtoBuf.Type type2 = ProtoTypeTableUtilKt.flexibleUpperBound(type, this.c.getTypeTable());
            Intrinsics.checkNotNull((Object)type2);
            SimpleType simpleType2 = TypeDeserializer.simpleType$default(this, type2, false, 2, null);
            return this.c.getComponents().getFlexibleTypeDeserializer().create(type, string, simpleType, simpleType2);
        }
        return this.simpleType(type, true);
    }

    private final TypeAttributes toAttributes(List<? extends TypeAttributeTranslator> list, Annotations annotations, TypeConstructor typeConstructor2, DeclarationDescriptor declarationDescriptor) {
        list = list;
        Object object = list;
        list = new ArrayList(CollectionsKt.collectionSizeOrDefault(list, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (TypeAttributeTranslator)object2;
            Iterable<TypeAttributeTranslator> iterable = list;
            iterable.add((TypeAttributeTranslator)((Object)object2.toAttributes(annotations, typeConstructor2, declarationDescriptor)));
        }
        list = CollectionsKt.flatten((Iterable)list);
        return TypeAttributes.Companion.create(list);
    }

    public final SimpleType simpleType(ProtoBuf.Type type, boolean bl) {
        Object object;
        SimpleType simpleType;
        Object object2;
        Object object3;
        Object object4;
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        Object object5 = type.hasClassName() ? this.computeLocalClassifierReplacementType(type.getClassName()) : (object4 = type.hasTypeAliasName() ? this.computeLocalClassifierReplacementType(type.getTypeAliasName()) : null);
        if (object5 != null) {
            return object5;
        }
        object4 = this.typeConstructor(type);
        if (ErrorUtils.isError(object4.getDeclarationDescriptor())) {
            String[] stringArray = new String[1];
            String[] stringArray2 = stringArray;
            stringArray[0] = object4.toString();
            return ErrorUtils.INSTANCE.createErrorType(ErrorTypeKind.TYPE_FOR_ERROR_TYPE_CONSTRUCTOR, (TypeConstructor)object4, stringArray2);
        }
        Object object6 = type;
        Object object7 = this;
        object6 = new DeserializedAnnotations(this.c.getStorageManager(), new TypeDeserializer$$Lambda$2((TypeDeserializer)object7, (ProtoBuf.Type)object6));
        TypeDeserializer typeDeserializer = this;
        object7 = typeDeserializer.toAttributes(typeDeserializer.c.getComponents().getTypeAttributeTranslators(), (Annotations)object6, (TypeConstructor)object4, this.c.getContainingDeclaration());
        Object object8 = object3 = (Iterable)TypeDeserializer.simpleType$collectAllArguments(type, this);
        object3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object3, (int)10));
        int n = 0;
        object8 = object8.iterator();
        while (object8.hasNext()) {
            int n2;
            Object object9 = object8.next();
            if ((n2 = n++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            object9 = (ProtoBuf.Type.Argument)object9;
            Iterable iterable = object3;
            List<TypeParameterDescriptor> list = object4.getParameters();
            Intrinsics.checkNotNullExpressionValue(list, (String)"");
            iterable.add(this.typeArgument((TypeParameterDescriptor)CollectionsKt.getOrNull(list, (int)n2), (ProtoBuf.Type.Argument)object9));
        }
        object8 = CollectionsKt.toList((Iterable)((List)object3));
        object3 = object4.getDeclarationDescriptor();
        if (bl && object3 instanceof TypeAliasDescriptor) {
            object8 = KotlinTypeFactory.computeExpandedType((TypeAliasDescriptor)object3, (List<? extends TypeProjection>)object8);
            TypeDeserializer typeDeserializer2 = this;
            object3 = typeDeserializer2.toAttributes(typeDeserializer2.c.getComponents().getTypeAttributeTranslators(), Annotations.Companion.create(CollectionsKt.plus((Iterable)((Iterable)object6), (Iterable)((KotlinType)object8).getAnnotations())), (TypeConstructor)object4, this.c.getContainingDeclaration());
            Object object10 = object8;
            object2 = ((SimpleType)object10).makeNullableAsSpecified(KotlinTypeKt.isNullable((KotlinType)object10) || type.getNullable()).replaceAttributes((TypeAttributes)object3);
        } else if (Flags.SUSPEND_TYPE.get(type.getFlags()).booleanValue()) {
            object2 = this.createSuspendFunctionType((TypeAttributes)object7, (TypeConstructor)object4, (List<? extends TypeProjection>)object8, type.getNullable());
        } else {
            object3 = KotlinTypeFactory.simpleType$default((TypeAttributes)object7, (TypeConstructor)object4, (List)object8, type.getNullable(), null, 16, null);
            if (Flags.DEFINITELY_NOT_NULL_TYPE.get(type.getFlags()).booleanValue()) {
                DefinitelyNotNullType definitelyNotNullType = DefinitelyNotNullType.Companion.makeDefinitelyNotNull$default(DefinitelyNotNullType.Companion, (UnwrappedType)object3, true, false, 4, null);
                if (definitelyNotNullType == null) {
                    throw new IllegalStateException(("null DefinitelyNotNullType for '" + object3 + '\'').toString());
                }
                object2 = definitelyNotNullType;
            } else {
                object2 = simpleType = object3;
            }
        }
        if ((object = ProtoTypeTableUtilKt.abbreviatedType(type, this.c.getTypeTable())) == null || (object = SpecialTypesKt.withAbbreviation(simpleType, this.simpleType((ProtoBuf.Type)(object8 = object), false))) == null) {
            object = simpleType;
        }
        object8 = object;
        return object;
    }

    public static /* synthetic */ SimpleType simpleType$default(TypeDeserializer typeDeserializer, ProtoBuf.Type type, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return typeDeserializer.simpleType(type, bl);
    }

    private final TypeConstructor typeConstructor(ProtoBuf.Type object) {
        ClassifierDescriptor classifierDescriptor;
        if (((ProtoBuf.Type)object).hasClassName()) {
            classifierDescriptor = (ClassifierDescriptor)this.classifierDescriptors.invoke((Object)((ProtoBuf.Type)object).getClassName());
            if (classifierDescriptor == null) {
                Object object2 = object;
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, (ProtoBuf.Type)object2, ((ProtoBuf.Type)object2).getClassName());
            }
        } else if (((ProtoBuf.Type)object).hasTypeParameter()) {
            TypeParameterDescriptor typeParameterDescriptor = this.loadTypeParameter(((ProtoBuf.Type)object).getTypeParameter());
            if (typeParameterDescriptor == null) {
                String[] stringArray = new String[2];
                String[] stringArray2 = stringArray;
                stringArray[0] = String.valueOf(((ProtoBuf.Type)object).getTypeParameter());
                stringArray2[1] = this.containerPresentableName;
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER, stringArray2);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (((ProtoBuf.Type)object).hasTypeParameterName()) {
            Object v4;
            String[] stringArray;
            block13: {
                object = this.c.getNameResolver().getString(((ProtoBuf.Type)object).getTypeParameterName());
                stringArray = this.getOwnTypeParameters();
                for (Object e : stringArray) {
                    TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)e;
                    if (!Intrinsics.areEqual((Object)typeParameterDescriptor.getName().asString(), (Object)object)) continue;
                    v4 = e;
                    break block13;
                }
                v4 = null;
            }
            TypeParameterDescriptor typeParameterDescriptor = v4;
            if (typeParameterDescriptor == null) {
                String[] stringArray2 = new String[2];
                stringArray = stringArray2;
                stringArray2[0] = object;
                stringArray[1] = this.c.getContainingDeclaration().toString();
                return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.CANNOT_LOAD_DESERIALIZE_TYPE_PARAMETER_BY_NAME, stringArray);
            }
            classifierDescriptor = typeParameterDescriptor;
        } else if (((ProtoBuf.Type)object).hasTypeAliasName()) {
            classifierDescriptor = (ClassifierDescriptor)this.typeAliasDescriptors.invoke((Object)((ProtoBuf.Type)object).getTypeAliasName());
            if (classifierDescriptor == null) {
                Object object3 = object;
                classifierDescriptor = TypeDeserializer.typeConstructor$notFoundClass(this, (ProtoBuf.Type)object3, ((ProtoBuf.Type)object3).getTypeAliasName());
            }
        } else {
            return ErrorUtils.INSTANCE.createErrorTypeConstructor(ErrorTypeKind.UNKNOWN_TYPE, new String[0]);
        }
        object = classifierDescriptor;
        TypeConstructor typeConstructor2 = classifierDescriptor.getTypeConstructor();
        Intrinsics.checkNotNullExpressionValue((Object)typeConstructor2, (String)"");
        return typeConstructor2;
    }

    private final SimpleType createSuspendFunctionType(TypeAttributes typeAttributes, TypeConstructor typeConstructor2, List<? extends TypeProjection> list, boolean bl) {
        SimpleType simpleType;
        switch (typeConstructor2.getParameters().size() - list.size()) {
            case 0: {
                simpleType = this.createSuspendFunctionTypeForBasicCase(typeAttributes, typeConstructor2, list, bl);
                break;
            }
            case 1: {
                int n = list.size() - 1;
                if (n >= 0) {
                    TypeConstructor typeConstructor3 = typeConstructor2.getBuiltIns().getSuspendFunction(n).getTypeConstructor();
                    Intrinsics.checkNotNullExpressionValue((Object)typeConstructor3, (String)"");
                    simpleType = KotlinTypeFactory.simpleType$default(typeAttributes, typeConstructor3, list, bl, null, 16, null);
                    break;
                }
                simpleType = null;
                break;
            }
            default: {
                simpleType = null;
            }
        }
        typeAttributes = simpleType;
        SimpleType simpleType2 = simpleType;
        if (simpleType == null) {
            simpleType2 = ErrorUtils.INSTANCE.createErrorTypeWithArguments(ErrorTypeKind.INCONSISTENT_SUSPEND_FUNCTION, list, typeConstructor2, new String[0]);
        }
        return simpleType2;
    }

    private final SimpleType createSuspendFunctionTypeForBasicCase(TypeAttributes object, TypeConstructor typeConstructor2, List<? extends TypeProjection> list, boolean bl) {
        if (!FunctionTypesKt.isFunctionType((KotlinType)(object = KotlinTypeFactory.simpleType$default((TypeAttributes)object, typeConstructor2, list, bl, null, 16, null)))) {
            return null;
        }
        return this.transformRuntimeFunctionTypeToSuspendFunction((KotlinType)object);
    }

    private final SimpleType transformRuntimeFunctionTypeToSuspendFunction(KotlinType kotlinType) {
        Object object;
        Object object2 = (TypeProjection)CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType));
        if (object2 == null || (object2 = object2.getType()) == null) {
            return null;
        }
        Object object3 = object2;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)object2).getConstructor().getDeclarationDescriptor();
        Object object4 = object = classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null;
        if (((KotlinType)object3).getArguments().size() != 1 || !Intrinsics.areEqual((Object)object, (Object)StandardNames.CONTINUATION_INTERFACE_FQ_NAME) && !Intrinsics.areEqual((Object)object, (Object)TypeDeserializerKt.access$getEXPERIMENTAL_CONTINUATION_FQ_NAME$p())) {
            return (SimpleType)kotlinType;
        }
        KotlinType kotlinType2 = ((TypeProjection)CollectionsKt.single(((KotlinType)object3).getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"");
        object3 = kotlinType2;
        object = this.c.getContainingDeclaration();
        CallableDescriptor callableDescriptor = object instanceof CallableDescriptor ? (CallableDescriptor)object : null;
        if (Intrinsics.areEqual((Object)(callableDescriptor != null ? DescriptorUtilsKt.fqNameOrNull(callableDescriptor) : null), (Object)SuspendFunctionTypeUtilKt.KOTLIN_SUSPEND_BUILT_IN_FUNCTION_FQ_NAME)) {
            return this.createSimpleSuspendFunctionType(kotlinType, (KotlinType)object3);
        }
        return this.createSimpleSuspendFunctionType(kotlinType, (KotlinType)object3);
    }

    private final SimpleType createSimpleSuspendFunctionType(KotlinType kotlinType, KotlinType kotlinType2) {
        Iterable<KotlinType> iterable;
        Iterable iterable2 = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(kotlinType), (int)1);
        List<KotlinType> list = FunctionTypesKt.getContextReceiverTypesFromFunctionType(kotlinType);
        KotlinType kotlinType3 = FunctionTypesKt.getReceiverTypeFromFunctionType(kotlinType);
        Annotations annotations = kotlinType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(kotlinType);
        Object object = iterable2;
        iterable2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable2, (int)10));
        object = object.iterator();
        while (object.hasNext()) {
            Object object2 = object.next();
            object2 = (TypeProjection)object2;
            iterable = iterable2;
            iterable.add(object2.getType());
        }
        iterable = (List)iterable2;
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations, kotlinType3, list, (List<? extends KotlinType>)iterable, null, kotlinType2, true).makeNullableAsSpecified(kotlinType.isMarkedNullable());
    }

    private final TypeParameterDescriptor loadTypeParameter(int n) {
        TypeParameterDescriptor typeParameterDescriptor = this.typeParameterDescriptors.get(n);
        if (typeParameterDescriptor == null) {
            TypeDeserializer typeDeserializer = this.parent;
            if (typeDeserializer != null) {
                return typeDeserializer.loadTypeParameter(n);
            }
            typeParameterDescriptor = null;
        }
        return typeParameterDescriptor;
    }

    private final ClassifierDescriptor computeClassifierDescriptor(int n) {
        ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), n);
        if (classId.isLocal()) {
            return this.c.getComponents().deserializeClass(classId);
        }
        return FindClassInModuleKt.findClassifierAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), classId);
    }

    private final SimpleType computeLocalClassifierReplacementType(int n) {
        if (NameResolverUtilKt.getClassId(this.c.getNameResolver(), n).isLocal()) {
            return this.c.getComponents().getLocalClassifierTypeSettings().getReplacementTypeForLocalClassifiers();
        }
        return null;
    }

    private final ClassifierDescriptor computeTypeAliasDescriptor(int n) {
        ClassId classId = NameResolverUtilKt.getClassId(this.c.getNameResolver(), n);
        if (classId.isLocal()) {
            return null;
        }
        return FindClassInModuleKt.findTypeAliasAcrossModuleDependencies(this.c.getComponents().getModuleDescriptor(), classId);
    }

    private final TypeProjection typeArgument(TypeParameterDescriptor stringArray, ProtoBuf.Type.Argument generatedMessageLite) {
        if (((ProtoBuf.Type.Argument)generatedMessageLite).getProjection() == ProtoBuf.Type.Argument.Projection.STAR) {
            if (stringArray == null) {
                return new StarProjectionForAbsentTypeParameter(this.c.getComponents().getModuleDescriptor().getBuiltIns());
            }
            return new StarProjectionImpl((TypeParameterDescriptor)stringArray);
        }
        ProtoBuf.Type.Argument.Projection projection = ((ProtoBuf.Type.Argument)generatedMessageLite).getProjection();
        Intrinsics.checkNotNullExpressionValue((Object)projection, (String)"");
        stringArray = ProtoEnumFlags.INSTANCE.variance(projection);
        ProtoBuf.Type type = ProtoTypeTableUtilKt.type((ProtoBuf.Type.Argument)generatedMessageLite, this.c.getTypeTable());
        if (type == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = generatedMessageLite.toString();
            return new TypeProjectionImpl(ErrorUtils.createErrorType(ErrorTypeKind.NO_RECORDED_TYPE, stringArray));
        }
        generatedMessageLite = type;
        return new TypeProjectionImpl((Variance)stringArray, this.type((ProtoBuf.Type)generatedMessageLite));
    }

    public final String toString() {
        return this.debugName + (this.parent == null ? "" : ". Child of " + this.parent.debugName);
    }

    private static final ClassifierDescriptor classifierDescriptors$lambda$0(TypeDeserializer typeDeserializer, int n) {
        return typeDeserializer.computeClassifierDescriptor(n);
    }

    private static final ClassifierDescriptor typeAliasDescriptors$lambda$1(TypeDeserializer typeDeserializer, int n) {
        return typeDeserializer.computeTypeAliasDescriptor(n);
    }

    private static final List simpleType$lambda$3(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        return typeDeserializer.c.getComponents().getAnnotationAndConstantLoader().loadTypeAnnotations(type, typeDeserializer.c.getNameResolver());
    }

    private static final List<ProtoBuf.Type.Argument> simpleType$collectAllArguments(ProtoBuf.Type type, TypeDeserializer typeDeserializer) {
        List<ProtoBuf.Type.Argument> list = type.getArgumentList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"");
        Collection collection = list;
        ProtoBuf.Type type2 = ProtoTypeTableUtilKt.outerType(type, typeDeserializer.c.getTypeTable());
        List list2 = type2 != null ? TypeDeserializer.simpleType$collectAllArguments(type2, typeDeserializer) : null;
        if (list2 == null) {
            list2 = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list2);
    }

    private static final ProtoBuf.Type typeConstructor$notFoundClass$lambda$8(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return ProtoTypeTableUtilKt.outerType(type, typeDeserializer.c.getTypeTable());
    }

    private static final int typeConstructor$notFoundClass$lambda$9(ProtoBuf.Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"");
        return type.getArgumentCount();
    }

    private static final ClassDescriptor typeConstructor$notFoundClass(TypeDeserializer typeDeserializer, ProtoBuf.Type object, int n) {
        ClassId classId = NameResolverUtilKt.getClassId(typeDeserializer.c.getNameResolver(), n);
        ProtoBuf.Type type = object;
        object = typeDeserializer;
        object = SequencesKt.toMutableList((Sequence)SequencesKt.map((Sequence)SequencesKt.generateSequence((Object)type, (Function1)new TypeDeserializer$$Lambda$3((TypeDeserializer)object)), (Function1)TypeDeserializer$$Lambda$4.INSTANCE));
        int n2 = SequencesKt.count((Sequence)SequencesKt.generateSequence((Object)classId, (Function1)((Function1)typeConstructor.notFoundClass.classNestingLevel.1.INSTANCE)));
        while (object.size() < n2) {
            object.add(0);
        }
        return typeDeserializer.c.getComponents().getNotFoundClasses().getClass(classId, (List<Integer>)object);
    }

    static /* synthetic */ ClassifierDescriptor accessor$TypeDeserializer$lambda0(TypeDeserializer typeDeserializer, int n) {
        return TypeDeserializer.classifierDescriptors$lambda$0(typeDeserializer, n);
    }

    static /* synthetic */ ClassifierDescriptor accessor$TypeDeserializer$lambda1(TypeDeserializer typeDeserializer, int n) {
        return TypeDeserializer.typeAliasDescriptors$lambda$1(typeDeserializer, n);
    }

    static /* synthetic */ List accessor$TypeDeserializer$lambda2(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        return TypeDeserializer.simpleType$lambda$3(typeDeserializer, type);
    }

    static /* synthetic */ ProtoBuf.Type accessor$TypeDeserializer$lambda3(TypeDeserializer typeDeserializer, ProtoBuf.Type type) {
        return TypeDeserializer.typeConstructor$notFoundClass$lambda$8(typeDeserializer, type);
    }

    static /* synthetic */ int accessor$TypeDeserializer$lambda4(ProtoBuf.Type type) {
        return TypeDeserializer.typeConstructor$notFoundClass$lambda$9(type);
    }
}

