/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ModuleDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.DescriptorUtils;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;

public abstract class ClassifierBasedTypeConstructor
implements TypeConstructor {
    private int hashCode;

    @Override
    public abstract ClassifierDescriptor getDeclarationDescriptor();

    public int hashCode() {
        int n;
        int n2 = this.hashCode;
        if (n2 != 0) {
            return n2;
        }
        ClassifierDescriptor classifierDescriptor = this.getDeclarationDescriptor();
        int n3 = this.hasMeaningfulFqName(classifierDescriptor) ? DescriptorUtils.getFqName(classifierDescriptor).hashCode() : System.identityHashCode(this);
        int n4 = n3;
        n4 = n3;
        this.hashCode = n = n3;
        return n4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof TypeConstructor)) {
            return false;
        }
        if (object.hashCode() != this.hashCode()) {
            return false;
        }
        if (((TypeConstructor)object).getParameters().size() != this.getParameters().size()) {
            return false;
        }
        ClassifierDescriptor classifierDescriptor = this.getDeclarationDescriptor();
        ClassifierDescriptor classifierDescriptor2 = ((TypeConstructor)object).getDeclarationDescriptor();
        if (classifierDescriptor2 == null) {
            return false;
        }
        object = classifierDescriptor2;
        if (!this.hasMeaningfulFqName(classifierDescriptor) || !this.hasMeaningfulFqName((ClassifierDescriptor)object)) {
            return false;
        }
        return this.isSameClassifier((ClassifierDescriptor)object);
    }

    protected abstract boolean isSameClassifier(ClassifierDescriptor var1);

    protected final boolean areFqNamesEqual(ClassifierDescriptor declarationDescriptor, ClassifierDescriptor declarationDescriptor2) {
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor, (String)"");
        Intrinsics.checkNotNullParameter((Object)declarationDescriptor2, (String)"");
        if (!Intrinsics.areEqual((Object)declarationDescriptor.getName(), (Object)declarationDescriptor2.getName())) {
            return false;
        }
        declarationDescriptor = declarationDescriptor.getContainingDeclaration();
        for (declarationDescriptor2 = declarationDescriptor2.getContainingDeclaration(); declarationDescriptor != null && declarationDescriptor2 != null; declarationDescriptor = declarationDescriptor.getContainingDeclaration(), declarationDescriptor2 = declarationDescriptor2.getContainingDeclaration()) {
            if (declarationDescriptor instanceof ModuleDescriptor) {
                return declarationDescriptor2 instanceof ModuleDescriptor;
            }
            if (declarationDescriptor2 instanceof ModuleDescriptor) {
                return false;
            }
            if (declarationDescriptor instanceof PackageFragmentDescriptor) {
                return declarationDescriptor2 instanceof PackageFragmentDescriptor && Intrinsics.areEqual((Object)((PackageFragmentDescriptor)declarationDescriptor).getFqName(), (Object)((PackageFragmentDescriptor)declarationDescriptor2).getFqName());
            }
            if (declarationDescriptor2 instanceof PackageFragmentDescriptor) {
                return false;
            }
            if (Intrinsics.areEqual((Object)declarationDescriptor.getName(), (Object)declarationDescriptor2.getName())) continue;
            return false;
        }
        return true;
    }

    private final boolean hasMeaningfulFqName(ClassifierDescriptor classifierDescriptor) {
        return !ErrorUtils.isError(classifierDescriptor) && !DescriptorUtils.isLocal(classifierDescriptor);
    }
}

