/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRenderer;
import kotlin.reflect.jvm.internal.impl.renderer.DescriptorRendererOptions;
import kotlin.reflect.jvm.internal.impl.types.CustomTypeParameter;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeWithEnhancementKt;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeChecker;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.typeUtil.TypeUtilsKt;

public final class FlexibleTypeImpl
extends FlexibleType
implements CustomTypeParameter {
    public static final Companion Companion = new Companion(null);
    private boolean assertionsDone;
    public static boolean RUN_SLOW_ASSERTIONS;

    public FlexibleTypeImpl(SimpleType simpleType, SimpleType simpleType2) {
        Intrinsics.checkNotNullParameter((Object)simpleType, (String)"");
        Intrinsics.checkNotNullParameter((Object)simpleType2, (String)"");
        super(simpleType, simpleType2);
    }

    private final void runAssertions() {
        boolean bl;
        if (!RUN_SLOW_ASSERTIONS || this.assertionsDone) {
            return;
        }
        this.assertionsDone = true;
        boolean bl2 = bl = !FlexibleTypesKt.isFlexible(this.getLowerBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound of a flexible type can not be flexible: " + this.getLowerBound();
            throw new AssertionError((Object)string);
        }
        boolean bl3 = bl = !FlexibleTypesKt.isFlexible(this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Upper bound of a flexible type can not be flexible: " + this.getUpperBound();
            throw new AssertionError((Object)string);
        }
        boolean bl4 = bl = !Intrinsics.areEqual((Object)this.getLowerBound(), (Object)this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower and upper bounds are equal: " + this.getLowerBound() + " == " + this.getUpperBound();
            throw new AssertionError((Object)string);
        }
        bl = KotlinTypeChecker.DEFAULT.isSubtypeOf(this.getLowerBound(), this.getUpperBound());
        if (_Assertions.ENABLED && !bl) {
            String string = "Lower bound " + this.getLowerBound() + " of a flexible type must be a subtype of the upper bound " + this.getUpperBound();
            throw new AssertionError((Object)string);
        }
    }

    @Override
    public final SimpleType getDelegate() {
        this.runAssertions();
        return this.getLowerBound();
    }

    @Override
    public final boolean isTypeParameter() {
        return this.getLowerBound().getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor && Intrinsics.areEqual((Object)this.getLowerBound().getConstructor(), (Object)this.getUpperBound().getConstructor());
    }

    @Override
    public final KotlinType substitutionResult(KotlinType kotlinType) {
        KotlinType kotlinType2;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"");
        kotlinType = kotlinType.unwrap();
        UnwrappedType unwrappedType = kotlinType;
        if (kotlinType instanceof FlexibleType) {
            kotlinType2 = kotlinType;
        } else if (unwrappedType instanceof SimpleType) {
            kotlinType2 = KotlinTypeFactory.flexibleType((SimpleType)kotlinType, ((SimpleType)kotlinType).makeNullableAsSpecified(true));
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return TypeWithEnhancementKt.inheritEnhancement((UnwrappedType)kotlinType2, kotlinType);
    }

    @Override
    public final UnwrappedType replaceAttributes(TypeAttributes typeAttributes) {
        Intrinsics.checkNotNullParameter((Object)typeAttributes, (String)"");
        return KotlinTypeFactory.flexibleType(this.getLowerBound().replaceAttributes(typeAttributes), this.getUpperBound().replaceAttributes(typeAttributes));
    }

    @Override
    public final String render(DescriptorRenderer descriptorRenderer, DescriptorRendererOptions descriptorRendererOptions) {
        Intrinsics.checkNotNullParameter((Object)descriptorRenderer, (String)"");
        Intrinsics.checkNotNullParameter((Object)descriptorRendererOptions, (String)"");
        if (descriptorRendererOptions.getDebugMode()) {
            return "(" + descriptorRenderer.renderType(this.getLowerBound()) + ".." + descriptorRenderer.renderType(this.getUpperBound()) + ')';
        }
        DescriptorRenderer descriptorRenderer2 = descriptorRenderer;
        return descriptorRenderer2.renderFlexibleType(descriptorRenderer2.renderType(this.getLowerBound()), descriptorRenderer.renderType(this.getUpperBound()), TypeUtilsKt.getBuiltIns(this));
    }

    @Override
    public final String toString() {
        return "(" + this.getLowerBound() + ".." + this.getUpperBound() + ')';
    }

    @Override
    public final UnwrappedType makeNullableAsSpecified(boolean bl) {
        return KotlinTypeFactory.flexibleType(this.getLowerBound().makeNullableAsSpecified(bl), this.getUpperBound().makeNullableAsSpecified(bl));
    }

    @Override
    public final FlexibleType refine(KotlinTypeRefiner kotlinTypeRefiner) {
        Intrinsics.checkNotNullParameter((Object)kotlinTypeRefiner, (String)"");
        KotlinType kotlinType = kotlinTypeRefiner.refineType(this.getLowerBound());
        Intrinsics.checkNotNull((Object)kotlinType);
        SimpleType simpleType = (SimpleType)kotlinType;
        KotlinType kotlinType2 = kotlinTypeRefiner.refineType(this.getUpperBound());
        Intrinsics.checkNotNull((Object)kotlinType2);
        return new FlexibleTypeImpl(simpleType, (SimpleType)kotlinType2);
    }

    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

