/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.DeclarationDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.AbstractStubType;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.ErasureTypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.SpecialTypesKt;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImplKt;
import kotlin.reflect.jvm.internal.impl.types.TypeAttributes;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.TypeUsage;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import kotlin.reflect.jvm.internal.impl.types.checker.KotlinTypeRefiner;
import kotlin.reflect.jvm.internal.impl.types.checker.NewTypeVariableConstructor;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorType;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorTypeKind;
import kotlin.reflect.jvm.internal.impl.types.error.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.utils.SmartSet;

public class TypeUtils {
    public static final SimpleType DONT_CARE = ErrorUtils.createErrorType(ErrorTypeKind.DONT_CARE, new String[0]);
    public static final SimpleType CANNOT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType(ErrorTypeKind.UNINFERRED_LAMBDA_PARAMETER_TYPE, new String[0]);
    public static final SimpleType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final SimpleType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean noExpectedType(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(0);
        }
        return kotlinType == NO_EXPECTED_TYPE || kotlinType == UNIT_EXPECTED_TYPE;
    }

    public static boolean isDontCarePlaceholder(KotlinType kotlinType) {
        return kotlinType != null && kotlinType.getConstructor() == DONT_CARE.getConstructor();
    }

    public static KotlinType makeNullable(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(1);
        }
        return TypeUtils.makeNullableAsSpecified(kotlinType, true);
    }

    public static KotlinType makeNotNullable(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(2);
        }
        return TypeUtils.makeNullableAsSpecified(kotlinType, false);
    }

    public static KotlinType makeNullableAsSpecified(KotlinType kotlinType, boolean bl) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(3);
        }
        UnwrappedType unwrappedType = kotlinType.unwrap().makeNullableAsSpecified(bl);
        if (unwrappedType == null) {
            TypeUtils.$$$reportNull$$$0(4);
        }
        return unwrappedType;
    }

    public static SimpleType makeNullableIfNeeded(SimpleType simpleType, boolean bl) {
        if (simpleType == null) {
            TypeUtils.$$$reportNull$$$0(5);
        }
        if (bl) {
            SimpleType simpleType2 = simpleType.makeNullableAsSpecified(true);
            if (simpleType2 == null) {
                TypeUtils.$$$reportNull$$$0(6);
            }
            return simpleType2;
        }
        SimpleType simpleType3 = simpleType;
        if (simpleType3 == null) {
            TypeUtils.$$$reportNull$$$0(7);
        }
        return simpleType3;
    }

    public static KotlinType makeNullableIfNeeded(KotlinType kotlinType, boolean bl) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(8);
        }
        if (bl) {
            return TypeUtils.makeNullable(kotlinType);
        }
        KotlinType kotlinType2 = kotlinType;
        if (kotlinType2 == null) {
            TypeUtils.$$$reportNull$$$0(9);
        }
        return kotlinType2;
    }

    public static SimpleType makeUnsubstitutedType(ClassifierDescriptor object, MemberScope memberScope, Function1<KotlinTypeRefiner, SimpleType> function1) {
        if (ErrorUtils.isError((DeclarationDescriptor)object)) {
            ErrorType errorType = ErrorUtils.createErrorType(ErrorTypeKind.UNABLE_TO_SUBSTITUTE_TYPE, object.toString());
            if (errorType == null) {
                TypeUtils.$$$reportNull$$$0(11);
            }
            return errorType;
        }
        object = object.getTypeConstructor();
        return TypeUtils.makeUnsubstitutedType((TypeConstructor)object, memberScope, function1);
    }

    public static SimpleType makeUnsubstitutedType(TypeConstructor typeConstructor2, MemberScope memberScope, Function1<KotlinTypeRefiner, SimpleType> function1) {
        if (typeConstructor2 == null) {
            TypeUtils.$$$reportNull$$$0(12);
        }
        if (memberScope == null) {
            TypeUtils.$$$reportNull$$$0(13);
        }
        if (function1 == null) {
            TypeUtils.$$$reportNull$$$0(14);
        }
        List<TypeProjection> list = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        SimpleType simpleType = KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(TypeAttributes.Companion.getEmpty(), typeConstructor2, list, false, memberScope, function1);
        if (simpleType == null) {
            TypeUtils.$$$reportNull$$$0(15);
        }
        return simpleType;
    }

    public static List<TypeProjection> getDefaultTypeProjections(List<TypeParameterDescriptor> object) {
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(16);
        }
        ArrayList<TypeProjectionImpl> arrayList = new ArrayList<TypeProjectionImpl>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)object.next();
            arrayList.add(new TypeProjectionImpl(typeParameterDescriptor.getDefaultType()));
        }
        List list = CollectionsKt.toList(arrayList);
        if (list == null) {
            TypeUtils.$$$reportNull$$$0(17);
        }
        return list;
    }

    public static List<KotlinType> getImmediateSupertypes(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(18);
        }
        TypeSubstitutor typeSubstitutor2 = TypeSubstitutor.create(kotlinType);
        Object object = kotlinType.getConstructor().getSupertypes();
        ArrayList<KotlinType> arrayList = new ArrayList<KotlinType>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            KotlinType kotlinType2 = (KotlinType)object.next();
            if ((kotlinType2 = TypeUtils.createSubstitutedSupertype(kotlinType, kotlinType2, typeSubstitutor2)) == null) continue;
            arrayList.add(kotlinType2);
        }
        return arrayList;
    }

    public static KotlinType createSubstitutedSupertype(KotlinType kotlinType, KotlinType kotlinType2, TypeSubstitutor typeSubstitutor2) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(20);
        }
        if (kotlinType2 == null) {
            TypeUtils.$$$reportNull$$$0(21);
        }
        if (typeSubstitutor2 == null) {
            TypeUtils.$$$reportNull$$$0(22);
        }
        if ((kotlinType2 = typeSubstitutor2.substitute(kotlinType2, Variance.INVARIANT)) != null) {
            return TypeUtils.makeNullableIfNeeded(kotlinType2, kotlinType.isMarkedNullable());
        }
        return null;
    }

    public static boolean isNullableType(KotlinType iterator2) {
        if (iterator2 == null) {
            TypeUtils.$$$reportNull$$$0(27);
        }
        if (((KotlinType)((Object)iterator2)).isMarkedNullable()) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible((KotlinType)((Object)iterator2)) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType((KotlinType)((Object)iterator2)).getUpperBound())) {
            return true;
        }
        if (SpecialTypesKt.isDefinitelyNotNullType((KotlinType)((Object)iterator2))) {
            return false;
        }
        if (TypeUtils.isTypeParameter((KotlinType)((Object)iterator2))) {
            return TypeUtils.hasNullableSuperType((KotlinType)((Object)iterator2));
        }
        if (iterator2 instanceof AbstractStubType) {
            iterator2 = ((AbstractStubType)((Object)iterator2)).getOriginalTypeVariable();
            return (iterator2 = iterator2.getOriginalTypeParameter()) == null || TypeUtils.hasNullableSuperType(iterator2.getDefaultType());
        }
        if ((iterator2 = ((KotlinType)((Object)iterator2)).getConstructor()) instanceof IntersectionTypeConstructor) {
            for (KotlinType kotlinType : iterator2.getSupertypes()) {
                if (!TypeUtils.isNullableType(kotlinType)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean acceptsNullable(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(28);
        }
        if (kotlinType.isMarkedNullable()) {
            return true;
        }
        return FlexibleTypesKt.isFlexible(kotlinType) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType(kotlinType).getUpperBound());
    }

    public static boolean hasNullableSuperType(KotlinType object) {
        if (object == null) {
            TypeUtils.$$$reportNull$$$0(29);
        }
        if (((KotlinType)object).getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (KotlinType kotlinType : TypeUtils.getImmediateSupertypes((KotlinType)object)) {
            if (!TypeUtils.isNullableType(kotlinType)) continue;
            return true;
        }
        return false;
    }

    public static ClassDescriptor getClassDescriptor(KotlinType annotated) {
        if (annotated == null) {
            TypeUtils.$$$reportNull$$$0(30);
        }
        if ((annotated = annotated.getConstructor().getDeclarationDescriptor()) instanceof ClassDescriptor) {
            return (ClassDescriptor)annotated;
        }
        return null;
    }

    public static boolean contains(KotlinType kotlinType, Function1<UnwrappedType, Boolean> function1) {
        if (function1 == null) {
            TypeUtils.$$$reportNull$$$0(43);
        }
        return TypeUtils.contains(kotlinType, function1, null);
    }

    /*
     * WARNING - void declaration
     */
    private static boolean contains(KotlinType object3, Function1<UnwrappedType, Boolean> function1, SmartSet<KotlinType> smartSet) {
        SmartSet<KotlinType> smartSet2;
        void var1_5;
        if (var1_5 == null) {
            TypeUtils.$$$reportNull$$$0(44);
        }
        if (object3 == null) {
            return false;
        }
        UnwrappedType unwrappedType = ((KotlinType)object3).unwrap();
        if (TypeUtils.noExpectedType((KotlinType)object3)) {
            return (Boolean)var1_5.invoke((Object)unwrappedType);
        }
        if (smartSet2 != null && smartSet2.contains(object3)) {
            return false;
        }
        if (((Boolean)var1_5.invoke((Object)unwrappedType)).booleanValue()) {
            return true;
        }
        if (smartSet2 == null) {
            smartSet2 = SmartSet.create();
        }
        smartSet2.add(object3);
        FlexibleType flexibleType = unwrappedType instanceof FlexibleType ? (FlexibleType)unwrappedType : null;
        if (flexibleType != null && (TypeUtils.contains(flexibleType.getLowerBound(), (Function1<UnwrappedType, Boolean>)var1_5, smartSet2) || TypeUtils.contains(flexibleType.getUpperBound(), (Function1<UnwrappedType, Boolean>)var1_5, smartSet2))) {
            return true;
        }
        if (unwrappedType instanceof DefinitelyNotNullType && TypeUtils.contains(((DefinitelyNotNullType)unwrappedType).getOriginal(), (Function1<UnwrappedType, Boolean>)var1_5, smartSet2)) {
            return true;
        }
        TypeConstructor typeConstructor2 = ((KotlinType)object3).getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            IntersectionTypeConstructor intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor2;
            for (KotlinType kotlinType : intersectionTypeConstructor.getSupertypes()) {
                if (!TypeUtils.contains(kotlinType, (Function1<UnwrappedType, Boolean>)var1_5, smartSet2)) continue;
                return true;
            }
            return false;
        }
        for (TypeProjection typeProjection : ((KotlinType)object3).getArguments()) {
            if (typeProjection.isStarProjection() || !TypeUtils.contains(typeProjection.getType(), (Function1<UnwrappedType, Boolean>)var1_5, smartSet2)) continue;
            return true;
        }
        return false;
    }

    public static TypeProjection makeStarProjection(TypeParameterDescriptor typeParameterDescriptor) {
        if (typeParameterDescriptor == null) {
            TypeUtils.$$$reportNull$$$0(45);
        }
        return new StarProjectionImpl(typeParameterDescriptor);
    }

    public static TypeProjection makeStarProjection(TypeParameterDescriptor typeParameterDescriptor, ErasureTypeAttributes erasureTypeAttributes) {
        if (typeParameterDescriptor == null) {
            TypeUtils.$$$reportNull$$$0(46);
        }
        if (erasureTypeAttributes.getHowThisTypeIsUsed() == TypeUsage.SUPERTYPE) {
            return new TypeProjectionImpl(StarProjectionImplKt.starProjectionType(typeParameterDescriptor));
        }
        return new StarProjectionImpl(typeParameterDescriptor);
    }

    public static boolean isTypeParameter(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(60);
        }
        return TypeUtils.getTypeParameterDescriptorOrNull(kotlinType) != null || kotlinType.getConstructor() instanceof NewTypeVariableConstructor;
    }

    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(KotlinType kotlinType) {
        if (kotlinType == null) {
            TypeUtils.$$$reportNull$$$0(63);
        }
        if (kotlinType.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)kotlinType.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                string = "@NotNull method %s.%s must not return null";
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                n2 = 2;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kotlin/reflect/jvm/internal/impl/types/TypeUtils";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeConstructor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "unsubstitutedMemberScope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refinedTypeFactory";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subType";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superType";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeArguments";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projections";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "b";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameterConstructors";
                break;
            }
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specialType";
                break;
            }
            case 43: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isSpecialType";
                break;
            }
            case 45: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterDescriptor";
                break;
            }
            case 47: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "numberValueTypeConstructor";
                break;
            }
            case 49: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supertypes";
                break;
            }
            case 52: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expectedType";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "literalTypeConstructor";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "kotlin/reflect/jvm/internal/impl/types/TypeUtils";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNullableAsSpecified";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "makeNullableIfNeeded";
                break;
            }
            case 11: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "makeUnsubstitutedType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTypeProjections";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getImmediateSupertypes";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSupertypes";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteProjectionsForParameters";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultPrimitiveNumberType";
                break;
            }
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrimitiveNumberType";
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "noExpectedType";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "makeNullable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "makeNotNullable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "makeNullableAsSpecified";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "makeNullableIfNeeded";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSubtypes";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "makeUnsubstitutedType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeProjections";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateSupertypes";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createSubstitutedSupertype";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "collectAllSupertypes";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getAllSupertypes";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "isNullableType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "acceptsNullable";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "hasNullableSuperType";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getClassDescriptor";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "substituteParameters";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "substituteProjectionsForParameters";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "equalTypes";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnTypeParameters";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "dependsOnTypeConstructors";
                break;
            }
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "contains";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "makeStarProjection";
                break;
            }
            case 47: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultPrimitiveNumberType";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findByFqName";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "getPrimitiveNumberType";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "isTypeParameter";
                break;
            }
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "isReifiedTypeParameter";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "isNonReifiedTypeParameter";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "getTypeParameterDescriptorOrNull";
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 17: 
            case 19: 
            case 26: 
            case 35: 
            case 48: 
            case 53: 
            case 56: 
            case 57: 
            case 58: 
            case 59: {
                runtimeException = new IllegalStateException(string2);
            }
        }
        throw runtimeException;
    }

    public static class SpecialType
    extends DelegatingSimpleType {
        private final String name;

        public SpecialType(String string) {
            this.name = string;
        }

        @Override
        protected SimpleType getDelegate() {
            throw new IllegalStateException(this.name);
        }

        @Override
        public SimpleType replaceAttributes(TypeAttributes typeAttributes) {
            if (typeAttributes == null) {
                SpecialType.$$$reportNull$$$0(0);
            }
            throw new IllegalStateException(this.name);
        }

        @Override
        public SimpleType makeNullableAsSpecified(boolean bl) {
            throw new IllegalStateException(this.name);
        }

        @Override
        public String toString() {
            String string = this.name;
            if (string == null) {
                SpecialType.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public DelegatingSimpleType replaceDelegate(SimpleType simpleType) {
            if (simpleType == null) {
                SpecialType.$$$reportNull$$$0(2);
            }
            throw new IllegalStateException(this.name);
        }

        @Override
        public SpecialType refine(KotlinTypeRefiner kotlinTypeRefiner) {
            if (kotlinTypeRefiner == null) {
                SpecialType.$$$reportNull$$$0(3);
            }
            return this;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 4: {
                    n2 = 2;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newAttributes";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kotlin/reflect/jvm/internal/impl/types/TypeUtils$SpecialType";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "kotlinTypeRefiner";
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "kotlin/reflect/jvm/internal/impl/types/TypeUtils$SpecialType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "refine";
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceAttributes";
                    break;
                }
                case 1: 
                case 4: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceDelegate";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "refine";
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                }
            }
            throw runtimeException;
        }
    }
}

