/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.sound3d;

import com.jogamp.openal.AL;
import com.jogamp.openal.ALC;
import com.jogamp.openal.ALCdevice;
import com.jogamp.openal.ALException;
import com.jogamp.openal.ALExt;
import com.jogamp.openal.ALFactory;
import com.jogamp.openal.sound3d.Buffer;
import com.jogamp.openal.sound3d.Context;
import com.jogamp.openal.sound3d.Device;
import com.jogamp.openal.sound3d.Listener;
import com.jogamp.openal.sound3d.Source;
import com.jogamp.openal.util.WAVData;
import com.jogamp.openal.util.WAVLoader;
import java.io.BufferedInputStream;
import java.io.InputStream;
import jogamp.openal.Debug;

public class AudioSystem3D {
    static boolean DEBUG;
    static final AL al;
    static final ALC alc;
    static final ALExt alExt;
    static final boolean staticAvailable;
    static Listener listener;

    @Deprecated
    public static void init() {
    }

    public static boolean isAvailable() {
        return staticAvailable;
    }

    public static final AL getAL() {
        return al;
    }

    public static final ALC getALC() {
        return alc;
    }

    public static final ALExt getALExt() {
        return alExt;
    }

    public static int getALError() {
        return al.alGetError();
    }

    public static boolean checkError(Device device, String string, boolean bl, boolean bl2) {
        if (!AudioSystem3D.checkALCError(device, string, bl, bl2)) {
            return AudioSystem3D.checkALError(string, bl, bl2);
        }
        return false;
    }

    public static boolean checkALError(String string, boolean bl, boolean bl2) {
        int n = al.alGetError();
        if (n != 0) {
            string = string + ": AL error 0x" + Integer.toHexString(n) + ", '" + al.alGetString(n) + "'";
            if (bl) {
                System.err.println(string);
            }
            if (bl2) {
                throw new ALException(string);
            }
            return true;
        }
        return false;
    }

    public static boolean checkALCError(Device object, String string, boolean bl, boolean bl2) {
        int n = alc.alcGetError((ALCdevice)(object = object != null ? ((Device)object).getALDevice() : null));
        if (n != 0) {
            object = string + ": ALC error 0x" + Integer.toHexString(n) + ", '" + alc.alcGetString((ALCdevice)object, n) + "'";
            if (bl) {
                System.err.println((String)object);
            }
            if (bl2) {
                throw new ALException((String)object);
            }
            return true;
        }
        return false;
    }

    public static Context createContext(Device device) {
        return new Context(device, null);
    }

    public static Context createContext(Device device, int[] nArray) {
        return new Context(device, nArray);
    }

    public static Context getCurrentContext() {
        return Context.getCurrentContext();
    }

    public static boolean makeContextCurrent(Context context, boolean bl) {
        return context.makeCurrent(bl);
    }

    public static boolean releaseContext(Context context, boolean bl) {
        return context.release(bl);
    }

    public static Device openDevice(String string) {
        return new Device(string);
    }

    public static Buffer[] generateBuffers(int n) {
        Buffer[] bufferArray = new Buffer[n];
        int[] nArray = new int[n];
        al.alGenBuffers(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            bufferArray[i] = new Buffer(nArray[i]);
        }
        return bufferArray;
    }

    public static Buffer loadBuffer(String object) {
        Object object2 = AudioSystem3D.generateBuffers(1);
        object2 = object2[0];
        object = WAVLoader.loadFromFile((String)object);
        ((Buffer)object2).configure(((WAVData)object).data, ((WAVData)object).format, ((WAVData)object).freq);
        return object2;
    }

    public static Buffer loadBuffer(InputStream object) {
        Object object2 = AudioSystem3D.generateBuffers(1);
        object2 = object2[0];
        if (!(object instanceof BufferedInputStream)) {
            object = new BufferedInputStream((InputStream)object);
        }
        object = WAVLoader.loadFromStream((InputStream)object);
        ((Buffer)object2).configure(((WAVData)object).data, ((WAVData)object).format, ((WAVData)object).freq);
        return object2;
    }

    public static Source loadSource(String object) {
        object = AudioSystem3D.loadBuffer((String)object);
        return AudioSystem3D.generateSource((Buffer)object);
    }

    public static Source loadSource(InputStream object) {
        object = AudioSystem3D.loadBuffer((InputStream)object);
        return AudioSystem3D.generateSource((Buffer)object);
    }

    public static Source[] generateSources(int n) {
        Source[] sourceArray = new Source[n];
        int[] nArray = new int[n];
        al.alGenSources(n, nArray, 0);
        for (int i = 0; i < n; ++i) {
            sourceArray[i] = new Source(nArray[i]);
        }
        return sourceArray;
    }

    public static Source generateSource(Buffer buffer) {
        Object object = AudioSystem3D.generateSources(1);
        object = object[0];
        object.setBuffer(buffer);
        return object;
    }

    public static Listener getListener() {
        if (listener == null) {
            listener = new Listener();
        }
        return listener;
    }

    static {
        ALExt aLExt;
        AL aL;
        ALC aLC;
        block2: {
            DEBUG = Debug.debug("AudioSystem3D");
            aLC = null;
            aL = null;
            aLExt = null;
            try {
                aLC = ALFactory.getALC();
                aL = ALFactory.getAL();
                aLExt = ALFactory.getALExt();
            }
            catch (Throwable throwable) {
                if (!DEBUG) break block2;
                System.err.println("AudioSystem3D: Caught " + throwable.getClass().getName() + ": " + throwable.getMessage());
                throwable.printStackTrace();
            }
        }
        alc = aLC;
        al = aL;
        alExt = aLExt;
        staticAvailable = alc != null && al != null && alExt != null;
    }
}

