/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.openal.util;

import com.jogamp.common.util.Bitstream;
import com.jogamp.openal.ALException;
import com.jogamp.openal.util.WAVData;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteOrder;

public class WAVLoader {
    private static final int RIFF = 1380533830;
    private static final int RIFX = 1380533848;
    private static final int WAVE = 1463899717;
    private static final int FACT = 1717658484;
    private static final int FMT = 1718449184;
    private static final int DATA = 1684108385;

    public static WAVData loadFromFile(String object) {
        object = new File((String)object);
        object = new FileInputStream((File)object);
        return WAVLoader.loadFromStreamImpl((InputStream)object);
    }

    public static WAVData loadFromStream(InputStream inputStream) {
        return WAVLoader.loadFromStreamImpl(inputStream);
    }

    private static WAVData loadFromStreamImpl(InputStream inputStream) {
        inputStream = new Bitstream.ByteInputStream(inputStream);
        inputStream = new Bitstream((Bitstream.ByteStream)inputStream, false);
        inputStream.setThrowIOExceptionOnEOF(true);
        try {
            int n;
            boolean bl;
            long l = inputStream.readUInt32(true);
            if (1380533830L == l) {
                bl = false;
            } else if (1380533848L == l) {
                bl = true;
            } else {
                throw new ALException("Invalid RIF header: 0x" + Integer.toHexString((int)l) + ", " + inputStream);
            }
            long l2 = inputStream.readUInt32(bl);
            Bitstream.uint32LongToInt((long)l2);
            long l3 = inputStream.readUInt32(true);
            if (1463899717L != l3) {
                throw new ALException("Invalid WAV header: 0x" + Integer.toHexString((int)l3) + ", " + inputStream);
            }
            int n2 = 0;
            boolean bl2 = false;
            int n3 = 0;
            int n4 = 0;
            long l4 = 0L;
            int n5 = 0;
            block8: while (!bl2) {
                n = (int)inputStream.readUInt32(true);
                long l5 = inputStream.readUInt32(bl);
                switch (n) {
                    case 1718449184: {
                        n2 = 1;
                        inputStream.readUInt16(bl);
                        n3 = (short)inputStream.readUInt16(bl);
                        l4 = inputStream.readUInt32(bl);
                        inputStream.readUInt32(bl);
                        inputStream.readUInt16(bl);
                        n4 = (short)inputStream.readUInt16(bl);
                        inputStream.skip(8L * (l5 - 16L));
                        continue block8;
                    }
                    case 1717658484: {
                        inputStream.skip(8L * l5);
                        continue block8;
                    }
                    case 1684108385: {
                        if (n2 == 0) {
                            throw new ALException("WAV fmt chunks must be before data chunks: " + inputStream);
                        }
                        bl2 = true;
                        n5 = Bitstream.uint32LongToInt((long)l5);
                        continue block8;
                    }
                }
                inputStream.skip(8L * l5);
            }
            n = n3;
            n2 = n4;
            float f = l4;
            WAVData wAVData = WAVData.loadFromStream((InputStream)inputStream.getSubStream(), n5, n, n2, Math.round(f), bl ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN, false);
            return wAVData;
        }
        finally {
            inputStream.close();
        }
    }
}

