/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.FormatInfo;
import ch.qos.logback.core.pattern.IdentityCompositeConverter;
import ch.qos.logback.core.pattern.ReplacingCompositeConverter;
import ch.qos.logback.core.pattern.parser.Compiler;
import ch.qos.logback.core.pattern.parser.CompositeNode;
import ch.qos.logback.core.pattern.parser.FormattingNode;
import ch.qos.logback.core.pattern.parser.Node;
import ch.qos.logback.core.pattern.parser.SimpleKeywordNode;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.parser.TokenStream;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.spi.ScanException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Parser<E>
extends ContextAwareBase {
    public static final String MISSING_RIGHT_PARENTHESIS = "http://logback.qos.ch/codes.html#missingRightParenthesis";
    public static final Map<String, String> DEFAULT_COMPOSITE_CONVERTER_MAP = new HashMap<String, String>();
    public static final String REPLACE_CONVERTER_WORD = "replace";
    final List<Token> tokenList;
    int pointer = 0;

    Parser(TokenStream tokenStream) {
        this.tokenList = tokenStream.tokenize();
    }

    public Parser(String string) {
        this(string, new RegularEscapeUtil());
    }

    public Parser(String object, IEscapeUtil iEscapeUtil) {
        try {
            object = new TokenStream((String)object, iEscapeUtil);
            this.tokenList = ((TokenStream)object).tokenize();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ScanException("Failed to initialize Parser", illegalArgumentException);
        }
    }

    public Converter<E> compile(Node object, Map<String, String> map) {
        object = new Compiler((Node)object, map);
        ((ContextAwareBase)object).setContext(this.context);
        return ((Compiler)object).compile();
    }

    public Node parse() {
        return this.E();
    }

    Node E() {
        Node node = this.T();
        if (node == null) {
            return null;
        }
        Node node2 = this.Eopt();
        if (node2 != null) {
            node.setNext(node2);
        }
        return node;
    }

    Node Eopt() {
        Token token = this.getCurentToken();
        if (token == null) {
            return null;
        }
        return this.E();
    }

    Node T() {
        Object object = this.getCurentToken();
        this.expectNotNull((Token)object, "a LITERAL or '%'");
        switch (((Token)object).getType()) {
            case 1000: {
                this.advanceTokenPointer();
                return new Node(0, ((Token)object).getValue());
            }
            case 37: {
                FormattingNode formattingNode;
                this.advanceTokenPointer();
                object = this.getCurentToken();
                this.expectNotNull((Token)object, "a FORMAT_MODIFIER, SIMPLE_KEYWORD or COMPOUND_KEYWORD");
                if (((Token)object).getType() == 1002) {
                    object = FormatInfo.valueOf(((Token)object).getValue());
                    this.advanceTokenPointer();
                    formattingNode = this.C();
                    formattingNode.setFormatInfo((FormatInfo)object);
                } else {
                    formattingNode = this.C();
                }
                return formattingNode;
            }
        }
        return null;
    }

    FormattingNode C() {
        Token token = this.getCurentToken();
        this.expectNotNull(token, "a LEFT_PARENTHESIS or KEYWORD");
        int n = token.getType();
        switch (n) {
            case 1004: {
                return this.SINGLE();
            }
            case 1005: {
                this.advanceTokenPointer();
                return this.COMPOSITE(token.getValue().toString());
            }
        }
        throw new IllegalStateException("Unexpected token " + String.valueOf(token));
    }

    FormattingNode SINGLE() {
        Object object = this.getNextToken();
        object = new SimpleKeywordNode(((Token)object).getValue());
        Object object2 = this.getCurentToken();
        if (object2 != null && ((Token)object2).getType() == 1006) {
            object2 = ((Token)object2).getOptionsList();
            ((SimpleKeywordNode)object).setOptions((List<String>)object2);
            this.advanceTokenPointer();
        }
        return object;
    }

    FormattingNode COMPOSITE(String object) {
        object = new CompositeNode((String)object);
        Object object2 = this.E();
        ((CompositeNode)object).setChildNode((Node)object2);
        object2 = this.getNextToken();
        if (object2 == null || ((Token)object2).getType() != 41) {
            object2 = "Expecting RIGHT_PARENTHESIS token but got " + String.valueOf(object2);
            this.addError((String)object2);
            this.addError("See also http://logback.qos.ch/codes.html#missingRightParenthesis");
            throw new ScanException((String)object2);
        }
        object2 = this.getCurentToken();
        if (object2 != null && ((Token)object2).getType() == 1006) {
            object2 = ((Token)object2).getOptionsList();
            ((SimpleKeywordNode)object).setOptions((List<String>)object2);
            this.advanceTokenPointer();
        }
        return object;
    }

    Token getNextToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer++);
        }
        return null;
    }

    Token getCurentToken() {
        if (this.pointer < this.tokenList.size()) {
            return this.tokenList.get(this.pointer);
        }
        return null;
    }

    void advanceTokenPointer() {
        ++this.pointer;
    }

    void expectNotNull(Token token, String string) {
        if (token == null) {
            throw new IllegalStateException("All tokens consumed but was expecting " + string);
        }
    }

    static {
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(Token.BARE_COMPOSITE_KEYWORD_TOKEN.getValue().toString(), IdentityCompositeConverter.class.getName());
        DEFAULT_COMPOSITE_CONVERTER_MAP.put(REPLACE_CONVERTER_WORD, ReplacingCompositeConverter.class.getName());
    }
}

