/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.spi;

import ch.qos.logback.core.spi.ComponentTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public abstract class AbstractComponentTracker<C>
implements ComponentTracker<C> {
    private static final boolean ACCESS_ORDERED = true;
    public static final long LINGERING_TIMEOUT = 10000L;
    public static final long WAIT_BETWEEN_SUCCESSIVE_REMOVAL_ITERATIONS = 1000L;
    protected int maxComponents = Integer.MAX_VALUE;
    protected long timeout = 1800000L;
    LinkedHashMap<String, Entry<C>> liveMap = new LinkedHashMap(32, 0.75f, true);
    LinkedHashMap<String, Entry<C>> lingerersMap = new LinkedHashMap(16, 0.75f, true);
    long lastCheck = 0L;
    private RemovalPredicator<C> byExcedent = new RemovalPredicator<C>(){

        @Override
        public boolean isSlatedForRemoval(Entry<C> entry, long l) {
            return AbstractComponentTracker.this.liveMap.size() > AbstractComponentTracker.this.maxComponents;
        }
    };
    private RemovalPredicator<C> byTimeout = new RemovalPredicator<C>(){

        @Override
        public boolean isSlatedForRemoval(Entry<C> entry, long l) {
            return AbstractComponentTracker.this.isEntryStale(entry, l);
        }
    };
    private RemovalPredicator<C> byLingering = new RemovalPredicator<C>(){

        @Override
        public boolean isSlatedForRemoval(Entry<C> entry, long l) {
            return AbstractComponentTracker.this.isEntryDoneLingering(entry, l);
        }
    };

    protected abstract void processPriorToRemoval(C var1);

    protected abstract C buildComponent(String var1);

    protected abstract boolean isComponentStale(C var1);

    @Override
    public int getComponentCount() {
        return this.liveMap.size() + this.lingerersMap.size();
    }

    private Entry<C> getFromEitherMap(String string) {
        Entry<C> entry = this.liveMap.get(string);
        if (entry != null) {
            return entry;
        }
        return this.lingerersMap.get(string);
    }

    @Override
    public synchronized C find(String object) {
        if ((object = this.getFromEitherMap((String)object)) == null) {
            return null;
        }
        return ((Entry)object).component;
    }

    @Override
    public synchronized C getOrCreate(String string, long l) {
        Entry<Object> entry = this.getFromEitherMap(string);
        if (entry == null) {
            entry = this.buildComponent(string);
            entry = new Entry<Entry<C>>(string, entry, l);
            this.liveMap.put(string, entry);
        } else {
            entry.setTimestamp(l);
        }
        return entry.component;
    }

    @Override
    public void endOfLife(String string) {
        Entry entry = (Entry)this.liveMap.remove(string);
        if (entry == null) {
            return;
        }
        this.lingerersMap.put(string, entry);
    }

    @Override
    public synchronized void removeStaleComponents(long l) {
        if (this.isTooSoonForRemovalIteration(l)) {
            return;
        }
        this.removeExcedentComponents();
        this.removeStaleComponentsFromMainMap(l);
        this.removeStaleComponentsFromLingerersMap(l);
    }

    private void removeExcedentComponents() {
        AbstractComponentTracker abstractComponentTracker = this;
        abstractComponentTracker.genericStaleComponentRemover(abstractComponentTracker.liveMap, 0L, this.byExcedent);
    }

    private void removeStaleComponentsFromMainMap(long l) {
        AbstractComponentTracker abstractComponentTracker = this;
        abstractComponentTracker.genericStaleComponentRemover(abstractComponentTracker.liveMap, l, this.byTimeout);
    }

    private void removeStaleComponentsFromLingerersMap(long l) {
        AbstractComponentTracker abstractComponentTracker = this;
        abstractComponentTracker.genericStaleComponentRemover(abstractComponentTracker.lingerersMap, l, this.byLingering);
    }

    private void genericStaleComponentRemover(LinkedHashMap<String, Entry<C>> object, long l, RemovalPredicator<C> removalPredicator) {
        object = ((LinkedHashMap)object).entrySet().iterator();
        while (object.hasNext()) {
            Object object2 = (Map.Entry)object.next();
            if (!removalPredicator.isSlatedForRemoval((Entry<C>)(object2 = (Entry)object2.getValue()), l)) break;
            object.remove();
            object2 = ((Entry)object2).component;
            this.processPriorToRemoval(object2);
        }
    }

    private boolean isTooSoonForRemovalIteration(long l) {
        if (this.lastCheck + 1000L > l) {
            return true;
        }
        this.lastCheck = l;
        return false;
    }

    private boolean isEntryStale(Entry<C> entry, long l) {
        Object c = entry.component;
        if (this.isComponentStale(c)) {
            return true;
        }
        return entry.timestamp + this.timeout < l;
    }

    private boolean isEntryDoneLingering(Entry<C> entry, long l) {
        return entry.timestamp + 10000L < l;
    }

    @Override
    public Set<String> allKeys() {
        HashSet<String> hashSet = new HashSet<String>(this.liveMap.keySet());
        hashSet.addAll(this.lingerersMap.keySet());
        return hashSet;
    }

    @Override
    public Collection<C> allComponents() {
        ArrayList arrayList = new ArrayList();
        for (Entry<C> entry : this.liveMap.values()) {
            arrayList.add(entry.component);
        }
        for (Entry<C> entry : this.lingerersMap.values()) {
            arrayList.add(entry.component);
        }
        return arrayList;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long l) {
        this.timeout = l;
    }

    public int getMaxComponents() {
        return this.maxComponents;
    }

    public void setMaxComponents(int n) {
        this.maxComponents = n;
    }

    private static interface RemovalPredicator<C> {
        public boolean isSlatedForRemoval(Entry<C> var1, long var2);
    }

    private static class Entry<C> {
        String key;
        C component;
        long timestamp;

        Entry(String string, C c, long l) {
            this.key = string;
            this.component = c;
            this.timestamp = l;
        }

        public void setTimestamp(long l) {
            this.timestamp = l;
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (Entry)object;
            if (this.key == null ? ((Entry)object).key != null : !this.key.equals(((Entry)object).key)) {
                return false;
            }
            return !(this.component == null ? ((Entry)object).component != null : !this.component.equals(((Entry)object).component));
        }

        public String toString() {
            return "(" + this.key + ", " + String.valueOf(this.component) + ")";
        }
    }
}

