/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.MessageToByteEncoder;
import io.netty.util.internal.TypeParameterMatcher;
import java.util.List;

public abstract class ByteToMessageCodec<I>
extends ChannelDuplexHandler {
    private final TypeParameterMatcher outboundMsgMatcher;
    private final MessageToByteEncoder<I> encoder;
    private final ByteToMessageDecoder decoder = new ByteToMessageDecoder(){

        @Override
        public void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            ByteToMessageCodec.this.decode(channelHandlerContext, byteBuf, list);
        }

        @Override
        protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
            ByteToMessageCodec.this.decodeLast(channelHandlerContext, byteBuf, list);
        }
    };

    protected ByteToMessageCodec() {
        this(true);
    }

    protected ByteToMessageCodec(Class<? extends I> clazz) {
        this(clazz, true);
    }

    protected ByteToMessageCodec(boolean bl) {
        this.ensureNotSharable();
        this.outboundMsgMatcher = TypeParameterMatcher.find((Object)((Object)this), ByteToMessageCodec.class, (String)"I");
        this.encoder = new Encoder(bl);
    }

    protected ByteToMessageCodec(Class<? extends I> clazz, boolean bl) {
        this.ensureNotSharable();
        this.outboundMsgMatcher = TypeParameterMatcher.get(clazz);
        this.encoder = new Encoder(bl);
    }

    public boolean acceptOutboundMessage(Object object) {
        return this.outboundMsgMatcher.match(object);
    }

    public void channelRead(ChannelHandlerContext channelHandlerContext, Object object) {
        this.decoder.channelRead(channelHandlerContext, object);
    }

    public void write(ChannelHandlerContext channelHandlerContext, Object object, ChannelPromise channelPromise) {
        this.encoder.write(channelHandlerContext, object, channelPromise);
    }

    public void channelReadComplete(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelReadComplete(channelHandlerContext);
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) {
        this.decoder.channelInactive(channelHandlerContext);
    }

    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        try {
            this.decoder.handlerAdded(channelHandlerContext);
            return;
        }
        finally {
            this.encoder.handlerAdded(channelHandlerContext);
        }
    }

    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        try {
            this.decoder.handlerRemoved(channelHandlerContext);
            return;
        }
        finally {
            this.encoder.handlerRemoved(channelHandlerContext);
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, ByteBuf var3);

    protected abstract void decode(ChannelHandlerContext var1, ByteBuf var2, List<Object> var3);

    protected void decodeLast(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (byteBuf.isReadable()) {
            this.decode(channelHandlerContext, byteBuf, list);
        }
    }

    private final class Encoder
    extends MessageToByteEncoder<I> {
        Encoder(boolean bl) {
            super(bl);
        }

        @Override
        public final boolean acceptOutboundMessage(Object object) {
            return ByteToMessageCodec.this.acceptOutboundMessage(object);
        }

        @Override
        protected final void encode(ChannelHandlerContext channelHandlerContext, I i, ByteBuf byteBuf) {
            ByteToMessageCodec.this.encode(channelHandlerContext, i, byteBuf);
        }
    }
}

