/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.compression.Bzip2BitReader;
import io.netty.handler.codec.compression.Bzip2BlockDecompressor;
import io.netty.handler.codec.compression.Bzip2HuffmanStageDecoder;
import io.netty.handler.codec.compression.Bzip2MoveToFrontTable;
import io.netty.handler.codec.compression.DecompressionException;
import java.util.List;

public class Bzip2Decoder
extends ByteToMessageDecoder {
    private State currentState = State.INIT;
    private final Bzip2BitReader reader = new Bzip2BitReader();
    private Bzip2BlockDecompressor blockDecompressor;
    private Bzip2HuffmanStageDecoder huffmanStageDecoder;
    private int blockSize;
    private int blockCRC;
    private int streamCRC;

    @Override
    protected void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        if (!byteBuf.isReadable()) {
            return;
        }
        Bzip2BitReader bzip2BitReader = this.reader;
        bzip2BitReader.setByteBuf(byteBuf);
        block14: while (true) {
            switch (this.currentState) {
                case INIT: {
                    if (byteBuf.readableBytes() < 4) {
                        return;
                    }
                    int n = byteBuf.readUnsignedMedium();
                    if (n != 4348520) {
                        throw new DecompressionException("Unexpected stream identifier contents. Mismatched bzip2 protocol version?");
                    }
                    n = byteBuf.readByte() - 48;
                    if (n <= 0 || n > 9) {
                        throw new DecompressionException("block size is invalid");
                    }
                    this.blockSize = n * 100000;
                    this.streamCRC = 0;
                    this.currentState = State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    if (!bzip2BitReader.hasReadableBytes(10)) {
                        return;
                    }
                    int n = bzip2BitReader.readBits(24);
                    int n2 = bzip2BitReader.readBits(24);
                    if (n == 1536581 && n2 == 3690640) {
                        n = bzip2BitReader.readInt();
                        if (n != this.streamCRC) {
                            throw new DecompressionException("stream CRC error");
                        }
                        this.currentState = State.EOF;
                        continue block14;
                    }
                    if (n != 3227993 || n2 != 2511705) {
                        throw new DecompressionException("bad block header");
                    }
                    this.blockCRC = bzip2BitReader.readInt();
                    this.currentState = State.INIT_BLOCK_PARAMS;
                }
                case INIT_BLOCK_PARAMS: {
                    if (!bzip2BitReader.hasReadableBits(25)) {
                        return;
                    }
                    int n = bzip2BitReader.readBoolean();
                    int n2 = bzip2BitReader.readBits(24);
                    this.blockDecompressor = new Bzip2BlockDecompressor(this.blockSize, this.blockCRC, n != 0, n2, bzip2BitReader);
                    this.currentState = State.RECEIVE_HUFFMAN_USED_MAP;
                }
                case RECEIVE_HUFFMAN_USED_MAP: {
                    if (!bzip2BitReader.hasReadableBits(16)) {
                        return;
                    }
                    this.blockDecompressor.huffmanInUse16 = bzip2BitReader.readBits(16);
                    this.currentState = State.RECEIVE_HUFFMAN_USED_BITMAPS;
                }
                case RECEIVE_HUFFMAN_USED_BITMAPS: {
                    int n6;
                    int n3;
                    Bzip2BlockDecompressor bzip2BlockDecompressor = this.blockDecompressor;
                    int n2 = bzip2BlockDecompressor.huffmanInUse16;
                    int n4 = Integer.bitCount(n2);
                    byte[] byArray = bzip2BlockDecompressor.huffmanSymbolMap;
                    if (!bzip2BitReader.hasReadableBits((n4 << 4) + 3)) {
                        return;
                    }
                    int n5 = 0;
                    if (n4 > 0) {
                        for (n4 = 0; n4 < 16; ++n4) {
                            if ((n2 & 32768 >>> n4) == 0) continue;
                            n3 = 0;
                            n6 = n4 << 4;
                            while (n3 < 16) {
                                if (bzip2BitReader.readBoolean()) {
                                    byArray[n5++] = (byte)n6;
                                }
                                ++n3;
                                ++n6;
                            }
                        }
                    }
                    bzip2BlockDecompressor.huffmanEndOfBlockSymbol = n5 + 1;
                    n4 = bzip2BitReader.readBits(3);
                    if (n4 < 2 || n4 > 6) {
                        throw new DecompressionException("incorrect huffman groups number");
                    }
                    n3 = n5 + 2;
                    if (n3 > 258) {
                        throw new DecompressionException("incorrect alphabet size");
                    }
                    this.huffmanStageDecoder = new Bzip2HuffmanStageDecoder(bzip2BitReader, n4, n3);
                    this.currentState = State.RECEIVE_SELECTORS_NUMBER;
                }
                case RECEIVE_SELECTORS_NUMBER: {
                    if (!bzip2BitReader.hasReadableBits(15)) {
                        return;
                    }
                    int n6 = bzip2BitReader.readBits(15);
                    if (n6 <= 0 || n6 > 18002) {
                        throw new DecompressionException("incorrect selectors number");
                    }
                    this.huffmanStageDecoder.selectors = new byte[n6];
                    this.currentState = State.RECEIVE_SELECTORS;
                }
                case RECEIVE_SELECTORS: {
                    int n7;
                    int n5;
                    Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder = this.huffmanStageDecoder;
                    byte[] byArray = bzip2HuffmanStageDecoder.selectors;
                    int n6 = bzip2HuffmanStageDecoder.selectors.length;
                    Bzip2MoveToFrontTable bzip2MoveToFrontTable = bzip2HuffmanStageDecoder.tableMTF;
                    for (n7 = bzip2HuffmanStageDecoder.currentSelector; n7 < n6; ++n7) {
                        if (!bzip2BitReader.hasReadableBits(6)) {
                            bzip2HuffmanStageDecoder.currentSelector = n7;
                            return;
                        }
                        n5 = 0;
                        while (bzip2BitReader.readBoolean()) {
                            ++n5;
                        }
                        byArray[n7] = bzip2MoveToFrontTable.indexToFront(n5);
                    }
                    this.currentState = State.RECEIVE_HUFFMAN_LENGTH;
                }
                case RECEIVE_HUFFMAN_LENGTH: {
                    int n2;
                    Bzip2HuffmanStageDecoder bzip2HuffmanStageDecoder = this.huffmanStageDecoder;
                    int n = bzip2HuffmanStageDecoder.totalTables;
                    byte[][] byArray = bzip2HuffmanStageDecoder.tableCodeLengths;
                    int n3 = bzip2HuffmanStageDecoder.alphabetSize;
                    int n7 = bzip2HuffmanStageDecoder.currentLength;
                    int n6 = 0;
                    boolean bl = bzip2HuffmanStageDecoder.modifyLength;
                    boolean bl2 = false;
                    block19: for (n2 = bzip2HuffmanStageDecoder.currentGroup; n2 < n; ++n2) {
                        if (!bzip2BitReader.hasReadableBits(5)) {
                            bl2 = true;
                            break;
                        }
                        if (n7 < 0) {
                            n7 = bzip2BitReader.readBits(5);
                        }
                        for (n6 = bzip2HuffmanStageDecoder.currentAlpha; n6 < n3; ++n6) {
                            if (!bzip2BitReader.isReadable()) {
                                bl2 = true;
                                break block19;
                            }
                            while (bl || bzip2BitReader.readBoolean()) {
                                if (!bzip2BitReader.isReadable()) {
                                    bl = true;
                                    bl2 = true;
                                    break block19;
                                }
                                n7 += bzip2BitReader.readBoolean() ? -1 : 1;
                                bl = false;
                                if (bzip2BitReader.isReadable()) continue;
                                bl2 = true;
                                break block19;
                            }
                            byArray[n2][n6] = (byte)n7;
                        }
                        n7 = -1;
                        bzip2HuffmanStageDecoder.currentAlpha = 0;
                        n6 = 0;
                        bl = false;
                    }
                    if (bl2) {
                        bzip2HuffmanStageDecoder.currentGroup = n2;
                        bzip2HuffmanStageDecoder.currentLength = n7;
                        bzip2HuffmanStageDecoder.currentAlpha = n6;
                        bzip2HuffmanStageDecoder.modifyLength = bl;
                        return;
                    }
                    bzip2HuffmanStageDecoder.createHuffmanDecodingTables();
                    this.currentState = State.DECODE_HUFFMAN_DATA;
                }
                case DECODE_HUFFMAN_DATA: {
                    Bzip2BlockDecompressor bzip2BlockDecompressor = this.blockDecompressor;
                    int n2 = byteBuf.readerIndex();
                    boolean bl = bzip2BlockDecompressor.decodeHuffmanData(this.huffmanStageDecoder);
                    int n = bl ? 1 : 0;
                    if (!bl) {
                        return;
                    }
                    if (byteBuf.readerIndex() == n2 && byteBuf.isReadable()) {
                        bzip2BitReader.refill();
                    }
                    int n8 = bzip2BlockDecompressor.blockLength();
                    channelHandlerContext = channelHandlerContext.alloc().buffer(n8);
                    try {
                        while ((n8 = bzip2BlockDecompressor.read()) >= 0) {
                            channelHandlerContext.writeByte(n8);
                        }
                        this.currentState = State.INIT_BLOCK;
                        n8 = bzip2BlockDecompressor.checkCRC();
                        this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ n8;
                        list.add(channelHandlerContext);
                        channelHandlerContext = null;
                        return;
                    }
                    catch (Throwable throwable) {
                        if (channelHandlerContext != null) {
                            channelHandlerContext.release();
                        }
                        throw throwable;
                    }
                }
                case EOF: {
                    ByteBuf byteBuf2 = byteBuf;
                    byteBuf2.skipBytes(byteBuf2.readableBytes());
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    public boolean isClosed() {
        return this.currentState == State.EOF;
    }

    private static enum State {
        INIT,
        INIT_BLOCK,
        INIT_BLOCK_PARAMS,
        RECEIVE_HUFFMAN_USED_MAP,
        RECEIVE_HUFFMAN_USED_BITMAPS,
        RECEIVE_SELECTORS_NUMBER,
        RECEIVE_SELECTORS,
        RECEIVE_HUFFMAN_LENGTH,
        DECODE_HUFFMAN_DATA,
        EOF;

    }
}

