/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.compression;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.compression.ByteBufChecksum;
import io.netty.handler.codec.compression.DecompressionException;
import java.nio.ByteBuffer;

final class CompressionUtil {
    private CompressionUtil() {
    }

    static void checkChecksum(ByteBufChecksum byteBufChecksum, ByteBuf byteBuf, int n) {
        byteBufChecksum.reset();
        ByteBuf byteBuf2 = byteBuf;
        byteBufChecksum.update(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
        int n2 = (int)byteBufChecksum.getValue();
        if (n2 != n) {
            throw new DecompressionException(String.format("stream corrupted: mismatching checksum: %d (expected: %d)", n2, n));
        }
    }

    static ByteBuffer safeReadableNioBuffer(ByteBuf byteBuf) {
        ByteBuf byteBuf2 = byteBuf;
        return CompressionUtil.safeNioBuffer(byteBuf2, byteBuf2.readerIndex(), byteBuf.readableBytes());
    }

    static ByteBuffer safeNioBuffer(ByteBuf byteBuf, int n, int n2) {
        if (byteBuf.nioBufferCount() == 1) {
            return byteBuf.internalNioBuffer(n, n2);
        }
        return byteBuf.nioBuffer(n, n2);
    }
}

