/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.protobuf;

import com.google.protobuf.nano.MessageNano;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.util.internal.ObjectUtil;
import java.util.List;

@ChannelHandler.Sharable
public class ProtobufDecoderNano
extends MessageToMessageDecoder<ByteBuf> {
    private final Class<? extends MessageNano> clazz;

    public ProtobufDecoderNano(Class<? extends MessageNano> clazz) {
        this.clazz = (Class)ObjectUtil.checkNotNull(clazz, (String)"You must provide a Class");
    }

    @Override
    protected void decode(ChannelHandlerContext object, ByteBuf byteBuf, List<Object> list) {
        int n;
        int n2 = byteBuf.readableBytes();
        if (byteBuf.hasArray()) {
            object = byteBuf.array();
            n = byteBuf.arrayOffset() + byteBuf.readerIndex();
        } else {
            ByteBuf byteBuf2 = byteBuf;
            object = ByteBufUtil.getBytes((ByteBuf)byteBuf2, (int)byteBuf2.readerIndex(), (int)n2, (boolean)false);
            n = 0;
        }
        MessageNano messageNano = this.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        list.add(MessageNano.mergeFrom((MessageNano)messageNano, (byte[])object, (int)n, (int)n2));
    }
}

