/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.util;

import dorkbox.util.Sys;
import java.awt.Container;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Ldorkbox/util/ScreenUtil;", "", "()V", "monitorAtMouseLocation", "Ljava/awt/GraphicsDevice;", "getMonitorAtMouseLocation", "()Ljava/awt/GraphicsDevice;", "monitorNumberAtMouseLocation", "", "getMonitorNumberAtMouseLocation", "()I", "version", "", "getVersion", "()Ljava/lang/String;", "getMonitorAtLocation", "pos", "Ljava/awt/Point;", "getMonitorNumberAtLocation", "getScreenBoundsAt", "Ljava/awt/Rectangle;", "showOnSameScreenAsMouse", "", "frame", "Ljava/awt/Container;", "showOnSameScreenAsMouse_Center", "Utilities"})
public final class ScreenUtil {
    public static final ScreenUtil INSTANCE = new ScreenUtil();
    private static final String version = Sys.INSTANCE.getVersion();

    private ScreenUtil() {
    }

    public final String getVersion() {
        return version;
    }

    public final Rectangle getScreenBoundsAt(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        Object object = this.getMonitorAtLocation(point);
        if (object != null && (object = ((GraphicsDevice)object).getDefaultConfiguration()) != null) {
            return ((GraphicsConfiguration)object).getBounds();
        }
        return null;
    }

    public final GraphicsDevice getMonitorAtMouseLocation() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNull((Object)point);
        GraphicsDevice graphicsDevice = this.getMonitorAtLocation(point);
        Intrinsics.checkNotNull((Object)graphicsDevice);
        return graphicsDevice;
    }

    public final GraphicsDevice getMonitorAtLocation(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment();
        graphicsDeviceArray = graphicsDeviceArray.getScreenDevices();
        Intrinsics.checkNotNull((Object)graphicsDeviceArray);
        for (GraphicsDevice graphicsDevice : graphicsDeviceArray) {
            Object object = graphicsDevice.getDefaultConfiguration();
            if (!((Rectangle)(object = ((GraphicsConfiguration)object).getBounds())).contains(point)) continue;
            return graphicsDevice;
        }
        return null;
    }

    public final int getMonitorNumberAtMouseLocation() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNull((Object)point);
        return this.getMonitorNumberAtLocation(point);
    }

    public final int getMonitorNumberAtLocation(Point point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"");
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment();
        graphicsDeviceArray = graphicsDeviceArray.getScreenDevices();
        int n = graphicsDeviceArray.length;
        for (int i = 0; i < n; ++i) {
            Object object = graphicsDeviceArray[i];
            object = ((GraphicsDevice)object).getDefaultConfiguration();
            if (!((Rectangle)(object = ((GraphicsConfiguration)object).getBounds())).contains(point)) continue;
            return i;
        }
        return 0;
    }

    public final void showOnSameScreenAsMouse_Center(Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"");
        Object object = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNull((Object)object);
        object = this.getMonitorAtLocation((Point)object);
        Intrinsics.checkNotNull((Object)object);
        object = ((GraphicsDevice)object).getDefaultConfiguration().getBounds();
        container.setLocation(((Rectangle)object).x + ((Rectangle)object).width / 2 - container.getWidth() / 2, ((Rectangle)object).y + ((Rectangle)object).height / 2 - container.getHeight() / 2);
    }

    public final void showOnSameScreenAsMouse(Container container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"");
        Object object = MouseInfo.getPointerInfo().getLocation();
        Intrinsics.checkNotNull((Object)object);
        GraphicsDevice graphicsDevice = this.getMonitorAtLocation((Point)object);
        Intrinsics.checkNotNull((Object)graphicsDevice);
        object = graphicsDevice;
        object = graphicsDevice.getDefaultConfiguration().getBounds();
        container.setLocation(((Rectangle)object).x, ((Rectangle)object).y);
    }
}

