/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.e.a.i;
import org.e.d.a.e;
import org.e.d.a.f;
import org.e.d.a.g;
import org.e.d.a.j;
import org.jivesoftware.smack.ConnectionConfiguration;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.SmackFuture;
import org.jivesoftware.smack.SmackReactor;
import org.jivesoftware.smack.XmppInputOutputFilter;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnection;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModule;
import org.jivesoftware.smack.c2s.ModularXmppClientToServerConnectionModuleDescriptor;
import org.jivesoftware.smack.c2s.XmppClientToServerTransport;
import org.jivesoftware.smack.c2s.internal.ModularXmppClientToServerConnectionInternal;
import org.jivesoftware.smack.c2s.internal.WalkStateGraphContext;
import org.jivesoftware.smack.debugger.SmackDebugger;
import org.jivesoftware.smack.fsm.State;
import org.jivesoftware.smack.fsm.StateDescriptor;
import org.jivesoftware.smack.fsm.StateTransitionResult;
import org.jivesoftware.smack.internal.SmackTlsContext;
import org.jivesoftware.smack.packet.Nonza;
import org.jivesoftware.smack.packet.StartTls;
import org.jivesoftware.smack.packet.TlsFailure;
import org.jivesoftware.smack.packet.TlsProceed;
import org.jivesoftware.smack.packet.TopLevelStreamElement;
import org.jivesoftware.smack.tcp.ConnectionAttemptState;
import org.jivesoftware.smack.tcp.XmppTcpTransportModuleDescriptor;
import org.jivesoftware.smack.tcp.rce.RemoteXmppTcpConnectionEndpoints;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.CollectionUtil;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.rce.RemoteConnectionEndpointLookupFailure;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class XmppTcpTransportModule
extends ModularXmppClientToServerConnectionModule<XmppTcpTransportModuleDescriptor> {
    private static final Logger LOGGER = Logger.getLogger(XmppTcpTransportModule.class.getName());
    private static final int CALLBACK_MAX_BYTES_READ = 0xA00000;
    private static final int CALLBACK_MAX_BYTES_WRITEN = 0xA00000;
    private static final int MAX_ELEMENT_SIZE = 65536;
    private final XmppTcpNioTransport tcpNioTransport;
    private SelectionKey selectionKey;
    private SmackReactor.SelectionKeyAttachment selectionKeyAttachment;
    private SocketChannel socketChannel;
    private InetSocketAddress remoteAddress;
    private TlsState tlsState;
    private Iterator<CharSequence> outgoingCharSequenceIterator;
    private final List<TopLevelStreamElement> currentlyOutgoingElements = new ArrayList<TopLevelStreamElement>();
    private final Map<ByteBuffer, List<TopLevelStreamElement>> bufferToElementMap = new IdentityHashMap<ByteBuffer, List<TopLevelStreamElement>>();
    private ByteBuffer outgoingBuffer;
    private ByteBuffer filteredOutgoingBuffer;
    private final List<ByteBuffer> networkOutgoingBuffers = new ArrayList<ByteBuffer>();
    private long networkOutgoingBuffersBytes;
    private final ByteBuffer incomingBuffer = ByteBuffer.allocateDirect(8192);
    private final ReentrantLock channelSelectedCallbackLock = new ReentrantLock();
    private long totalBytesRead;
    private long totalBytesWritten;
    private long totalBytesReadAfterFilter;
    private long totalBytesWrittenBeforeFilter;
    private long handledChannelSelectedCallbacks;
    private long callbackPreemtBecauseBytesWritten;
    private long callbackPreemtBecauseBytesRead;
    private int sslEngineDelegatedTasks;
    private int maxPendingSslEngineDelegatedTasks;
    private final AtomicLong setWriteInterestAfterChannelSelectedCallback = new AtomicLong();
    private final AtomicLong reactorThreadAlreadyRacing = new AtomicLong();
    private final AtomicLong afterOutgoingElementsQueueModifiedSetInterestOps = new AtomicLong();
    private final AtomicLong rejectedChannelSelectedCallbacks = new AtomicLong();
    private i lastDestinationAddress;
    private boolean pendingInputFilterData;
    private boolean pendingOutputFilterData;
    private boolean pendingWriteInterestAfterRead;
    private e splitter;
    private j outputDebugSplitter;
    private static final Level STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL = Level.FINER;
    private final org.e.d.a.i xmppElementCallback = new org.e.d.a.i(){
        private String streamOpen;
        private String streamClose;

        public void onCompleteElement(String string) {
            assert (this.streamOpen != null);
            assert (this.streamClose != null);
            XmppTcpTransportModule.this.connectionInternal.withSmackDebugger(smackDebugger -> smackDebugger.onIncomingElementCompleted());
            string = this.streamOpen + string + this.streamClose;
            XmppTcpTransportModule.this.connectionInternal.parseAndProcessElement(string);
        }

        public void streamOpened(String object, Map<String, String> object22) {
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " opened. prefix=" + (String)object + " attributes=" + object22);
            }
            String string = "xmlns:" + (String)object;
            StringBuilder stringBuilder = new StringBuilder(32);
            StringBuilder stringBuilder2 = new StringBuilder(256);
            stringBuilder2.append('<');
            stringBuilder.append("</");
            if (StringUtils.isNotEmpty((CharSequence)object)) {
                stringBuilder2.append((String)object).append(':');
                stringBuilder.append((String)object).append(':');
            }
            stringBuilder2.append("stream");
            stringBuilder.append("stream>");
            block15: for (Map.Entry entry : object22.entrySet()) {
                String string2 = (String)entry.getKey();
                String string3 = (String)entry.getValue();
                switch (string2) {
                    case "to": 
                    case "from": 
                    case "id": 
                    case "version": {
                        continue block15;
                    }
                    case "xml:lang": {
                        stringBuilder2.append(" xml:lang='").append(string3).append('\'');
                        continue block15;
                    }
                    case "xmlns": {
                        stringBuilder2.append(" xmlns='").append(string3).append('\'');
                        continue block15;
                    }
                }
                if (string2.equals(string)) {
                    stringBuilder2.append(' ').append(string).append("='").append(string3).append('\'');
                    continue;
                }
                LOGGER.info("Unknown <stream/> attribute: " + string2);
            }
            stringBuilder2.append('>');
            this.streamOpen = stringBuilder2.toString();
            this.streamClose = stringBuilder.toString();
            try {
                object = PacketParserUtils.getParserFor((String)this.streamOpen);
            }
            catch (IOException | XmlPullParserException throwable) {
                throw new AssertionError((Object)throwable);
            }
            XmppTcpTransportModule.this.connectionInternal.onStreamOpen(object);
        }

        public void streamClosed() {
            if (LOGGER.isLoggable(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL)) {
                LOGGER.log(STREAM_OPEN_CLOSE_DEBUG_LOG_LEVEL, "Stream of " + this + " closed");
            }
            XmppTcpTransportModule.this.connectionInternal.onStreamClosed();
        }
    };
    XmppTcpNioTransport.DiscoveredTcpEndpoints discoveredTcpEndpoints;
    private static final Level SSL_ENGINE_DEBUG_LOG_LEVEL = Level.FINEST;

    XmppTcpTransportModule(XmppTcpTransportModuleDescriptor xmppTcpTransportModuleDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        super((ModularXmppClientToServerConnectionModuleDescriptor)xmppTcpTransportModuleDescriptor, modularXmppClientToServerConnectionInternal);
        this.tcpNioTransport = new XmppTcpNioTransport(modularXmppClientToServerConnectionInternal);
        xmppTcpTransportModuleDescriptor = null;
        modularXmppClientToServerConnectionInternal = modularXmppClientToServerConnectionInternal.smackDebugger;
        if (modularXmppClientToServerConnectionInternal != null) {
            xmppTcpTransportModuleDescriptor = f.d().a(arg_0 -> XmppTcpTransportModule.lambda$new$0((SmackDebugger)modularXmppClientToServerConnectionInternal, arg_0)).a();
            modularXmppClientToServerConnectionInternal = f.d().a(arg_0 -> XmppTcpTransportModule.lambda$new$1((SmackDebugger)modularXmppClientToServerConnectionInternal, arg_0)).a();
            this.outputDebugSplitter = new j((f)modularXmppClientToServerConnectionInternal);
        }
        modularXmppClientToServerConnectionInternal = new j(65536, this.xmppElementCallback, (g)xmppTcpTransportModuleDescriptor);
        this.splitter = new e((j)modularXmppClientToServerConnectionInternal);
    }

    /*
     * Exception decompiling
     */
    private void onChannelSelected(SelectableChannel var1_1, SelectionKey var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 22[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void handleReadWriteIoException(IOException iOException) {
        if (iOException instanceof ClosedChannelException && !this.tcpNioTransport.isConnected()) {
            return;
        }
        this.connectionInternal.notifyConnectionError((Exception)iOException);
    }

    private void afterOutgoingElementsQueueModified() {
        SmackReactor.SelectionKeyAttachment selectionKeyAttachment = this.selectionKeyAttachment;
        if (selectionKeyAttachment != null && selectionKeyAttachment.isReactorThreadRacing()) {
            this.reactorThreadAlreadyRacing.incrementAndGet();
            return;
        }
        this.afterOutgoingElementsQueueModifiedSetInterestOps.incrementAndGet();
        this.connectionInternal.setInterestOps(this.selectionKey, 5);
    }

    protected XmppTcpNioTransport getTransport() {
        return this.tcpNioTransport;
    }

    private EstablishingTcpConnectionState constructEstablishingTcpConnectionState(EstablishingTcpConnectionStateDescriptor establishingTcpConnectionStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        return new EstablishingTcpConnectionState(establishingTcpConnectionStateDescriptor, modularXmppClientToServerConnectionInternal);
    }

    private EstablishTlsState constructEstablishingTlsState(EstablishTlsStateDescriptor establishTlsStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
        return new EstablishTlsState(establishTlsStateDescriptor, modularXmppClientToServerConnectionInternal);
    }

    private static void debugLogSslEngineResult(String string, SSLEngineResult sSLEngineResult) {
        if (!LOGGER.isLoggable(SSL_ENGINE_DEBUG_LOG_LEVEL)) {
            return;
        }
        LOGGER.log(SSL_ENGINE_DEBUG_LOG_LEVEL, "SSLEngineResult of " + string + "(): " + sSLEngineResult);
    }

    private void callChannelSelectedCallback(boolean bl, boolean bl2) {
        SocketChannel socketChannel = this.socketChannel;
        SelectionKey selectionKey = this.selectionKey;
        if (socketChannel == null || selectionKey == null) {
            LOGGER.info("Not calling channel selected callback because the connection was eventually disconnected");
            return;
        }
        this.channelSelectedCallbackLock.lock();
        try {
            if (bl) {
                this.pendingInputFilterData = true;
            }
            if (bl2) {
                this.pendingOutputFilterData = true;
            }
            this.onChannelSelected(socketChannel, selectionKey);
            return;
        }
        finally {
            this.channelSelectedCallbackLock.unlock();
        }
    }

    private void closeSocketAndCleanup() {
        Object object = this.selectionKey;
        if (object != null) {
            ((SelectionKey)object).cancel();
        }
        if ((object = this.socketChannel) != null) {
            try {
                ((AbstractInterruptibleChannel)object).close();
            }
            catch (IOException iOException) {}
        }
        this.selectionKey = null;
        this.socketChannel = null;
        this.selectionKeyAttachment = null;
        this.remoteAddress = null;
    }

    private static List<? extends Buffer> pruneBufferList(Collection<? extends Buffer> collection) {
        return CollectionUtil.removeUntil(collection, buffer -> buffer.hasRemaining());
    }

    public Stats getStats() {
        return new Stats(this);
    }

    private static /* synthetic */ void lambda$new$1(SmackDebugger smackDebugger, StringBuilder stringBuilder) {
        smackDebugger.outgoingStreamSink((CharSequence)stringBuilder);
    }

    private static /* synthetic */ void lambda$new$0(SmackDebugger smackDebugger, StringBuilder stringBuilder) {
        smackDebugger.incomingStreamSink((CharSequence)stringBuilder);
    }

    public static final class Stats
    extends XmppClientToServerTransport.Stats {
        public final long totalBytesWritten;
        public final long totalBytesWrittenBeforeFilter;
        public final double writeRatio;
        public final long totalBytesRead;
        public final long totalBytesReadAfterFilter;
        public final double readRatio;
        public final long handledChannelSelectedCallbacks;
        public final long setWriteInterestAfterChannelSelectedCallback;
        public final long reactorThreadAlreadyRacing;
        public final long afterOutgoingElementsQueueModifiedSetInterestOps;
        public final long rejectedChannelSelectedCallbacks;
        public final long totalCallbackRequests;
        public final long callbackPreemtBecauseBytesWritten;
        public final long callbackPreemtBecauseBytesRead;
        public final int sslEngineDelegatedTasks;
        public final int maxPendingSslEngineDelegatedTasks;
        private transient String toStringCache;

        private Stats(XmppTcpTransportModule xmppTcpTransportModule) {
            this.totalBytesWritten = xmppTcpTransportModule.totalBytesWritten;
            this.totalBytesWrittenBeforeFilter = xmppTcpTransportModule.totalBytesWrittenBeforeFilter;
            this.writeRatio = (double)this.totalBytesWritten / (double)this.totalBytesWrittenBeforeFilter;
            this.totalBytesReadAfterFilter = xmppTcpTransportModule.totalBytesReadAfterFilter;
            this.totalBytesRead = xmppTcpTransportModule.totalBytesRead;
            this.readRatio = (double)this.totalBytesRead / (double)this.totalBytesReadAfterFilter;
            this.handledChannelSelectedCallbacks = xmppTcpTransportModule.handledChannelSelectedCallbacks;
            this.setWriteInterestAfterChannelSelectedCallback = xmppTcpTransportModule.setWriteInterestAfterChannelSelectedCallback.get();
            this.reactorThreadAlreadyRacing = xmppTcpTransportModule.reactorThreadAlreadyRacing.get();
            this.afterOutgoingElementsQueueModifiedSetInterestOps = xmppTcpTransportModule.afterOutgoingElementsQueueModifiedSetInterestOps.get();
            this.rejectedChannelSelectedCallbacks = xmppTcpTransportModule.rejectedChannelSelectedCallbacks.get();
            this.totalCallbackRequests = this.handledChannelSelectedCallbacks + this.rejectedChannelSelectedCallbacks;
            this.callbackPreemtBecauseBytesRead = xmppTcpTransportModule.callbackPreemtBecauseBytesRead;
            this.callbackPreemtBecauseBytesWritten = xmppTcpTransportModule.callbackPreemtBecauseBytesWritten;
            this.sslEngineDelegatedTasks = xmppTcpTransportModule.sslEngineDelegatedTasks;
            this.maxPendingSslEngineDelegatedTasks = xmppTcpTransportModule.maxPendingSslEngineDelegatedTasks;
        }

        public final String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "Total bytes\nrecv: " + this.totalBytesRead + '\n' + "send: " + this.totalBytesWritten + '\n' + "recv-aft-filter: " + this.totalBytesReadAfterFilter + '\n' + "send-bef-filter: " + this.totalBytesWrittenBeforeFilter + '\n' + "read-ratio: " + this.readRatio + '\n' + "write-ratio: " + this.writeRatio + '\n' + "Events\ntotal-callback-requests: " + this.totalCallbackRequests + '\n' + "handled-channel-selected-callbacks: " + this.handledChannelSelectedCallbacks + '\n' + "rejected-channel-selected-callbacks: " + this.rejectedChannelSelectedCallbacks + '\n' + "set-write-interest-after-callback: " + this.setWriteInterestAfterChannelSelectedCallback + '\n' + "reactor-thread-already-racing: " + this.reactorThreadAlreadyRacing + '\n' + "after-queue-modified-set-interest-ops: " + this.afterOutgoingElementsQueueModifiedSetInterestOps + '\n' + "callback-preemt-because-bytes-read: " + this.callbackPreemtBecauseBytesRead + '\n' + "callback-preemt-because-bytes-written: " + this.callbackPreemtBecauseBytesWritten + '\n' + "ssl-engine-delegated-tasks: " + this.sslEngineDelegatedTasks + '\n' + "max-pending-ssl-engine-delegated-tasks: " + this.maxPendingSslEngineDelegatedTasks + '\n';
            return this.toStringCache;
        }
    }

    public static final class TlsStateStats {
        public final long wrapInBytes;
        public final long wrapOutBytes;
        public final double wrapRatio;
        public final long unwrapInBytes;
        public final long unwrapOutBytes;
        public final double unwrapRatio;
        private transient String toStringCache;

        private TlsStateStats(TlsState tlsState) {
            this.wrapOutBytes = tlsState.wrapOutBytes;
            this.wrapInBytes = tlsState.wrapInBytes;
            this.wrapRatio = (double)this.wrapOutBytes / (double)this.wrapInBytes;
            this.unwrapOutBytes = tlsState.unwrapOutBytes;
            this.unwrapInBytes = tlsState.unwrapInBytes;
            this.unwrapRatio = (double)this.unwrapInBytes / (double)this.unwrapOutBytes;
        }

        public final String toString() {
            if (this.toStringCache != null) {
                return this.toStringCache;
            }
            this.toStringCache = "wrap-in-bytes: " + this.wrapInBytes + '\n' + "wrap-out-bytes: " + this.wrapOutBytes + '\n' + "wrap-ratio: " + this.wrapRatio + '\n' + "unwrap-in-bytes: " + this.unwrapInBytes + '\n' + "unwrap-out-bytes: " + this.unwrapOutBytes + '\n' + "unwrap-ratio: " + this.unwrapRatio + '\n';
            return this.toStringCache;
        }
    }

    private final class TlsState
    implements XmppInputOutputFilter {
        private static final int MAX_PENDING_OUTPUT_BYTES = 8096;
        private final SmackTlsContext smackTlsContext;
        private final SSLEngine engine;
        private TlsHandshakeStatus handshakeStatus = TlsHandshakeStatus.initial;
        private SSLException handshakeException;
        private ByteBuffer myNetData;
        private ByteBuffer peerAppData;
        private final List<ByteBuffer> pendingOutputData = new ArrayList<ByteBuffer>();
        private int pendingOutputBytes;
        private ByteBuffer pendingInputData;
        private final AtomicInteger pendingDelegatedTasks = new AtomicInteger();
        private long wrapInBytes;
        private long wrapOutBytes;
        private long unwrapInBytes;
        private long unwrapOutBytes;

        private TlsState(SmackTlsContext smackTlsContext) {
            this.smackTlsContext = smackTlsContext;
            String string = ((XmppTcpTransportModule)((Object)XmppTcpTransportModule.this)).connectionInternal.connection.getConfiguration().getXMPPServiceDomain().toString();
            this.engine = smackTlsContext.sslContext.createSSLEngine(string, ((XmppTcpTransportModule)((Object)XmppTcpTransportModule.this)).remoteAddress.getPort());
            this.engine.setUseClientMode(true);
            XmppTcpTransportModule.this = this.engine.getSession();
            int n = XmppTcpTransportModule.this.getApplicationBufferSize();
            int n2 = XmppTcpTransportModule.this.getPacketBufferSize();
            this.myNetData = ByteBuffer.allocateDirect(n2);
            this.peerAppData = ByteBuffer.allocate(n);
        }

        public final XmppInputOutputFilter.OutputResult output(ByteBuffer byteBuffer, boolean bl, boolean bl2, boolean bl3) {
            if (byteBuffer != null) {
                this.pendingOutputData.add(byteBuffer);
                this.pendingOutputBytes += byteBuffer.remaining();
                if (bl3 && this.pendingOutputBytes < 8096) {
                    return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                }
            }
            ByteBuffer[] byteBufferArray = this.pendingOutputData.toArray(new ByteBuffer[this.pendingOutputData.size()]);
            this.myNetData.clear();
            block12: while (true) {
                Object object;
                try {
                    object = this.engine.wrap(byteBufferArray, this.myNetData);
                }
                catch (SSLException sSLException) {
                    this.handleSslException(sSLException);
                    throw sSLException;
                }
                XmppTcpTransportModule.debugLogSslEngineResult("wrap", (SSLEngineResult)object);
                SSLEngineResult.Status status = ((SSLEngineResult)object).getStatus();
                this.pendingOutputBytes -= ((SSLEngineResult)object).bytesConsumed();
                if (status == SSLEngineResult.Status.OK) {
                    this.wrapInBytes += (long)((SSLEngineResult)object).bytesConsumed();
                    this.wrapOutBytes += (long)((SSLEngineResult)object).bytesProduced();
                    object = this.handleHandshakeStatus((SSLEngineResult)object);
                    switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[((Enum)object).ordinal()]) {
                        case 1: {
                            break;
                        }
                        case 2: 
                        case 3: {
                            return new XmppInputOutputFilter.OutputResult(true, this.myNetData);
                        }
                    }
                }
                switch (status) {
                    case OK: {
                        XmppTcpTransportModule.pruneBufferList(this.pendingOutputData);
                        return new XmppInputOutputFilter.OutputResult(!this.pendingOutputData.isEmpty(), this.myNetData);
                    }
                    case CLOSED: {
                        this.pendingOutputData.clear();
                        return XmppInputOutputFilter.OutputResult.NO_OUTPUT;
                    }
                    case BUFFER_OVERFLOW: {
                        LOGGER.warning("SSLEngine status BUFFER_OVERFLOW, this is hopefully uncommon");
                        int n = byteBuffer != null ? byteBuffer.remaining() : 0;
                        n = (int)(1.3 * (double)n);
                        if (n <= this.myNetData.capacity()) {
                            n = 2 * this.myNetData.capacity();
                        }
                        ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n);
                        this.myNetData.flip();
                        byteBuffer2.put(this.myNetData);
                        this.myNetData = byteBuffer2;
                        continue block12;
                    }
                    case BUFFER_UNDERFLOW: {
                        throw new IllegalStateException("Buffer underflow as result of SSLEngine.wrap() should never happen");
                    }
                }
            }
        }

        public final ByteBuffer input(ByteBuffer object) {
            ByteBuffer byteBuffer;
            if (this.pendingInputData == null) {
                byteBuffer = object;
            } else {
                assert (this.pendingInputData != object);
                int n = this.pendingInputData.remaining() + ((Buffer)object).remaining();
                byteBuffer = ByteBuffer.allocate(n);
                byteBuffer.put(this.pendingInputData).put((ByteBuffer)object).flip();
                this.pendingInputData = null;
            }
            this.peerAppData.clear();
            block13: while (true) {
                Object object2;
                try {
                    object2 = this.engine.unwrap(byteBuffer, this.peerAppData);
                }
                catch (SSLException sSLException) {
                    this.handleSslException(sSLException);
                    throw sSLException;
                }
                XmppTcpTransportModule.debugLogSslEngineResult("unwrap", (SSLEngineResult)object2);
                object = ((SSLEngineResult)object2).getStatus();
                if (object == SSLEngineResult.Status.OK) {
                    this.unwrapInBytes += (long)((SSLEngineResult)object2).bytesConsumed();
                    this.unwrapOutBytes += (long)((SSLEngineResult)object2).bytesProduced();
                    object2 = this.handleHandshakeStatus((SSLEngineResult)object2);
                    switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[((Enum)object2).ordinal()]) {
                        case 3: {
                            this.addAsPendingInputData(byteBuffer);
                            return null;
                        }
                        case 1: {
                            continue block13;
                        }
                        case 2: {
                            this.addAsPendingInputData(byteBuffer);
                            XmppTcpTransportModule.this.connectionInternal.asyncGo(() -> XmppTcpTransportModule.this.callChannelSelectedCallback(false, true));
                            return null;
                        }
                    }
                }
                switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$Status[((Enum)object).ordinal()]) {
                    case 1: {
                        if (byteBuffer.hasRemaining()) continue block13;
                        return this.peerAppData;
                    }
                    case 2: {
                        return null;
                    }
                    case 4: {
                        this.addAsPendingInputData(byteBuffer);
                        return null;
                    }
                    case 3: {
                        int n = this.engine.getSession().getApplicationBufferSize();
                        assert (this.peerAppData.remaining() < n);
                        this.peerAppData = ByteBuffer.allocate(n);
                        continue block13;
                    }
                }
            }
        }

        private void addAsPendingInputData(ByteBuffer byteBuffer) {
            this.pendingInputData = ByteBuffer.allocate(byteBuffer.remaining());
            this.pendingInputData.put(byteBuffer).flip();
            XmppTcpTransportModule.this.pendingInputFilterData = this.pendingInputData.hasRemaining();
        }

        private SSLEngineResult.HandshakeStatus handleHandshakeStatus(SSLEngineResult object) {
            object = object.getHandshakeStatus();
            switch (2.$SwitchMap$javax$net$ssl$SSLEngineResult$HandshakeStatus[((Enum)object).ordinal()]) {
                case 3: {
                    while ((object = this.engine.getDelegatedTask()) != null) {
                        XmppTcpTransportModule.this.sslEngineDelegatedTasks++;
                        int n = this.pendingDelegatedTasks.incrementAndGet();
                        if (n > XmppTcpTransportModule.this.maxPendingSslEngineDelegatedTasks) {
                            XmppTcpTransportModule.this.maxPendingSslEngineDelegatedTasks = n;
                        }
                        object = () -> this.lambda$handleHandshakeStatus$1((Runnable)object);
                        XmppTcpTransportModule.this.connectionInternal.asyncGo((Runnable)object);
                    }
                    break;
                }
                case 4: {
                    this.onHandshakeFinished();
                }
            }
            object = this.engine.getHandshakeStatus();
            return object;
        }

        private void handleSslException(SSLException sSLException) {
            this.handshakeException = sSLException;
            this.handshakeStatus = TlsHandshakeStatus.failed;
            XmppTcpTransportModule.this.connectionInternal.notifyWaitingThreads();
        }

        private void onHandshakeFinished() {
            this.handshakeStatus = TlsHandshakeStatus.successful;
            XmppTcpTransportModule.this.connectionInternal.notifyWaitingThreads();
        }

        private boolean isHandshakeFinished() {
            return this.handshakeStatus == TlsHandshakeStatus.successful || this.handshakeStatus == TlsHandshakeStatus.failed;
        }

        private void waitForHandshakeFinished() {
            XmppTcpTransportModule.this.connectionInternal.waitForConditionOrThrowConnectionException(() -> this.isHandshakeFinished(), "TLS handshake to finish");
            if (this.handshakeStatus == TlsHandshakeStatus.failed) {
                throw this.handshakeException;
            }
            assert (this.handshakeStatus == TlsHandshakeStatus.successful);
            if (this.smackTlsContext.daneVerifier != null) {
                this.smackTlsContext.daneVerifier.finish(this.engine.getSession());
            }
        }

        public final Object getStats() {
            return new TlsStateStats(this);
        }

        public final void closeInputOutput() {
            this.engine.closeOutbound();
            try {
                this.engine.closeInbound();
                return;
            }
            catch (SSLException sSLException) {
                LOGGER.log(Level.FINEST, "SSLException when closing inbound TLS session. This can likely be ignored if a possible truncation attack is suggested. You may want to ask your XMPP server vendor to implement a clean TLS session shutdown sending close_notify after </stream>", sSLException);
                return;
            }
        }

        public final void waitUntilInputOutputClosed() {
            this.waitForHandshakeFinished();
        }

        public final String getFilterName() {
            return "TLS (" + this.engine + ')';
        }

        private /* synthetic */ void lambda$handleHandshakeStatus$1(Runnable runnable) {
            runnable.run();
            int n = this.pendingDelegatedTasks.decrementAndGet();
            if (n == 0) {
                XmppTcpTransportModule.this.callChannelSelectedCallback(true, true);
            }
        }
    }

    private static enum TlsHandshakeStatus {
        initial,
        initiated,
        successful,
        failed;

    }

    private final class EstablishTlsState
    extends State {
        private EstablishTlsState(EstablishTlsStateDescriptor establishTlsStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super((StateDescriptor)establishTlsStateDescriptor, modularXmppClientToServerConnectionInternal);
        }

        public final StateTransitionResult.TransitionImpossible isTransitionToPossible(WalkStateGraphContext walkStateGraphContext) {
            walkStateGraphContext = (StartTls)this.connectionInternal.connection.getFeature(StartTls.class);
            ConnectionConfiguration.SecurityMode securityMode = this.connectionInternal.connection.getConfiguration().getSecurityMode();
            switch (securityMode) {
                case required: 
                case ifpossible: {
                    if (walkStateGraphContext == null) {
                        if (securityMode == ConnectionConfiguration.SecurityMode.ifpossible) {
                            return new StateTransitionResult.TransitionImpossibleReason("Server does not announce support for TLS and we do not required it");
                        }
                        throw new SmackException.SecurityRequiredByClientException();
                    }
                    return null;
                }
                case disabled: {
                    if (walkStateGraphContext != null && walkStateGraphContext.required()) {
                        throw new SmackException.SecurityRequiredByServerException();
                    }
                    return new StateTransitionResult.TransitionImpossibleReason("TLS disabled in client settings and server does not require it");
                }
            }
            throw new AssertionError((Object)("Unknown security mode: " + securityMode));
        }

        public final StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext walkStateGraphContext) {
            this.connectionInternal.sendAndWaitForResponse((Nonza)StartTls.INSTANCE, TlsProceed.class, TlsFailure.class);
            walkStateGraphContext = this.connectionInternal.getSmackTlsContext();
            XmppTcpTransportModule.this.tlsState = new TlsState((SmackTlsContext)walkStateGraphContext);
            this.connectionInternal.addXmppInputOutputFilter((XmppInputOutputFilter)XmppTcpTransportModule.this.tlsState);
            XmppTcpTransportModule.this.channelSelectedCallbackLock.lock();
            try {
                XmppTcpTransportModule.this.pendingOutputFilterData = true;
                XmppTcpTransportModule.this.tlsState.engine.beginHandshake();
                XmppTcpTransportModule.this.tlsState.handshakeStatus = TlsHandshakeStatus.initiated;
            }
            finally {
                XmppTcpTransportModule.this.channelSelectedCallbackLock.unlock();
            }
            this.connectionInternal.setInterestOps(XmppTcpTransportModule.this.selectionKey, 5);
            try {
                XmppTcpTransportModule.this.tlsState.waitForHandshakeFinished();
            }
            catch (CertificateException certificateException) {
                throw new SmackException.SmackCertificateException(certificateException);
            }
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after TLS established");
            return new TlsEstablishedResult(XmppTcpTransportModule.this.tlsState.engine);
        }

        public final void resetState() {
            XmppTcpTransportModule.this.tlsState = null;
        }
    }

    static final class EstablishTlsStateDescriptor
    extends StateDescriptor {
        private EstablishTlsStateDescriptor() {
            super(EstablishTlsState.class, "RFC 6120 \u00a7 5");
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
            this.declarePrecedenceOver(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }

        protected final EstablishTlsState constructState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            XmppTcpTransportModule xmppTcpTransportModule = (XmppTcpTransportModule)modularXmppClientToServerConnectionInternal.connection.getConnectionModuleFor(XmppTcpTransportModuleDescriptor.class);
            return xmppTcpTransportModule.constructEstablishingTlsState(this, modularXmppClientToServerConnectionInternal);
        }
    }

    public static final class TlsEstablishedResult
    extends StateTransitionResult.Success {
        private TlsEstablishedResult(SSLEngine sSLEngine) {
            super("TLS established: " + sSLEngine.getSession());
        }
    }

    public static final class TcpSocketConnectedResult
    extends StateTransitionResult.Success {
        private final InetSocketAddress remoteAddress;

        private TcpSocketConnectedResult(InetSocketAddress inetSocketAddress) {
            super("TCP connection established to " + inetSocketAddress);
            this.remoteAddress = inetSocketAddress;
        }

        public final InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }
    }

    final class EstablishingTcpConnectionState
    extends State {
        private EstablishingTcpConnectionState(EstablishingTcpConnectionStateDescriptor establishingTcpConnectionStateDescriptor, ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super((StateDescriptor)establishingTcpConnectionStateDescriptor, modularXmppClientToServerConnectionInternal);
        }

        public final StateTransitionResult.AttemptResult transitionInto(WalkStateGraphContext object) {
            object = new ConnectionAttemptState(this.connectionInternal, XmppTcpTransportModule.this.discoveredTcpEndpoints, this);
            StateTransitionResult.Failure failure = object.establishTcpConnection();
            if (failure != null) {
                return failure;
            }
            XmppTcpTransportModule.this.socketChannel = object.socketChannel;
            XmppTcpTransportModule.this.remoteAddress = (InetSocketAddress)XmppTcpTransportModule.this.socketChannel.socket().getRemoteSocketAddress();
            XmppTcpTransportModule.this.selectionKey = this.connectionInternal.registerWithSelector((SelectableChannel)XmppTcpTransportModule.this.socketChannel, 1, (selectableChannel, selectionKey) -> XmppTcpTransportModule.this.onChannelSelected(selectableChannel, selectionKey));
            XmppTcpTransportModule.this.selectionKeyAttachment = (SmackReactor.SelectionKeyAttachment)XmppTcpTransportModule.this.selectionKey.attachment();
            this.connectionInternal.setTransport((XmppClientToServerTransport)XmppTcpTransportModule.this.tcpNioTransport);
            this.connectionInternal.newStreamOpenWaitForFeaturesSequence("stream features after initial connection");
            return new TcpSocketConnectedResult(XmppTcpTransportModule.this.remoteAddress);
        }

        public final void resetState() {
            XmppTcpTransportModule.this.closeSocketAndCleanup();
        }
    }

    static final class EstablishingTcpConnectionStateDescriptor
    extends StateDescriptor {
        private EstablishingTcpConnectionStateDescriptor() {
            super(EstablishingTcpConnectionState.class);
            this.addPredeccessor(ModularXmppClientToServerConnection.LookupRemoteConnectionEndpointsStateDescriptor.class);
            this.addSuccessor(EstablishTlsStateDescriptor.class);
            this.addSuccessor(ModularXmppClientToServerConnection.ConnectedButUnauthenticatedStateDescriptor.class);
        }

        protected final EstablishingTcpConnectionState constructState(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            XmppTcpTransportModule xmppTcpTransportModule = (XmppTcpTransportModule)modularXmppClientToServerConnectionInternal.connection.getConnectionModuleFor(XmppTcpTransportModuleDescriptor.class);
            return xmppTcpTransportModule.constructEstablishingTcpConnectionState(this, modularXmppClientToServerConnectionInternal);
        }
    }

    final class XmppTcpNioTransport
    extends XmppClientToServerTransport {
        protected XmppTcpNioTransport(ModularXmppClientToServerConnectionInternal modularXmppClientToServerConnectionInternal) {
            super(modularXmppClientToServerConnectionInternal);
        }

        protected final void resetDiscoveredConnectionEndpoints() {
            XmppTcpTransportModule.this.discoveredTcpEndpoints = null;
        }

        protected final List<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> lookupConnectionEndpoints() {
            assert (XmppTcpTransportModule.this.discoveredTcpEndpoints == null);
            ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>> arrayList = new ArrayList<SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>>(2);
            SmackFuture.InternalSmackFuture internalSmackFuture = new SmackFuture.InternalSmackFuture();
            this.connectionInternal.asyncGo(() -> {
                Object object = RemoteXmppTcpConnectionEndpoints.lookup((ConnectionConfiguration)this.connectionInternal.connection.getConfiguration());
                object = ((RemoteXmppTcpConnectionEndpoints.Result)object).discoveredRemoteConnectionEndpoints.isEmpty() ? new TcpEndpointDiscoveryFailed((RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint>)object) : new DiscoveredTcpEndpoints((RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint>)object);
                internalSmackFuture.setResult(object);
            });
            arrayList.add((SmackFuture<XmppClientToServerTransport.LookupConnectionEndpointsResult, Exception>)internalSmackFuture);
            if (((XmppTcpTransportModuleDescriptor)XmppTcpTransportModule.this.moduleDescriptor).isDirectTlsEnabled()) {
                throw new IllegalArgumentException("DirectTLS is not implemented yet");
            }
            return arrayList;
        }

        protected final void loadConnectionEndpoints(XmppClientToServerTransport.LookupConnectionEndpointsSuccess lookupConnectionEndpointsSuccess) {
            XmppTcpTransportModule.this.discoveredTcpEndpoints = (DiscoveredTcpEndpoints)lookupConnectionEndpointsSuccess;
        }

        protected final void afterFiltersClosed() {
            XmppTcpTransportModule.this.pendingInputFilterData = (XmppTcpTransportModule.this.pendingOutputFilterData = true);
            XmppTcpTransportModule.this.afterOutgoingElementsQueueModified();
        }

        protected final void disconnect() {
            XmppTcpTransportModule.this.closeSocketAndCleanup();
        }

        protected final void notifyAboutNewOutgoingElements() {
            XmppTcpTransportModule.this.afterOutgoingElementsQueueModified();
        }

        public final SSLSession getSslSession() {
            TlsState tlsState = XmppTcpTransportModule.this.tlsState;
            if (tlsState == null) {
                return null;
            }
            return tlsState.engine.getSession();
        }

        public final boolean isConnected() {
            SocketChannel socketChannel = XmppTcpTransportModule.this.socketChannel;
            if (socketChannel == null) {
                return false;
            }
            return socketChannel.isConnected();
        }

        public final boolean isTransportSecured() {
            TlsState tlsState = XmppTcpTransportModule.this.tlsState;
            return tlsState != null && tlsState.handshakeStatus == TlsHandshakeStatus.successful;
        }

        public final Stats getStats() {
            return XmppTcpTransportModule.this.getStats();
        }

        final class TcpEndpointDiscoveryFailed
        implements XmppClientToServerTransport.LookupConnectionEndpointsFailed {
            final List<RemoteConnectionEndpointLookupFailure> lookupFailures;

            TcpEndpointDiscoveryFailed(RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result) {
                this.lookupFailures = result.lookupFailures;
            }
        }

        final class DiscoveredTcpEndpoints
        implements XmppClientToServerTransport.LookupConnectionEndpointsSuccess {
            final RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result;

            DiscoveredTcpEndpoints(RemoteXmppTcpConnectionEndpoints.Result<Rfc6120TcpRemoteConnectionEndpoint> result) {
                this.result = result;
            }
        }
    }
}

