/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.window;

import androidx.compose.runtime.Applier;
import java.awt.Menu;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016J\b\u0010\u0010\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J \u0010\u0016\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\u0018\u0010\u001a\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0013H\u0016J\f\u0010\u001b\u001a\u00020\u0004*\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u0002X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u001c"}, d2={"Landroidx/compose/ui/window/MenuItemApplier;", "Landroidx/compose/runtime/Applier;", "Ljava/awt/MenuItem;", "root", "Ljava/awt/Menu;", "<init>", "(Ljava/awt/Menu;)V", "current", "getCurrent", "()Ljava/awt/MenuItem;", "setCurrent", "(Ljava/awt/MenuItem;)V", "up", "", "down", "node", "clear", "insertBottomUp", "index", "", "instance", "insertTopDown", "move", "from", "to", "count", "remove", "asMenu", "ui"})
public final class MenuItemApplier
implements Applier<MenuItem> {
    private final Menu root;
    private MenuItem current;
    public static final int $stable = 8;

    public MenuItemApplier(Menu menu) {
        Intrinsics.checkNotNullParameter((Object)menu, (String)"");
        this.root = menu;
        this.current = this.root;
    }

    public final MenuItem getCurrent() {
        return this.current;
    }

    public final void setCurrent(MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
        this.current = menuItem;
    }

    public final void up() {
        if (!(!Intrinsics.areEqual((Object)this.getCurrent(), (Object)this.root))) {
            throw new IllegalStateException("Check failed.");
        }
        MenuItemApplier menuItemApplier = this;
        MenuContainer menuContainer = menuItemApplier.getCurrent().getParent();
        Intrinsics.checkNotNull((Object)menuContainer);
        menuItemApplier.setCurrent((MenuItem)((Object)menuContainer));
    }

    public final void down(MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
        if (!Intrinsics.areEqual((Object)this.getCurrent(), (Object)menuItem.getParent())) {
            throw new IllegalStateException("Check failed.");
        }
        this.setCurrent(menuItem);
    }

    public final void clear() {
        MenuItemApplier menuItemApplier = this;
        menuItemApplier.setCurrent(menuItemApplier.root);
        this.root.removeAll();
    }

    public final void insertBottomUp(int n2, MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
    }

    public final void insertTopDown(int n2, MenuItem menuItem) {
        Intrinsics.checkNotNullParameter((Object)menuItem, (String)"");
        MenuItemApplier menuItemApplier = this;
        Menu menu = menuItemApplier.asMenu(menuItemApplier.getCurrent());
        menu.insert(menuItem, n2);
    }

    public final void move(int n2, int n3, int n4) {
        MenuItemApplier menuItemApplier = this;
        Menu menu = menuItemApplier.asMenu(menuItemApplier.getCurrent());
        if (n2 > n3) {
            int n5 = n3;
            for (n3 = 0; n3 < n4; ++n3) {
                MenuItem menuItem = menu.getItem(n2);
                menu.remove(n2);
                int n6 = n5++;
                menu.insert(menuItem, n6);
            }
        } else {
            for (int j = 0; j < n4; ++j) {
                MenuItem menuItem = menu.getItem(n2);
                menu.remove(n2);
                int n7 = n3 - 1;
                menu.insert(menuItem, n7);
            }
        }
    }

    public final void remove(int n2, int n3) {
        MenuItemApplier menuItemApplier = this;
        Menu menu = menuItemApplier.asMenu(menuItemApplier.getCurrent());
        if (n2 <= (n3 = n2 + n3 - 1)) {
            while (true) {
                menu.remove(n3);
                if (n3 == n2) break;
                --n3;
            }
        }
    }

    private final Menu asMenu(MenuItem menuItem) {
        if (menuItem instanceof Menu) {
            return (Menu)menuItem;
        }
        throw new IllegalStateException(("Can only insert MenuItem into Menu, not " + Reflection.getOrCreateKotlinClass(menuItem.getClass())).toString());
    }
}

