/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.compose.ui.graphics.BezierKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.PathIterator;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004*\u00020\u00022\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u001a\u0014\u0010\u0006\u001a\u00020\u0002*\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u001a\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"computeDirection", "Landroidx/compose/ui/graphics/Path$Direction;", "Landroidx/compose/ui/graphics/Path;", "divide", "", "contours", "reverse", "destination", "floatCountForType", "", "type", "Landroidx/compose/ui/graphics/PathSegment$Type;", "ui-graphics"})
public final class PathGeometryKt {
    public static final Path.Direction computeDirection(Path object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        boolean bl = true;
        object = object.iterator();
        float[] fArray = new float[8];
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        PathSegment.Type type = PathIterator.next$default((PathIterator)object, fArray, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!bl) break block9;
                    bl = false;
                    f2 = fArray[0];
                    f3 = fArray[1];
                    break;
                }
                case 2: {
                    float f6 = fArray[0];
                    f4 = fArray[1];
                    f5 = fArray[2];
                    float f7 = fArray[3];
                    f += BezierKt.cubicArea(f6, f4, f6, f4, f5, f7, f5, f7);
                    f4 = f5;
                    f5 = f7;
                    break;
                }
                case 3: {
                    float f8 = fArray[0];
                    f4 = fArray[1];
                    f5 = fArray[2];
                    float f7 = fArray[3];
                    float f9 = fArray[4];
                    float f10 = fArray[5];
                    float f11 = f8 + 0.6666667f * (f5 - f8);
                    float f12 = f4 + 0.6666667f * (f7 - f4);
                    f5 = f9 + 0.6666667f * (f5 - f9);
                    f7 = f10 + 0.6666667f * (f7 - f10);
                    f += BezierKt.cubicArea(f8, f4, f11, f12, f5, f7, f9, f10);
                    f4 = f9;
                    f5 = f10;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    f += BezierKt.cubicArea(fArray[0], fArray[1], fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    f4 = fArray[6];
                    f5 = fArray[7];
                    break;
                }
                case 6: {
                    float f13;
                    float f14 = f4;
                    if (Math.abs(f13 - f2) < 1.05E-6f) {
                        float f15;
                        f14 = f5;
                        if (Math.abs(f15 - f3) < 1.05E-6f) break;
                    }
                    f += BezierKt.cubicArea(f4, f5, f4, f5, f2, f3, f2, f3);
                    f4 = f2;
                    f5 = f3;
                    break;
                }
                case 7: {
                    break block9;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            type = PathIterator.next$default((PathIterator)object, fArray, 0, 2, null);
        }
        if (f >= 0.0f) {
            return Path.Direction.Clockwise;
        }
        return Path.Direction.CounterClockwise;
    }

    public static final List<Path> divide(Path object, List<Path> list) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter(list, (String)"");
        Path path = SkiaBackedPath_skikoKt.Path();
        boolean bl = true;
        boolean bl2 = true;
        object = object.iterator();
        float[] fArray = new float[8];
        PathSegment.Type type = PathIterator.next$default((PathIterator)object, fArray, 0, 2, null);
        block9: while (type != PathSegment.Type.Done) {
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    if (!bl && !bl2) {
                        list.add(path);
                        path = SkiaBackedPath_skikoKt.Path();
                    }
                    bl = false;
                    bl2 = true;
                    path.moveTo(fArray[0], fArray[1]);
                    break;
                }
                case 2: {
                    path.lineTo(fArray[2], fArray[3]);
                    bl2 = false;
                    break;
                }
                case 3: {
                    path.quadraticTo(fArray[2], fArray[3], fArray[4], fArray[5]);
                    bl2 = false;
                    break;
                }
                case 4: {
                    continue block9;
                }
                case 5: {
                    path.cubicTo(fArray[2], fArray[3], fArray[4], fArray[5], fArray[6], fArray[7]);
                    bl2 = false;
                    break;
                }
                case 6: {
                    path.close();
                    break;
                }
                case 7: {
                    continue block9;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            type = PathIterator.next$default((PathIterator)object, fArray, 0, 2, null);
        }
        if (!bl && !bl2) {
            list.add(path);
        }
        return list;
    }

    public static /* synthetic */ List divide$default(Path path, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = new ArrayList();
        }
        return PathGeometryKt.divide(path, list);
    }

    public static final Path reverse(Path object, Path path) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        object = object.iterator();
        int n = object.calculateSize(false);
        ArrayList<PathSegment.Type> arrayList = new ArrayList<PathSegment.Type>(n);
        ArrayList<float[]> arrayList2 = new ArrayList<float[]>(n);
        float[] fArray = new float[8];
        PathSegment.Type type = PathIterator.next$default((PathIterator)object, fArray, 0, 2, null);
        while (type != PathSegment.Type.Done) {
            arrayList.add(type);
            if (type != PathSegment.Type.Close) {
                float[] fArray2 = Arrays.copyOf(fArray, PathGeometryKt.floatCountForType(type));
                Intrinsics.checkNotNullExpressionValue((Object)fArray2, (String)"");
                arrayList2.add(fArray2);
            }
            type = PathIterator.next$default((PathIterator)object, fArray, 0, 2, null);
        }
        int n2 = 1;
        boolean bl = false;
        int n3 = arrayList2.size();
        block10: for (int i = arrayList.size() - 1; i >= 0; --i) {
            if (n2 != 0) {
                Object e = arrayList2.get(--n3);
                Intrinsics.checkNotNullExpressionValue(e, (String)"");
                fArray = (float[])e;
                n2 = ArraysKt.getLastIndex((float[])fArray);
                path.moveTo(fArray[n2 - 1], fArray[n2]);
                n2 = 0;
            } else {
                Object e = arrayList2.get(n3);
                Intrinsics.checkNotNullExpressionValue(e, (String)"");
                fArray = (float[])e;
            }
            switch (WhenMappings.$EnumSwitchMapping$0[((PathSegment.Type)((Object)arrayList.get(i))).ordinal()]) {
                case 1: {
                    if (bl) {
                        path.close();
                        bl = false;
                    }
                    n2 = 1;
                    continue block10;
                }
                case 2: {
                    path.lineTo(fArray[0], fArray[1]);
                    --n3;
                    continue block10;
                }
                case 3: {
                    path.quadraticTo(fArray[2], fArray[3], fArray[0], fArray[1]);
                    --n3;
                    continue block10;
                }
                case 4: {
                    continue block10;
                }
                case 5: {
                    path.cubicTo(fArray[4], fArray[5], fArray[2], fArray[3], fArray[0], fArray[1]);
                    --n3;
                    continue block10;
                }
                case 6: {
                    bl = true;
                    continue block10;
                }
                case 7: {
                    continue block10;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        if (bl) {
            path.close();
        }
        return path;
    }

    public static /* synthetic */ Path reverse$default(Path path, Path path2, int n, Object object) {
        if ((n & 1) != 0) {
            path2 = SkiaBackedPath_skikoKt.Path();
        }
        return PathGeometryKt.reverse(path, path2);
    }

    private static final int floatCountForType(PathSegment.Type type) {
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                return 2;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 6;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 0;
            }
            case 7: {
                return 0;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

