/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.shadow;

import androidx.compose.ui.geometry.CornerRadius;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.BrushKt;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.CanvasKt;
import androidx.compose.ui.graphics.ColorFilter;
import androidx.compose.ui.graphics.CompositeShaderBrush;
import androidx.compose.ui.graphics.ImageBitmap;
import androidx.compose.ui.graphics.ImageBitmapConfig;
import androidx.compose.ui.graphics.ImageBitmapKt;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.Paint;
import androidx.compose.ui.graphics.PaintingStyle;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.ShaderBrush;
import androidx.compose.ui.graphics.ShaderKt;
import androidx.compose.ui.graphics.SkiaBackedPaint_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.shadow.BlurKt;
import androidx.compose.ui.graphics.shadow.Blur_skikoKt;
import androidx.compose.ui.graphics.shadow.Shadow;
import androidx.compose.ui.graphics.shadow.ShadowRenderer;
import androidx.compose.ui.unit.DpOffset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skia.MaskFilter;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000f\u0010\u0011\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J-\u0010\u0014\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0014\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0018\u0010\u001f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!H\u0002JQ\u0010\"\u001a\u00020\u0015*\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010'\u001a\u00020(H\u0014\u00a2\u0006\u0004\b)\u0010*J?\u0010+\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$H\u0002\u00a2\u0006\u0004\b0\u00101J?\u00102\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010,\u001a\u00020$2\u0006\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b3\u00104R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u00065"}, d2={"Landroidx/compose/ui/graphics/shadow/InnerShadowRenderer;", "Landroidx/compose/ui/graphics/shadow/ShadowRenderer;", "shadow", "Landroidx/compose/ui/graphics/shadow/Shadow;", "outline", "Landroidx/compose/ui/graphics/Outline;", "<init>", "(Landroidx/compose/ui/graphics/shadow/Shadow;Landroidx/compose/ui/graphics/Outline;)V", "paint", "Landroidx/compose/ui/graphics/Paint;", "shadowMask", "Landroidx/compose/ui/graphics/ShaderBrush;", "compositeShader", "Landroidx/compose/ui/graphics/CompositeShaderBrush;", "matrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "obtainMatrix", "obtainMatrix-sQKQjiQ", "()[F", "buildShadow", "", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "size", "Landroidx/compose/ui/geometry/Size;", "cornerRadius", "Landroidx/compose/ui/geometry/CornerRadius;", "path", "Landroidx/compose/ui/graphics/Path;", "buildShadow-_SMYjrA", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;)V", "obtainCompositeBrush", "brush", "Landroidx/compose/ui/graphics/Brush;", "onDrawShadow", "alpha", "", "colorFilter", "Landroidx/compose/ui/graphics/ColorFilter;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "onDrawShadow-MLmccfk", "(Landroidx/compose/ui/graphics/drawscope/DrawScope;JJLandroidx/compose/ui/graphics/Path;FLandroidx/compose/ui/graphics/ColorFilter;Landroidx/compose/ui/graphics/Brush;I)V", "createInnerPathShadowBrush", "radius", "spread", "offsetX", "offsetY", "createInnerPathShadowBrush-LjSzlW0", "(JLandroidx/compose/ui/graphics/Path;FFFF)Landroidx/compose/ui/graphics/ShaderBrush;", "createInnerShadowBrush", "createInnerShadowBrush-u1Psq-8", "(JFFFFJ)Landroidx/compose/ui/graphics/ShaderBrush;", "ui-graphics"})
public final class InnerShadowRenderer
extends ShadowRenderer {
    private final Shadow shadow;
    private final Paint paint;
    private ShaderBrush shadowMask;
    private CompositeShaderBrush compositeShader;
    private float[] matrix;

    public InnerShadowRenderer(Shadow shadow, Outline outline) {
        Intrinsics.checkNotNullParameter((Object)shadow, (String)"");
        Intrinsics.checkNotNullParameter((Object)outline, (String)"");
        super(outline);
        this.shadow = shadow;
        this.paint = SkiaBackedPaint_skikoKt.Paint();
    }

    private final float[] obtainMatrix-sQKQjiQ() {
        float[] fArray = this.matrix;
        if (this.matrix == null) {
            float[] fArray2;
            float[] fArray3 = fArray2 = Matrix.constructor-impl$default(null, 1, null);
            this.matrix = fArray3;
            fArray = fArray2;
        }
        return fArray;
    }

    @Override
    protected final void buildShadow-_SMYjrA(DrawScope drawScope, long l2, long l3, Path path) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
        float f = drawScope.toPx-0680j_4(this.shadow.getRadius-D9Ej5fM());
        float f2 = drawScope.toPx-0680j_4(this.shadow.getSpread-D9Ej5fM());
        float f3 = drawScope.toPx-0680j_4(DpOffset.getX-D9Ej5fM((long)this.shadow.getOffset-RKDOV3M()));
        float f4 = drawScope.toPx-0680j_4(DpOffset.getY-D9Ej5fM((long)this.shadow.getOffset-RKDOV3M()));
        this.shadowMask = path != null ? this.createInnerPathShadowBrush-LjSzlW0(l2, path, f, f2, f3, f4) : this.createInnerShadowBrush-u1Psq-8(l2, f, f2, f3, f4, l3);
    }

    private final CompositeShaderBrush obtainCompositeBrush(ShaderBrush shaderBrush, Brush brush) {
        ShaderBrush shaderBrush2 = this.compositeShader;
        if (shaderBrush2 == null || !Intrinsics.areEqual((Object)shaderBrush2.getSrcBrush(), (Object)brush)) {
            shaderBrush = new CompositeShaderBrush(BrushKt.toShaderBrush(shaderBrush), BrushKt.toShaderBrush(brush), BlendMode.Companion.getSrcIn-0nO6VwU(), null);
            brush = shaderBrush;
            this.compositeShader = brush;
            shaderBrush2 = shaderBrush;
        }
        return shaderBrush2;
    }

    @Override
    protected final void onDrawShadow-MLmccfk(DrawScope drawScope, long l2, long l3, Path path, float f, ColorFilter colorFilter, Brush brush, int n) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
        ShaderBrush shaderBrush = this.shadowMask;
        if (shaderBrush != null) {
            ShaderBrush shaderBrush2 = shaderBrush;
            ShaderBrush shaderBrush3 = shaderBrush2 = this.shadow.getBrush() instanceof ShaderBrush ? (ShaderBrush)this.obtainCompositeBrush(shaderBrush2, this.shadow.getBrush()) : shaderBrush2;
            if (path != null) {
                DrawScope.drawPath-GBMwjPU$default(drawScope, path, shaderBrush2, f, null, colorFilter, n, 8, null);
            } else if (CornerRadius.equals-impl0((long)l3, (long)CornerRadius.Companion.getZero-kKHJgLs())) {
                DrawScope.drawRect-AsUm42w$default(drawScope, shaderBrush2, 0L, 0L, f, null, colorFilter, n, 22, null);
            } else {
                int n2 = this.shadow.getBlendMode-0nO6VwU();
                DrawScope.drawRoundRect-ZuiqVtQ$default(drawScope, shaderBrush2, 0L, 0L, l3, f, null, colorFilter, n2, 38, null);
                return;
            }
        }
    }

    private final ShaderBrush createInnerPathShadowBrush-LjSzlW0(long l2, Path path, float f, float f2, float f3, float f4) {
        Canvas canvas;
        Object object;
        int n = (int)(l2 >> 32);
        int n2 = (int)Math.ceil(Float.intBitsToFloat(n));
        n = (int)l2;
        int n3 = (int)Math.ceil(Float.intBitsToFloat(n));
        if (f2 > 0.0f) {
            Object object2;
            Rect rect = object2 = path.getBounds();
            float f5 = object2.getRight() - rect.getLeft();
            float f6 = object2.getBottom() - object2.getTop();
            object = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)Math.ceil(f5), (int)Math.ceil(f6), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
            Canvas canvas2 = CanvasKt.Canvas((ImageBitmap)object);
            object2 = canvas2;
            object2 = canvas2;
            canvas2.drawPath(path, this.paint);
            Canvas.clipRect-N_I0leg$default((Canvas)object2, 0.0f, 0.0f, f5, f6, 0, 16, null);
            Rect rect2 = object2;
            object2 = this.paint;
            int n4 = PaintingStyle.Companion.getStroke-TiuSbCo();
            int n5 = BlendMode.Companion.getClear-0nO6VwU();
            object2 = BlurKt.configureShadow-FoewPVk$default((Paint)object2, 0L, n5, null, n4, 5, null);
            Paint paint = object2;
            Path path2 = path;
            Rect rect3 = rect2;
            paint.setStrokeWidth(f2 * 2.0f);
            rect3.drawPath(path2, (Paint)object2);
        } else {
            object = null;
        }
        int n6 = (int)Math.ceil(f);
        ImageBitmap imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default(n2 + (n6 << 1), n3 + (n6 << 1), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas canvas3 = canvas = CanvasKt.Canvas(imageBitmap);
        if (object != null) {
            canvas3.drawRect(0.0f, 0.0f, imageBitmap.getWidth(), imageBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, null, 0, 15, null));
            Canvas canvas4 = canvas3;
            ImageBitmap imageBitmap2 = object;
            long l3 = Float.floatToRawIntBits(f3);
            long l4 = Float.floatToRawIntBits(f4);
            object = this.paint;
            canvas3 = f > 0.0f ? Blur_skikoKt.BlurFilter(f) : null;
            n3 = BlendMode.Companion.getXor-0nO6VwU();
            canvas4.drawImage-d-4ec7I(imageBitmap2, Offset.constructor-impl((long)(l3 << 32 | l4 & 0xFFFFFFFFL)), BlurKt.configureShadow-FoewPVk$default((Paint)object, 0L, n3, (MaskFilter)canvas3, 0, 9, null));
            return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(imageBitmap, 0, 0, 6, null));
        }
        canvas3.save();
        canvas3.translate(f3, f4);
        canvas3.drawPath(path, BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, f > 0.0f ? Blur_skikoKt.BlurFilter(f) : null, 0, 11, null));
        canvas3.restore();
        canvas3.drawRect(0.0f, 0.0f, imageBitmap.getWidth(), imageBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, BlendMode.Companion.getXor-0nO6VwU(), null, 0, 13, null));
        return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(imageBitmap, 0, 0, 6, null));
    }

    private final ShaderBrush createInnerShadowBrush-u1Psq-8(long l2, float f, float f2, float f3, float f4, long l3) {
        int n = (int)(l2 >> 32);
        int n2 = n;
        n2 = (int)l2;
        ImageBitmap imageBitmap = ImageBitmapKt.ImageBitmap-x__-hDU$default((int)Math.ceil(Float.intBitsToFloat(n)), (int)Math.ceil(Float.intBitsToFloat(n2)), ImageBitmapConfig.Companion.getAlpha8-_sVssgQ(), false, null, 24, null);
        Canvas canvas = CanvasKt.Canvas(imageBitmap);
        float f5 = f3 + f2;
        float f6 = f4 + f2;
        long l4 = l2;
        int n3 = (int)(l2 >> 32);
        float f7 = f3 + Float.intBitsToFloat(n3) - f2;
        float f8 = Math.max(f5, f7);
        int n4 = (int)l4;
        float f9 = f4 + Float.intBitsToFloat(n4) - f2;
        f9 = Math.max(f6, f9);
        int n5 = (int)(l3 >> 32);
        float f10 = Float.intBitsToFloat(n5);
        n5 = (int)l3;
        canvas.drawRoundRect(f5, f6, f8, f9, f10, Float.intBitsToFloat(n5), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, 0, f > 0.0f ? Blur_skikoKt.BlurFilter(f) : null, 0, 11, null));
        canvas.drawRect(0.0f, 0.0f, imageBitmap.getWidth(), imageBitmap.getHeight(), BlurKt.configureShadow-FoewPVk$default(this.paint, 0L, BlendMode.Companion.getXor-0nO6VwU(), null, 0, 13, null));
        return BrushKt.ShaderBrush(ShaderKt.ImageShader-F49vj9s$default(imageBitmap, 0, 0, 6, null));
    }
}

