/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.context;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.Logger;
import org.jetbrains.skiko.MetalAdapter;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.SkiaLayer;
import org.jetbrains.skiko.SkikoLoggerInterface;
import org.jetbrains.skiko.context.ContextHandler;
import org.jetbrains.skiko.context.JvmContextHandler;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0011\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\fH\u0082 J\b\u0010\r\u001a\u00020\u000bH\u0014J\b\u0010\u000e\u001a\u00020\u000bH\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u0011\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\fH\u0082 J!\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0082 J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00a2\u0006\u0004\n\u0002\u0010\t\u0082\u0002\u000b\n\u0005\b\u00a1\u001e0\u0001\n\u0002\b!\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/skiko/context/MetalContextHandler;", "Lorg/jetbrains/skiko/context/JvmContextHandler;", "layer", "Lorg/jetbrains/skiko/SkiaLayer;", "device", "Lorg/jetbrains/skiko/redrawer/MetalDevice;", "adapter", "Lorg/jetbrains/skiko/MetalAdapter;", "(Lorg/jetbrains/skiko/SkiaLayer;JLorg/jetbrains/skiko/MetalAdapter;Lkotlin/jvm/internal/DefaultConstructorMarker;)V", "J", "finishFrame", "", "", "flush", "initCanvas", "initContext", "", "makeContext", "Lorg/jetbrains/skia/DirectContext;", "makeMetalContext", "makeMetalRenderTarget", "width", "", "height", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "rendererInfo", "", "skiko"})
public final class MetalContextHandler
extends JvmContextHandler {
    private final long device;
    private final MetalAdapter adapter;

    private MetalContextHandler(SkiaLayer skiaLayer, long l, MetalAdapter metalAdapter) {
        Intrinsics.checkNotNullParameter((Object)skiaLayer, (String)"");
        Intrinsics.checkNotNullParameter((Object)metalAdapter, (String)"");
        super(skiaLayer);
        this.device = l;
        this.adapter = metalAdapter;
    }

    @Override
    protected final boolean initContext() {
        try {
            if (this.getContext() == null) {
                Object object;
                MetalContextHandler metalContextHandler = this;
                metalContextHandler.setContext(metalContextHandler.makeContext());
                if (Intrinsics.areEqual((Object)System.getProperty("skiko.hardwareInfo.enabled"), (Object)"true") && ((Logger)(object = Logger.INSTANCE)).getLoggerImpl().isInfoEnabled()) {
                    object = ((Logger)object).getLoggerImpl();
                    object.info("Renderer info:\n " + ((ContextHandler)this).rendererInfo());
                }
            }
        }
        catch (Exception exception) {
            Object object = Logger.INSTANCE;
            if (((Logger)object).getLoggerImpl().isWarnEnabled()) {
                SkikoLoggerInterface skikoLoggerInterface = ((Logger)object).getLoggerImpl();
                object = exception;
                SkikoLoggerInterface skikoLoggerInterface2 = skikoLoggerInterface;
                String string = "Failed to create Skia Metal context!";
                skikoLoggerInterface2.warn((Throwable)object, string);
            }
            return false;
        }
        return true;
    }

    @Override
    protected final void initCanvas() {
        this.disposeCanvas();
        float f = this.getLayer().getContentScale();
        int n = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getWidth() * f)), (int)0);
        int n2 = RangesKt.coerceAtLeast((int)((int)((float)this.getLayer().getBackedLayer$skiko().getHeight() * f)), (int)0);
        if (n > 0 && n2 > 0) {
            MetalContextHandler metalContextHandler = this;
            metalContextHandler.setRenderTarget(metalContextHandler.makeRenderTarget(n, n2));
            DirectContext directContext = this.getContext();
            Intrinsics.checkNotNull((Object)directContext);
            BackendRenderTarget backendRenderTarget = this.getRenderTarget();
            Intrinsics.checkNotNull((Object)backendRenderTarget);
            Surface surface = Surface.Companion.makeFromBackendRenderTarget(directContext, backendRenderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, this.getLayer().getPixelGeometry(), 1, null));
            if (surface == null) {
                throw new RenderException("Cannot create surface", null, 2, null);
            }
            this.setSurface(surface);
            MetalContextHandler metalContextHandler2 = this;
            Surface surface2 = metalContextHandler2.getSurface();
            Intrinsics.checkNotNull((Object)surface2);
            metalContextHandler2.setCanvas(surface2.getCanvas());
            return;
        }
        this.setRenderTarget(null);
        this.setSurface(null);
        this.setCanvas(null);
    }

    @Override
    protected final void flush() {
        super.flush();
        Surface surface = this.getSurface();
        if (surface != null) {
            surface.flushAndSubmit();
        }
        this.finishFrame();
    }

    @Override
    public final String rendererInfo() {
        return super.rendererInfo() + "Video card: " + this.adapter.getName() + "\nTotal VRAM: " + this.adapter.getMemorySize() / 1024L / 1024L + " MB\n";
    }

    private final BackendRenderTarget makeRenderTarget(int n, int n2) {
        MetalContextHandler metalContextHandler = this;
        return new BackendRenderTarget(metalContextHandler.makeMetalRenderTarget(metalContextHandler.device, n, n2));
    }

    private final DirectContext makeContext() {
        MetalContextHandler metalContextHandler = this;
        return new DirectContext(metalContextHandler.makeMetalContext(metalContextHandler.device));
    }

    private final void finishFrame() {
        MetalContextHandler metalContextHandler = this;
        metalContextHandler.finishFrame(metalContextHandler.device);
    }

    private final native long makeMetalContext(long var1);

    private final native long makeMetalRenderTarget(long var1, int var3, int var4);

    private final native void finishFrame(long var1);

    public /* synthetic */ MetalContextHandler(SkiaLayer skiaLayer, long l, MetalAdapter metalAdapter, DefaultConstructorMarker defaultConstructorMarker) {
        this(skiaLayer, l, metalAdapter);
    }
}

