/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.skia.Bitmap;
import org.jetbrains.skia.ColorAlphaType;
import org.jetbrains.skia.ImageInfo;
import org.jetbrains.skia.Pixmap;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.impl.BufferUtil;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingLayerPropertiesKt;
import org.jetbrains.skiko.swing.SwingPainter;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0080\u0001\u0010\u0011\u001a\u00020\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\b\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020'H\u0002Jv\u0010(\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020\r2\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'2\u0006\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010)\u001a\u0004\u0018\u00010\u001d2\b\u0010$\u001a\u0004\u0018\u00010%H\u0002Jd\u0010*\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010+\u001a\u00020\r2\b\b\u0002\u0010,\u001a\u00020\r2\b\b\u0002\u0010\u001a\u001a\u00020\r2\b\b\u0002\u0010\u001b\u001a\u00020\r2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u00132\n\b\u0002\u0010$\u001a\u0004\u0018\u00010%H\u0002J \u0010-\u001a\u00020\u00102\u0006\u0010 \u001a\u00020\u00172\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000bH\u0016J\u0018\u00101\u001a\u00020\r2\u0006\u00102\u001a\u00020\r2\u0006\u0010&\u001a\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/skiko/swing/SoftwareSwingPainter;", "Lorg/jetbrains/skiko/swing/SwingPainter;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;)V", "bitmap", "Lorg/jetbrains/skia/Bitmap;", "bufferedImage", "Ljava/awt/image/BufferedImage;", "createImageFromBytes", "pBytes", "", "width", "", "height", "dispose", "", "doDraw", "op", "Ljava/awt/image/BufferedImageOp;", "image", "Ljava/awt/Image;", "invG", "Ljava/awt/Graphics2D;", "hasDestinationSize", "", "dw", "dh", "sourceBounds", "Ljava/awt/Rectangle;", "userWidth", "userHeight", "g", "Ljava/awt/Graphics;", "dx", "dy", "observer", "Ljava/awt/image/ImageObserver;", "scale", "", "doDrawHiDpi", "srcBounds", "drawImage", "x", "y", "paint", "surface", "Lorg/jetbrains/skia/Surface;", "texture", "scaleSize", "size", "skiko"})
public final class SoftwareSwingPainter
implements SwingPainter {
    private final SwingLayerProperties swingLayerProperties;
    private BufferedImage bufferedImage;
    private Bitmap bitmap;

    public SoftwareSwingPainter(SwingLayerProperties swingLayerProperties2) {
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"");
        this.swingLayerProperties = swingLayerProperties2;
        this.bufferedImage = new BufferedImage(1, 1, 3);
        this.bitmap = new Bitmap();
    }

    @Override
    public final void paint(Graphics2D graphics2D, Surface surface, long l) {
        Intrinsics.checkNotNullParameter((Object)graphics2D, (String)"");
        Intrinsics.checkNotNullParameter((Object)surface, (String)"");
        int n = surface.getWidth();
        int n2 = surface.getHeight();
        if (this.bitmap.getWidth() != n || this.bitmap.getHeight() != n2) {
            this.bitmap.allocPixelsFlags(ImageInfo.Companion.makeS32(n, n2, ColorAlphaType.PREMUL), false);
        }
        surface.readPixels(this.bitmap, 0, 0);
        Pixmap pixmap = this.bitmap.peekPixels();
        if (pixmap == null) {
            throw new RenderException("Can't get pixels address", null, 2, null);
        }
        long l2 = pixmap.getAddr();
        this.bufferedImage = this.createImageFromBytes(l2, n, n2);
        SoftwareSwingPainter.drawImage$default(this, graphics2D, this.bufferedImage, 0, 0, 0, 0, null, null, null, 508, null);
    }

    @Override
    public final void dispose() {
        this.bitmap.close();
    }

    private final BufferedImage createImageFromBytes(long l, int n, int n2) {
        if (this.bufferedImage.getWidth() != n || this.bufferedImage.getHeight() != n2) {
            this.bufferedImage = new BufferedImage(n, n2, 3);
        }
        BufferedImage bufferedImage = this.bufferedImage;
        DataBuffer dataBuffer = bufferedImage.getRaster().getDataBuffer();
        Intrinsics.checkNotNull((Object)dataBuffer);
        int[] nArray = ((DataBufferInt)dataBuffer).getData();
        Buffer buffer = BufferUtil.INSTANCE.getByteBufferFromPointer(l, n * n2 << 2);
        IntBuffer intBuffer = ((ByteBuffer)buffer).order(ByteOrder.LITTLE_ENDIAN).asIntBuffer();
        Intrinsics.checkNotNullExpressionValue((Object)intBuffer, (String)"");
        buffer = intBuffer;
        intBuffer.position(0).get(nArray, 0, Math.min(bufferedImage.getHeight() * bufferedImage.getWidth(), buffer.capacity()));
        return bufferedImage;
    }

    private final void drawImage(Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver) {
        boolean bl = n3 >= 0 && n4 >= 0;
        SoftwareSwingPainter softwareSwingPainter = this;
        softwareSwingPainter.doDrawHiDpi(softwareSwingPainter.swingLayerProperties.getWidth(), this.swingLayerProperties.getHeight(), graphics, SwingLayerPropertiesKt.getScale(this.swingLayerProperties), n, n2, n3, n4, bl, bufferedImageOp, image, rectangle, imageObserver);
    }

    static /* synthetic */ void drawImage$default(SoftwareSwingPainter softwareSwingPainter, Graphics graphics, Image image, int n, int n2, int n3, int n4, Rectangle rectangle, BufferedImageOp bufferedImageOp, ImageObserver imageObserver, int n5, Object object) {
        if ((n5 & 4) != 0) {
            n = 0;
        }
        if ((n5 & 8) != 0) {
            n2 = 0;
        }
        if ((n5 & 0x10) != 0) {
            n3 = -1;
        }
        if ((n5 & 0x20) != 0) {
            n4 = -1;
        }
        if ((n5 & 0x40) != 0) {
            rectangle = null;
        }
        if ((n5 & 0x80) != 0) {
            bufferedImageOp = null;
        }
        if ((n5 & 0x100) != 0) {
            imageObserver = null;
        }
        softwareSwingPainter.drawImage(graphics, image, n, n2, n3, n4, rectangle, bufferedImageOp, imageObserver);
    }

    private final void doDrawHiDpi(int n, int n2, Graphics graphics, double d2, int n3, int n4, int n5, int n6, boolean bl, BufferedImageOp bufferedImageOp, Image image, Rectangle rectangle, ImageObserver imageObserver) {
        Graphics graphics2;
        double d3;
        double d4 = d2;
        int n7 = n3;
        int n8 = n4;
        double d5 = 0.0;
        int n9 = Math.max(n, n2);
        if (n9 < 0x3FFFFFFF) {
            double d6;
            int n10 = 1;
            while (true) {
                double d7 = d3 = Math.pow(10.0, n10);
                double d8 = n9;
                d6 = d7;
                if (!(d8 > d3)) break;
                ++n10;
            }
            d5 = 1.0 / d6;
        }
        Graphics graphics3 = graphics;
        Intrinsics.checkNotNull((Object)graphics3);
        AffineTransform affineTransform = ((Graphics2D)graphics3).getTransform();
        Graphics graphics4 = null;
        if ((affineTransform.getType() & 0x18) == 0 && Math.abs(d2 - affineTransform.getScaleX()) <= d5) {
            d4 = affineTransform.getScaleX();
            d3 = affineTransform.getScaleX();
            double d9 = affineTransform.getScaleY();
            affineTransform.scale(1.0 / d3, 1.0 / d9);
            affineTransform.translate((double)n3 * d3, (double)n4 * d9);
            n8 = 0;
            n7 = 0;
            Graphics graphics5 = graphics.create();
            Intrinsics.checkNotNull((Object)graphics5);
            graphics4 = (Graphics2D)graphics5;
            graphics = graphics4;
            ((Graphics2D)graphics4).setTransform(affineTransform);
        }
        try {
            int n11 = n5;
            int n12 = n6;
            if (graphics4 != null && bl) {
                n11 = this.scaleSize(n5, d4);
                n12 = this.scaleSize(n6, d4);
            }
            this.doDraw(bufferedImageOp, image, (Graphics2D)graphics4, bl, n11, n12, rectangle, n, n2, graphics, n7, n8, imageObserver, d4);
            graphics2 = graphics4;
        }
        catch (Throwable throwable) {
            Graphics graphics6 = graphics4;
            if (graphics6 != null) {
                graphics6.dispose();
            }
            throw throwable;
        }
        if (graphics2 == null) {
            return;
        }
        graphics2.dispose();
    }

    private final int scaleSize(int n, double d2) {
        return MathKt.roundToInt((double)((double)n * d2));
    }

    private final void doDraw(BufferedImageOp bufferedImageOp, Image image, Graphics2D graphics2D, boolean bl, int n, int n2, Rectangle rectangle, int n3, int n4, Graphics graphics, int n5, int n6, ImageObserver imageObserver, double d2) {
        if (bufferedImageOp != null && image instanceof BufferedImage) {
            BufferedImage bufferedImage = bufferedImageOp.filter((BufferedImage)image, null);
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"");
            image = bufferedImage;
        }
        if (rectangle != null) {
            int n7;
            int n8 = SoftwareSwingPainter.doDraw$size(this, d2, rectangle.x);
            int n9 = SoftwareSwingPainter.doDraw$size(this, d2, rectangle.y);
            int n10 = rectangle.width >= 0 ? SoftwareSwingPainter.doDraw$size(this, d2, rectangle.width) : SoftwareSwingPainter.doDraw$size(this, d2, n3) - n8;
            int n11 = n7 = rectangle.height >= 0 ? SoftwareSwingPainter.doDraw$size(this, d2, rectangle.height) : SoftwareSwingPainter.doDraw$size(this, d2, n4) - n9;
            if (!bl) {
                n = SoftwareSwingPainter.doDraw$size(this, d2, n3);
                n2 = SoftwareSwingPainter.doDraw$size(this, d2, n4);
            }
            graphics.drawImage(image, n5, n6, n5 + n, n6 + n2, n8, n9, n8 + n10, n9 + n7, imageObserver);
            return;
        }
        if (bl) {
            graphics.drawImage(image, n5, n6, n, n2, imageObserver);
            return;
        }
        if (graphics2D == null) {
            graphics.drawImage(image, n5, n6, n3, n4, imageObserver);
            return;
        }
        graphics.drawImage(image, n5, n6, imageObserver);
    }

    private static final int doDraw$size(SoftwareSwingPainter softwareSwingPainter, double d2, int n) {
        return softwareSwingPainter.scaleSize(n, d2);
    }
}

