/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.DispatchListener;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.annotation.ComEventCallback;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CallbackProxy
implements IDispatchCallback {
    private static boolean DEFAULT_BOOLEAN;
    private static byte DEFAULT_BYTE;
    private static short DEFAULT_SHORT;
    private static int DEFAULT_INT;
    private static long DEFAULT_LONG;
    private static float DEFAULT_FLOAT;
    private static double DEFAULT_DOUBLE;
    ObjectFactory factory;
    Class<?> comEventCallbackInterface;
    IComEventCallbackListener comEventCallbackListener;
    Guid.REFIID listenedToRiid;
    public DispatchListener dispatchListener;
    Map<OaIdl.DISPID, Method> dsipIdMap;

    public CallbackProxy(ObjectFactory objectFactory, Class<?> clazz, IComEventCallbackListener iComEventCallbackListener) {
        this.factory = objectFactory;
        this.comEventCallbackInterface = clazz;
        this.comEventCallbackListener = iComEventCallbackListener;
        this.listenedToRiid = this.createRIID(clazz);
        this.dsipIdMap = this.createDispIdMap(clazz);
        this.dispatchListener = new DispatchListener(this);
    }

    private Guid.REFIID createRIID(Class<?> object) {
        if ((object = ((Class)object).getAnnotation(ComInterface.class)) == null) {
            throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
        }
        if ((object = object.iid()) == null || ((String)object).isEmpty()) {
            throw new COMException("ComInterface must define a value for iid");
        }
        return new Guid.REFIID(new Guid.IID((String)object).getPointer());
    }

    private Map<OaIdl.DISPID, Method> createDispIdMap(Class<?> methodArray) {
        HashMap<OaIdl.DISPID, Method> hashMap = new HashMap<OaIdl.DISPID, Method>();
        for (Method method : methodArray.getMethods()) {
            ComEventCallback comEventCallback = method.getAnnotation(ComEventCallback.class);
            ComMethod comMethod = method.getAnnotation(ComMethod.class);
            if (comMethod != null) {
                int n = comMethod.dispId();
                if (-1 == n) {
                    n = this.fetchDispIdFromName(comEventCallback);
                }
                if (n == -1) {
                    this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + method.getName() + " not found", null);
                }
                hashMap.put(new OaIdl.DISPID(n), method);
                continue;
            }
            if (comEventCallback == null) continue;
            int n = comEventCallback.dispid();
            if (-1 == n) {
                n = this.fetchDispIdFromName(comEventCallback);
            }
            if (n == -1) {
                this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + method.getName() + " not found", null);
            }
            hashMap.put(new OaIdl.DISPID(n), method);
        }
        return hashMap;
    }

    private int fetchDispIdFromName(ComEventCallback comEventCallback) {
        return -1;
    }

    void invokeOnThread(OaIdl.DISPID dISPIDArray, Guid.REFIID object, WinDef.LCID object2, WinDef.WORD classArray, OleAuto.DISPPARAMS.ByReference objectArray) {
        Object[] objectArray2;
        int n;
        object = objectArray.getArgs();
        object2 = this.dsipIdMap.get(dISPIDArray);
        if (object2 == null) {
            this.comEventCallbackListener.errorReceivingCallbackEvent("No method found with dispId = " + dISPIDArray, null);
            return;
        }
        dISPIDArray = objectArray.getRgdispidNamedArgs();
        classArray = ((Method)object2).getParameterTypes();
        objectArray = new Object[classArray.length];
        for (n = 0; n < objectArray.length && ((Variant.VARIANT[])object).length - dISPIDArray.length - n > 0; ++n) {
            Class<?> clazz = classArray[n];
            objectArray2 = object[((Variant.VARIANT[])object).length - n - 1];
            objectArray[n] = Convert.toJavaObject(objectArray2, clazz, this.factory, true, false);
        }
        for (n = 0; n < dISPIDArray.length; ++n) {
            int n2 = dISPIDArray[n].intValue();
            if (n2 >= objectArray.length) continue;
            objectArray2 = classArray[n2];
            Variant.VARIANT vARIANT = object[n];
            objectArray[n2] = Convert.toJavaObject(vARIANT, objectArray2, this.factory, true, false);
        }
        for (n = 0; n < objectArray.length; ++n) {
            if (objectArray[n] != null || !classArray[n].isPrimitive()) continue;
            if (classArray[n].equals(Boolean.TYPE)) {
                objectArray[n] = DEFAULT_BOOLEAN;
                continue;
            }
            if (classArray[n].equals(Byte.TYPE)) {
                objectArray[n] = DEFAULT_BYTE;
                continue;
            }
            if (classArray[n].equals(Short.TYPE)) {
                objectArray[n] = DEFAULT_SHORT;
                continue;
            }
            if (classArray[n].equals(Integer.TYPE)) {
                objectArray[n] = DEFAULT_INT;
                continue;
            }
            if (classArray[n].equals(Long.TYPE)) {
                objectArray[n] = DEFAULT_LONG;
                continue;
            }
            if (classArray[n].equals(Float.TYPE)) {
                objectArray[n] = Float.valueOf(DEFAULT_FLOAT);
                continue;
            }
            if (classArray[n].equals(Double.TYPE)) {
                objectArray[n] = DEFAULT_DOUBLE;
                continue;
            }
            throw new IllegalArgumentException("Class type " + classArray[n].getName() + " not mapped to primitive default value.");
        }
        try {
            ((Method)object2).invoke((Object)this.comEventCallbackListener, objectArray);
            return;
        }
        catch (Exception exception) {
            ArrayList<String> arrayList = new ArrayList<String>(objectArray.length);
            objectArray2 = objectArray;
            int n3 = objectArray.length;
            for (int i = 0; i < n3; ++i) {
                object = objectArray2[i];
                if (object == null) {
                    arrayList.add("NULL");
                    continue;
                }
                arrayList.add(object.getClass().getName());
            }
            this.comEventCallbackListener.errorReceivingCallbackEvent("Exception invoking method " + object2 + " supplied: " + ((Object)arrayList).toString(), exception);
            return;
        }
    }

    @Override
    public Pointer getPointer() {
        return this.dispatchListener.getPointer();
    }

    @Override
    public WinNT.HRESULT GetTypeInfoCount(WinDef.UINTByReference uINTByReference) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT GetTypeInfo(WinDef.UINT uINT, WinDef.LCID lCID, PointerByReference pointerByReference) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT GetIDsOfNames(Guid.REFIID rEFIID, WString[] wStringArray, int n, WinDef.LCID lCID, OaIdl.DISPIDByReference dISPIDByReference) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT Invoke(OaIdl.DISPID dISPID, Guid.REFIID rEFIID, WinDef.LCID lCID, WinDef.WORD wORD, OleAuto.DISPPARAMS.ByReference byReference, Variant.VARIANT.ByReference byReference2, OaIdl.EXCEPINFO.ByReference byReference3, IntByReference intByReference) {
        assert (COMUtils.comIsInitialized()) : "Assumption about COM threading broken.";
        this.invokeOnThread(dISPID, rEFIID, lCID, wORD, byReference);
        return WinError.S_OK;
    }

    @Override
    public WinNT.HRESULT QueryInterface(Guid.REFIID rEFIID, PointerByReference pointerByReference) {
        if (pointerByReference == null) {
            return new WinNT.HRESULT(-2147467261);
        }
        if (rEFIID.equals((Object)this.listenedToRiid)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (rEFIID.getValue().equals((Object)Unknown.IID_IUNKNOWN)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (rEFIID.getValue().equals((Object)Dispatch.IID_IDISPATCH)) {
            pointerByReference.setValue(this.getPointer());
            return WinError.S_OK;
        }
        return new WinNT.HRESULT(-2147467262);
    }

    @Override
    public int AddRef() {
        return 0;
    }

    @Override
    public int Release() {
        return 0;
    }
}

