/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.JdkAlpnSslUtils;
import io.netty.handler.ssl.SslUtils;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;

final class BouncyCastleAlpnSslUtils {
    private static final InternalLogger logger;
    private static final Method SET_PARAMETERS;
    private static final Method GET_PARAMETERS;
    private static final Method SET_APPLICATION_PROTOCOLS;
    private static final Method GET_APPLICATION_PROTOCOL;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL;
    private static final Method SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR;
    private static final Class BC_APPLICATION_PROTOCOL_SELECTOR;
    private static final Method BC_APPLICATION_PROTOCOL_SELECTOR_SELECT;

    private BouncyCastleAlpnSslUtils() {
    }

    static String getApplicationProtocol(SSLEngine object) {
        try {
            return (String)GET_APPLICATION_PROTOCOL.invoke(object, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setApplicationProtocols(SSLEngine sSLEngine, List<String> list) {
        String[] stringArray = list.toArray(EmptyArrays.EMPTY_STRINGS);
        try {
            Object object = GET_PARAMETERS.invoke((Object)sSLEngine, new Object[0]);
            SET_APPLICATION_PROTOCOLS.invoke(object, new Object[]{stringArray});
            SET_PARAMETERS.invoke((Object)sSLEngine, object);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            UnsupportedOperationException unsupportedOperationException2 = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
        if (PlatformDependent.javaVersion() >= 9) {
            JdkAlpnSslUtils.setApplicationProtocols(sSLEngine, list);
        }
    }

    static String getHandshakeApplicationProtocol(SSLEngine object) {
        try {
            return (String)GET_HANDSHAKE_APPLICATION_PROTOCOL.invoke(object, new Object[0]);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static void setHandshakeApplicationProtocolSelector(SSLEngine sSLEngine, BiFunction<SSLEngine, List<String>, String> object) {
        try {
            object = Proxy.newProxyInstance(BouncyCastleAlpnSslUtils.class.getClassLoader(), new Class[]{BC_APPLICATION_PROTOCOL_SELECTOR}, new InvocationHandler((BiFunction)object){
                final /* synthetic */ BiFunction val$selector;
                {
                    this.val$selector = biFunction;
                }

                @Override
                public final Object invoke(Object object, Method method, Object[] objectArray) {
                    if (method.getName().equals("select")) {
                        try {
                            return this.val$selector.apply((SSLEngine)objectArray[0], (List)objectArray[1]);
                        }
                        catch (ClassCastException classCastException) {
                            throw new RuntimeException("BCApplicationProtocolSelector select method parameter of invalid type.", classCastException);
                        }
                    }
                    throw new UnsupportedOperationException(String.format("Method '%s' not supported.", method.getName()));
                }
            });
            SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke((Object)sSLEngine, object);
            return;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static BiFunction<SSLEngine, List<String>, String> getHandshakeApplicationProtocolSelector(final SSLEngine object) {
        try {
            object = GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR.invoke(object, new Object[0]);
            return new BiFunction<SSLEngine, List<String>, String>(){

                @Override
                public final String apply(SSLEngine sSLEngine, List<String> list) {
                    try {
                        return (String)BC_APPLICATION_PROTOCOL_SELECTOR_SELECT.invoke(object, sSLEngine, list);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException("Could not call getHandshakeApplicationProtocolSelector", exception);
                    }
                }
            };
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            object = unsupportedOperationException;
            throw unsupportedOperationException;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    static {
        Method method;
        Method method2;
        GenericDeclaration genericDeclaration;
        Object object;
        Method method3;
        GenericDeclaration genericDeclaration2;
        Class<?> clazz;
        GenericDeclaration genericDeclaration3;
        Object object2;
        logger = InternalLoggerFactory.getInstance(BouncyCastleAlpnSslUtils.class);
        try {
            object2 = Class.forName("org.bouncycastle.jsse.BCSSLEngine");
            genericDeclaration3 = object2;
            genericDeclaration2 = clazz = Class.forName("org.bouncycastle.jsse.BCApplicationProtocolSelector");
            method3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration2.getMethod("select", Object.class, List.class);
                }
            });
            object2 = SslUtils.getSSLContext("BCJSSE");
            SSLEngine sSLEngine = ((SSLContext)object2).createSSLEngine();
            object2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration3.getMethod("getParameters", new Class[0]);
                }
            });
            object = ((Method)object2).invoke((Object)sSLEngine, new Object[0]);
            genericDeclaration = object.getClass();
            method2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration3.getMethod("setParameters", genericDeclaration);
                }
            });
            method2.invoke((Object)sSLEngine, object);
            genericDeclaration = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration.getMethod("setApplicationProtocols", String[].class);
                }
            });
            ((Method)genericDeclaration).invoke(object, new Object[]{EmptyArrays.EMPTY_STRINGS});
            object = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration3.getMethod("getApplicationProtocol", new Class[0]);
                }
            });
            ((Method)object).invoke((Object)sSLEngine, new Object[0]);
            method = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration3.getMethod("getHandshakeApplicationProtocol", new Class[0]);
                }
            });
            method.invoke((Object)sSLEngine, new Object[0]);
            genericDeclaration2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration3.getMethod("setBCHandshakeApplicationProtocolSelector", genericDeclaration2);
                }
            });
            genericDeclaration3 = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                @Override
                public final Method run() {
                    return genericDeclaration3.getMethod("getBCHandshakeApplicationProtocolSelector", new Class[0]);
                }
            });
            ((Method)genericDeclaration3).invoke(sSLEngine, new Object[0]);
        }
        catch (Throwable throwable) {
            logger.error("Unable to initialize BouncyCastleAlpnSslUtils.", throwable);
            method2 = null;
            object2 = null;
            genericDeclaration = null;
            object = null;
            method = null;
            genericDeclaration2 = null;
            genericDeclaration3 = null;
            method3 = null;
            clazz = null;
        }
        SET_PARAMETERS = method2;
        GET_PARAMETERS = object2;
        SET_APPLICATION_PROTOCOLS = genericDeclaration;
        GET_APPLICATION_PROTOCOL = object;
        GET_HANDSHAKE_APPLICATION_PROTOCOL = method;
        SET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = genericDeclaration2;
        GET_HANDSHAKE_APPLICATION_PROTOCOL_SELECTOR = genericDeclaration3;
        BC_APPLICATION_PROTOCOL_SELECTOR_SELECT = method3;
        BC_APPLICATION_PROTOCOL_SELECTOR = clazz;
    }
}

