/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.ssl.OpenSslKeyMaterial;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.X509KeyManager;

final class OpenSslCachingKeyMaterialProvider
extends OpenSslKeyMaterialProvider {
    private final int maxCachedEntries;
    private volatile boolean full;
    private final ConcurrentMap<String, OpenSslKeyMaterial> cache = new ConcurrentHashMap<String, OpenSslKeyMaterial>();

    OpenSslCachingKeyMaterialProvider(X509KeyManager x509KeyManager, String string, int n) {
        super(x509KeyManager, string);
        this.maxCachedEntries = n;
    }

    @Override
    final OpenSslKeyMaterial chooseKeyMaterial(ByteBufAllocator object, String string) {
        OpenSslKeyMaterial openSslKeyMaterial = (OpenSslKeyMaterial)this.cache.get(string);
        if (openSslKeyMaterial == null) {
            openSslKeyMaterial = super.chooseKeyMaterial((ByteBufAllocator)object, string);
            if (openSslKeyMaterial == null) {
                return null;
            }
            if (this.full) {
                return openSslKeyMaterial;
            }
            if (this.cache.size() > this.maxCachedEntries) {
                this.full = true;
                return openSslKeyMaterial;
            }
            object = this.cache.putIfAbsent(string, openSslKeyMaterial);
            if (object != null) {
                openSslKeyMaterial.release();
                openSslKeyMaterial = object;
            }
        }
        return openSslKeyMaterial.retain();
    }

    @Override
    final void destroy() {
        do {
            Iterator iterator = this.cache.values().iterator();
            while (iterator.hasNext()) {
                ((OpenSslKeyMaterial)iterator.next()).release();
                iterator.remove();
            }
        } while (!this.cache.isEmpty());
    }
}

