/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.OpenSslApplicationProtocolNegotiator;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslKeyMaterialProvider;
import io.netty.handler.ssl.OpenSslServerSessionContext;
import io.netty.handler.ssl.ReferenceCountedOpenSslServerContext;
import io.netty.handler.ssl.ResumptionController;
import io.netty.handler.ssl.SslContextOption;
import java.io.File;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;

public final class OpenSslServerContext
extends OpenSslContext {
    private final OpenSslServerSessionContext sessionContext;

    @Deprecated
    public OpenSslServerContext(File file, File file2) {
        this(file, file2, null);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string) {
        this(file, file2, string, null, IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, 0L, 0L);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, Iterable<String> iterable, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) {
        this(file, file2, string, iterable, IdentityCipherSuiteFilter.INSTANCE, applicationProtocolConfig, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, Iterable<String> iterable, Iterable<String> iterable2, long l, long l2) {
        this(file, file2, string, iterable, OpenSslServerContext.toApplicationProtocolConfig(iterable2), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) {
        this(file, file2, string, trustManagerFactory, iterable, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2) {
        this(null, trustManagerFactory, file, file2, string, null, iterable, null, openSslApplicationProtocolNegotiator, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) {
        this(null, null, file, file2, string, null, iterable, cipherSuiteFilter, applicationProtocolConfig, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) {
        this(file, trustManagerFactory, file2, file3, string, keyManagerFactory, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2) {
        this(null, trustManagerFactory, file, file2, string, null, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, File file2, String string, TrustManagerFactory trustManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2) {
        this(null, trustManagerFactory, file, file2, string, null, iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l, l2);
    }

    @Deprecated
    public OpenSslServerContext(File file, TrustManagerFactory trustManagerFactory, File file2, File file3, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2) {
        this(OpenSslServerContext.toX509CertificatesInternal(file), trustManagerFactory, OpenSslServerContext.toX509CertificatesInternal(file2), OpenSslServerContext.toPrivateKeyInternal(file3, string), string, keyManagerFactory, iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, l, l2, ClientAuth.NONE, null, false, false, KeyStore.getDefaultType(), null, new Map.Entry[0]);
    }

    OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, ApplicationProtocolConfig applicationProtocolConfig, long l, long l2, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        this(x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, iterable, cipherSuiteFilter, OpenSslServerContext.toNegotiator(applicationProtocolConfig), l, l2, clientAuth, stringArray, bl, bl2, string2, resumptionController, entryArray);
    }

    private OpenSslServerContext(X509Certificate[] x509CertificateArray, TrustManagerFactory trustManagerFactory, X509Certificate[] x509CertificateArray2, PrivateKey privateKey, String string, KeyManagerFactory keyManagerFactory, Iterable<String> iterable, CipherSuiteFilter cipherSuiteFilter, OpenSslApplicationProtocolNegotiator openSslApplicationProtocolNegotiator, long l, long l2, ClientAuth clientAuth, String[] stringArray, boolean bl, boolean bl2, String string2, ResumptionController resumptionController, Map.Entry<SslContextOption<?>, Object> ... entryArray) {
        super(iterable, cipherSuiteFilter, openSslApplicationProtocolNegotiator, 1, (Certificate[])x509CertificateArray2, clientAuth, stringArray, bl, bl2, resumptionController, entryArray);
        try {
            OpenSslKeyMaterialProvider.validateKeyMaterialSupported(x509CertificateArray2, privateKey, string);
            this.sessionContext = ReferenceCountedOpenSslServerContext.newSessionContext(this, this.ctx, this.engineMap, x509CertificateArray, trustManagerFactory, x509CertificateArray2, privateKey, string, keyManagerFactory, string2, l, l2, resumptionController);
            return;
        }
        catch (Throwable throwable) {
            this.release();
            throw throwable;
        }
    }

    @Override
    public final OpenSslServerSessionContext sessionContext() {
        return this.sessionContext;
    }
}

