/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.viewinterop;

import androidx.compose.ui.Modifier;
import androidx.compose.ui.awt.AwtEvents_desktopKt;
import androidx.compose.ui.awt.InteropFocusSwitcher;
import androidx.compose.ui.awt.SwingPanel_desktopKt;
import androidx.compose.ui.draw.DrawModifierKt;
import androidx.compose.ui.graphics.BlendMode;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.input.pointer.PointerEvent;
import androidx.compose.ui.input.pointer.PointerInputChange;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.unit.IntRect;
import androidx.compose.ui.viewinterop.InteropContainer;
import androidx.compose.ui.viewinterop.InteropPointerInput_skikoKt;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder;
import androidx.compose.ui.viewinterop.SwingInteropViewHolder_desktopKt;
import androidx.compose.ui.viewinterop.TypedInteropViewHolder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.Collection;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.skiko.ClipRectangle;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B=\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\n\u0010\t\u001a\u00060\nj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\u0010\u000e\u001a\u00060\u000fj\u0002`\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\f\u0010\u0019\u001a\u00060\u001aj\u0002`\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001c\u0010 \u001a\u00020\u001d2\n\u0010!\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u001c\u0010$\u001a\u00020\u001d2\n\u0010!\u001a\u00060\nj\u0002`\u000b2\u0006\u0010\"\u001a\u00020#H\u0016J\u0014\u0010%\u001a\u00020\u001d2\n\u0010!\u001a\u00060\nj\u0002`\u000bH\u0016J\u0010\u00100\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0016J\u0012\u00103\u001a\u0004\u0018\u00010\u00022\u0006\u00104\u001a\u000205H\u0002R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010&\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010)R\u0014\u0010.\u001a\u00020'8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010)\u00a8\u00066"}, d2={"Landroidx/compose/ui/viewinterop/SwingInteropViewHolder;", "T", "Ljava/awt/Component;", "Landroidx/compose/ui/viewinterop/TypedInteropViewHolder;", "Lorg/jetbrains/skiko/ClipRectangle;", "factory", "Lkotlin/Function0;", "container", "Landroidx/compose/ui/viewinterop/InteropContainer;", "group", "Ljava/awt/Container;", "Landroidx/compose/ui/viewinterop/InteropViewGroup;", "focusSwitcher", "Landroidx/compose/ui/awt/InteropFocusSwitcher;", "compositeKeyHashCode", "", "Landroidx/compose/runtime/CompositeKeyHashCode;", "<init>", "(Lkotlin/jvm/functions/Function0;Landroidx/compose/ui/viewinterop/InteropContainer;Ljava/awt/Container;Landroidx/compose/ui/awt/InteropFocusSwitcher;J)V", "clipBounds", "Landroidx/compose/ui/unit/IntRect;", "focusListener", "Ljava/awt/event/FocusListener;", "getFocusListener", "()Ljava/awt/event/FocusListener;", "getInteropView", "", "Landroidx/compose/ui/viewinterop/InteropView;", "layoutAccordingTo", "", "layoutCoordinates", "Landroidx/compose/ui/layout/LayoutCoordinates;", "insertInteropView", "root", "index", "", "changeInteropViewIndex", "removeInteropView", "x", "", "getX", "()F", "y", "getY", "width", "getWidth", "height", "getHeight", "dispatchToView", "pointerEvent", "Landroidx/compose/ui/input/pointer/PointerEvent;", "getDeepestComponentForEvent", "event", "Ljava/awt/event/MouseEvent;", "ui"})
public final class SwingInteropViewHolder<T extends Component>
extends TypedInteropViewHolder<T>
implements ClipRectangle {
    private IntRect clipBounds;
    private final FocusListener focusListener;
    public static final int $stable = 8;

    public SwingInteropViewHolder(Function0<? extends T> function0, InteropContainer interopContainer2, Container container2, InteropFocusSwitcher interopFocusSwitcher, long l2) {
        Intrinsics.checkNotNullParameter(function0, (String)"");
        Intrinsics.checkNotNullParameter((Object)interopContainer2, (String)"");
        Intrinsics.checkNotNullParameter((Object)container2, (String)"");
        Intrinsics.checkNotNullParameter((Object)interopFocusSwitcher, (String)"");
        super(function0, interopContainer2, container2, l2, 1.INSTANCE);
        this.focusListener = new FocusListener(container2, interopFocusSwitcher){
            final /* synthetic */ Container $group;
            final /* synthetic */ InteropFocusSwitcher $focusSwitcher;
            {
                this.$group = container2;
                this.$focusSwitcher = interopFocusSwitcher;
            }

            public final void focusGained(FocusEvent focusEvent) {
                Intrinsics.checkNotNullParameter((Object)focusEvent, (String)"");
                if (SwingPanel_desktopKt.isFocusGainedHandledBySwingPanel(focusEvent, this.$group)) {
                    FocusEvent.Cause cause = focusEvent.getCause();
                    switch (cause == null ? -1 : focusListener.WhenMappings.$EnumSwitchMapping$0[cause.ordinal()]) {
                        case 1: {
                            this.$focusSwitcher.moveAfterInteropView();
                            return;
                        }
                        case 2: {
                            this.$focusSwitcher.moveBeforeInteropView();
                        }
                    }
                }
            }

            public final void focusLost(FocusEvent focusEvent) {
                Intrinsics.checkNotNullParameter((Object)focusEvent, (String)"");
            }
        };
        container2.add((Component)this.getTypedInteropView());
        this.setPlatformModifier(DrawModifierKt.drawBehind(InteropPointerInput_skikoKt.pointerInteropFilter(Modifier.Companion, this), (Function1<? super DrawScope, Unit>)((Function1)SwingInteropViewHolder::_init_$lambda$0)));
    }

    public final FocusListener getFocusListener() {
        return this.focusListener;
    }

    @Override
    public final Object getInteropView() {
        return this.getTypedInteropView();
    }

    @Override
    public final void layoutAccordingTo(LayoutCoordinates layoutCoordinates) {
        Intrinsics.checkNotNullParameter((Object)layoutCoordinates, (String)"");
        LayoutCoordinates layoutCoordinates2 = LayoutCoordinatesKt.findRootCoordinates(layoutCoordinates);
        IntRect intRect = SwingInteropViewHolder_desktopKt.access$round(layoutCoordinates2.localBoundingBoxOf(layoutCoordinates, true), this.getDensity());
        layoutCoordinates = SwingInteropViewHolder_desktopKt.access$round(layoutCoordinates2.localBoundingBoxOf(layoutCoordinates, false), this.getDensity());
        this.clipBounds = intRect;
        this.getContainer().scheduleUpdate((Function0<Unit>)((Function0)() -> SwingInteropViewHolder.layoutAccordingTo$lambda$1(this, intRect, (IntRect)layoutCoordinates)));
    }

    @Override
    public final void insertInteropView(Container container2, int n2) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"");
        container2.add((Component)this.getGroup(), n2);
        super.insertInteropView(container2, n2);
        this.getContainer().getRoot().addFocusListener(this.focusListener);
    }

    @Override
    public final void changeInteropViewIndex(Container container2, int n2) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"");
        container2.setComponentZOrder(this.getGroup(), n2);
    }

    @Override
    public final void removeInteropView(Container container2) {
        Intrinsics.checkNotNullParameter((Object)container2, (String)"");
        container2.remove(this.getGroup());
        super.removeInteropView(container2);
        this.getContainer().getRoot().removeFocusListener(this.focusListener);
    }

    public final float getX() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getLeft() : this.getGroup().getX();
    }

    public final float getY() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getTop() : this.getGroup().getY();
    }

    public final float getWidth() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getWidth() : this.getGroup().getWidth();
    }

    public final float getHeight() {
        IntRect intRect = this.clipBounds;
        return intRect != null ? intRect.getHeight() : this.getGroup().getHeight();
    }

    @Override
    public final void dispatchToView(PointerEvent object) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"");
        MouseEvent mouseEvent = AwtEvents_desktopKt.getAwtEventOrNull((PointerEvent)object);
        if (mouseEvent == null) {
            return;
        }
        MouseEvent mouseEvent2 = mouseEvent;
        switch (mouseEvent.getID()) {
            case 504: 
            case 505: {
                return;
            }
        }
        if (SwingUtilities.isDescendingFrom(mouseEvent2.getComponent(), this.getGroup())) {
            return;
        }
        Component component = this.getDeepestComponentForEvent(mouseEvent2);
        if (component != null) {
            component.dispatchEvent(SwingUtilities.convertMouseEvent(mouseEvent2.getComponent(), mouseEvent2, component));
            object = ((PointerEvent)object).getChanges();
            int n2 = ((Collection)object).size();
            for (int j = 0; j < n2; ++j) {
                Object object2 = object.get(j);
                object2 = (PointerInputChange)object2;
                ((PointerInputChange)object2).consume();
            }
        }
    }

    private final Component getDeepestComponentForEvent(MouseEvent serializable) {
        serializable = SwingUtilities.convertPoint(serializable.getComponent(), serializable.getPoint(), (Component)this.getTypedInteropView());
        return SwingUtilities.getDeepestComponentAt((Component)this.getTypedInteropView(), ((Point)serializable).x, ((Point)serializable).y);
    }

    private static final Unit _init_$lambda$0(DrawScope drawScope) {
        Intrinsics.checkNotNullParameter((Object)drawScope, (String)"");
        DrawScope.drawRect-n-J9OG0$default((DrawScope)drawScope, (long)Color.Companion.getTransparent-0d7_KjU(), (long)0L, (long)0L, (float)0.0f, null, null, (int)BlendMode.Companion.getClear-0nO6VwU(), (int)62, null);
        return Unit.INSTANCE;
    }

    private static final Unit layoutAccordingTo$lambda$1(SwingInteropViewHolder swingInteropViewHolder, IntRect intRect, IntRect intRect2) {
        swingInteropViewHolder.getGroup().setVisible(!intRect.isEmpty());
        swingInteropViewHolder.getGroup().setBounds(intRect.getLeft(), intRect.getTop(), intRect.getWidth(), intRect.getHeight());
        ((Component)swingInteropViewHolder.getTypedInteropView()).setBounds(intRect2.getLeft() - intRect.getLeft(), intRect2.getTop() - intRect.getTop(), intRect2.getWidth(), intRect2.getHeight());
        return Unit.INSTANCE;
    }
}

