/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.chat2;

import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.e.a.e;
import org.e.a.i;
import org.jivesoftware.smack.AsyncButOrdered;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.StanzaListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.chat2.Chat;
import org.jivesoftware.smack.chat2.IncomingChatMessageListener;
import org.jivesoftware.smack.chat2.OutgoingChatMessageListener;
import org.jivesoftware.smack.filter.AndFilter;
import org.jivesoftware.smack.filter.FromTypeFilter;
import org.jivesoftware.smack.filter.MessageTypeFilter;
import org.jivesoftware.smack.filter.MessageWithBodiesFilter;
import org.jivesoftware.smack.filter.OrFilter;
import org.jivesoftware.smack.filter.StanzaExtensionFilter;
import org.jivesoftware.smack.filter.StanzaFilter;
import org.jivesoftware.smack.filter.ToTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smack.packet.MessageView;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.Stanza;
import org.jivesoftware.smack.roster.AbstractRosterListener;
import org.jivesoftware.smack.roster.Roster;
import org.jivesoftware.smack.roster.RosterListener;
import org.jivesoftware.smackx.xhtmlim.packet.XHTMLExtension;

public final class ChatManager
extends Manager {
    private static final Map<XMPPConnection, ChatManager> INSTANCES = new WeakHashMap<XMPPConnection, ChatManager>();
    private static final StanzaFilter MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MessageTypeFilter.NORMAL_OR_CHAT, new OrFilter(new StanzaFilter[]{MessageWithBodiesFilter.INSTANCE, new StanzaExtensionFilter("html", "http://jabber.org/protocol/xhtml-im")})});
    private static final StanzaFilter OUTGOING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MESSAGE_FILTER, ToTypeFilter.ENTITY_FULL_OR_BARE_JID});
    private static final StanzaFilter INCOMING_MESSAGE_FILTER = new AndFilter(new StanzaFilter[]{MESSAGE_FILTER, FromTypeFilter.ENTITY_FULL_JID});
    private final Map<e, Chat> chats = new ConcurrentHashMap<e, Chat>();
    private final Set<IncomingChatMessageListener> incomingListeners = new CopyOnWriteArraySet<IncomingChatMessageListener>();
    private final Set<OutgoingChatMessageListener> outgoingListeners = new CopyOnWriteArraySet<OutgoingChatMessageListener>();
    private final AsyncButOrdered<Chat> asyncButOrdered = new AsyncButOrdered();
    private boolean xhtmlIm;

    public static synchronized ChatManager getInstanceFor(XMPPConnection xMPPConnection) {
        ChatManager chatManager = INSTANCES.get(xMPPConnection);
        if (chatManager == null) {
            chatManager = new ChatManager(xMPPConnection);
            INSTANCES.put(xMPPConnection, chatManager);
        }
        return chatManager;
    }

    private ChatManager(XMPPConnection xMPPConnection) {
        super(xMPPConnection);
        xMPPConnection.addSyncStanzaListener(new StanzaListener(){

            public void processStanza(Stanza stanza) {
                if (!ChatManager.this.shouldAcceptMessage((MessageView)(stanza = (Message)stanza))) {
                    return;
                }
                i i2 = stanza.getFrom();
                i2 = i2.r();
                final e e2 = i2.b();
                Chat chat = ChatManager.this.chatWith(e2);
                ChatManager.this.chatWith(e2).lockedResource = i2;
                ChatManager.this.asyncButOrdered.performAsyncButOrdered((Object)chat, new Runnable((Message)stanza, chat){
                    final /* synthetic */ Message val$message;
                    final /* synthetic */ Chat val$chat;
                    {
                        this.val$message = message;
                        this.val$chat = chat;
                    }

                    @Override
                    public void run() {
                        for (IncomingChatMessageListener incomingChatMessageListener : ChatManager.this.incomingListeners) {
                            incomingChatMessageListener.newIncomingMessage(e2, this.val$message, this.val$chat);
                        }
                    }
                });
            }
        }, INCOMING_MESSAGE_FILTER);
        xMPPConnection.addMessageInterceptor(messageBuilder -> {
            if (!this.shouldAcceptMessage((MessageView)messageBuilder)) {
                return;
            }
            e e2 = messageBuilder.getTo().p();
            Chat chat = this.chatWith(e2);
            for (OutgoingChatMessageListener outgoingChatMessageListener : this.outgoingListeners) {
                outgoingChatMessageListener.newOutgoingMessage(e2, (MessageBuilder)messageBuilder, chat);
            }
        }, message -> OUTGOING_MESSAGE_FILTER.accept((Stanza)message));
        xMPPConnection = Roster.getInstanceFor((XMPPConnection)xMPPConnection);
        xMPPConnection.addRosterListener((RosterListener)new AbstractRosterListener(){

            public void presenceChanged(Presence presence) {
                i i2 = presence.getFrom();
                Object object = i2.o();
                if (object == null) {
                    return;
                }
                object = (Chat)((Object)ChatManager.this.chats.get(object));
                if (object == null) {
                    return;
                }
                if (object.lockedResource == null) {
                    return;
                }
                if (object.lockedResource.a((CharSequence)(i2 = i2.q()))) {
                    return;
                }
                if (object.lastPresenceOfLockedResource == null) {
                    object.lastPresenceOfLockedResource = presence;
                    return;
                }
                if (object.lastPresenceOfLockedResource.getMode() != presence.getMode() || object.lastPresenceOfLockedResource.getType() != presence.getType()) {
                    object.unlockResource();
                }
            }
        });
    }

    private boolean shouldAcceptMessage(MessageView object) {
        if (object.hasExtension(Message.Body.QNAME)) {
            return true;
        }
        if (!this.xhtmlIm) {
            return false;
        }
        return (object = XHTMLExtension.from(object)) != null;
    }

    public final boolean addIncomingListener(IncomingChatMessageListener incomingChatMessageListener) {
        return this.incomingListeners.add(incomingChatMessageListener);
    }

    public final boolean removeIncomingListener(IncomingChatMessageListener incomingChatMessageListener) {
        return this.incomingListeners.remove(incomingChatMessageListener);
    }

    public final boolean addOutgoingListener(OutgoingChatMessageListener outgoingChatMessageListener) {
        return this.outgoingListeners.add(outgoingChatMessageListener);
    }

    public final boolean removeOutgoingListener(OutgoingChatMessageListener outgoingChatMessageListener) {
        return this.outgoingListeners.remove(outgoingChatMessageListener);
    }

    public final Chat chatWith(e e2) {
        Chat chat = this.chats.get(e2);
        if (chat == null) {
            Map<e, Chat> map = this.chats;
            synchronized (map) {
                chat = this.chats.get(e2);
                if (chat != null) {
                    return chat;
                }
                chat = new Chat(this.connection(), e2);
                this.chats.put(e2, chat);
            }
        }
        return chat;
    }

    public final void setXhmtlImEnabled(boolean bl) {
        this.xhtmlIm = bl;
    }
}

