/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bookmarks;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.e.a.b.d;
import org.e.a.e;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smackx.bookmarks.BookmarkedConference;
import org.jivesoftware.smackx.bookmarks.BookmarkedURL;
import org.jivesoftware.smackx.bookmarks.Bookmarks;
import org.jivesoftware.smackx.iqprivate.PrivateDataManager;

public final class BookmarkManager {
    private static final Map<XMPPConnection, BookmarkManager> bookmarkManagerMap = new WeakHashMap<XMPPConnection, BookmarkManager>();
    private final PrivateDataManager privateDataManager;
    private Bookmarks bookmarks;
    private final Object bookmarkLock = new Object();

    public static synchronized BookmarkManager getBookmarkManager(XMPPConnection xMPPConnection) {
        BookmarkManager bookmarkManager = bookmarkManagerMap.get(xMPPConnection);
        if (bookmarkManager == null) {
            bookmarkManager = new BookmarkManager(xMPPConnection);
            bookmarkManagerMap.put(xMPPConnection, bookmarkManager);
        }
        return bookmarkManager;
    }

    private BookmarkManager(XMPPConnection xMPPConnection) {
        this.privateDataManager = PrivateDataManager.getInstanceFor(xMPPConnection);
    }

    public final List<BookmarkedConference> getBookmarkedConferences() {
        this.retrieveBookmarks();
        return Collections.unmodifiableList(this.bookmarks.getBookmarkedConferences());
    }

    public final void addBookmarkedConference(String string, e object, boolean bl, d d2, String string2) {
        this.retrieveBookmarks();
        object = new BookmarkedConference(string, (e)object, bl, d2, string2);
        List<BookmarkedConference> list = this.bookmarks.getBookmarkedConferences();
        if (list.contains(object)) {
            List<BookmarkedConference> list2 = list;
            if (((BookmarkedConference)(object = list2.get(list2.indexOf(object)))).isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmark");
            }
            ((BookmarkedConference)object).setAutoJoin(bl);
            ((BookmarkedConference)object).setName(string);
            ((BookmarkedConference)object).setNickname(d2);
            ((BookmarkedConference)object).setPassword(string2);
        } else {
            this.bookmarks.addBookmarkedConference((BookmarkedConference)object);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public final void removeBookmarkedConference(e e2) {
        this.retrieveBookmarks();
        Iterator<BookmarkedConference> iterator = this.bookmarks.getBookmarkedConferences().iterator();
        while (iterator.hasNext()) {
            BookmarkedConference bookmarkedConference = iterator.next();
            if (!bookmarkedConference.getJid().a((CharSequence)e2)) continue;
            if (bookmarkedConference.isShared()) {
                throw new IllegalArgumentException("Conference is shared and can't be removed");
            }
            iterator.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    public final List<BookmarkedURL> getBookmarkedURLs() {
        this.retrieveBookmarks();
        return Collections.unmodifiableList(this.bookmarks.getBookmarkedURLS());
    }

    public final void addBookmarkedURL(String object, String string, boolean bl) {
        this.retrieveBookmarks();
        object = new BookmarkedURL((String)object, string, bl);
        List<BookmarkedURL> list = this.bookmarks.getBookmarkedURLS();
        if (list.contains(object)) {
            List<BookmarkedURL> list2 = list;
            if (((BookmarkedURL)(object = list2.get(list2.indexOf(object)))).isShared()) {
                throw new IllegalArgumentException("Cannot modify shared bookmarks");
            }
            ((BookmarkedURL)object).setName(string);
            ((BookmarkedURL)object).setRss(bl);
        } else {
            this.bookmarks.addBookmarkedURL((BookmarkedURL)object);
        }
        this.privateDataManager.setPrivateData(this.bookmarks);
    }

    public final void removeBookmarkedURL(String string) {
        this.retrieveBookmarks();
        Iterator<BookmarkedURL> iterator = this.bookmarks.getBookmarkedURLS().iterator();
        while (iterator.hasNext()) {
            BookmarkedURL bookmarkedURL = iterator.next();
            if (!bookmarkedURL.getURL().equalsIgnoreCase(string)) continue;
            if (bookmarkedURL.isShared()) {
                throw new IllegalArgumentException("Cannot delete a shared bookmark.");
            }
            iterator.remove();
            this.privateDataManager.setPrivateData(this.bookmarks);
            return;
        }
    }

    public final boolean isSupported() {
        return this.privateDataManager.isSupported();
    }

    private Bookmarks retrieveBookmarks() {
        Object object = this.bookmarkLock;
        synchronized (object) {
            if (this.bookmarks == null) {
                this.bookmarks = (Bookmarks)this.privateDataManager.getPrivateData("storage", "storage:bookmarks");
            }
            return this.bookmarks;
        }
    }

    static {
        PrivateDataManager.addPrivateDataProvider("storage", "storage:bookmarks", new Bookmarks.Provider());
    }
}

