/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.bytestreams.ibb;

import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.bytestreams.BytestreamListener;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamManager;
import org.jivesoftware.smackx.bytestreams.ibb.InBandBytestreamRequest;
import org.jivesoftware.smackx.bytestreams.ibb.packet.Open;
import org.jivesoftware.smackx.filetransfer.StreamNegotiator;

class InitiationListener
extends AbstractIqRequestHandler {
    private final InBandBytestreamManager manager;

    protected InitiationListener(InBandBytestreamManager inBandBytestreamManager) {
        super("open", "http://jabber.org/protocol/ibb", IQ.Type.set, IQRequestHandler.Mode.async);
        this.manager = inBandBytestreamManager;
    }

    public IQ handleIQRequest(IQ object3) {
        int n;
        Object object = (Open)((Object)object3);
        int inBandBytestreamRequest = object.getBlockSize();
        if (inBandBytestreamRequest > (n = this.manager.getMaximumBlockSize())) {
            StanzaError stanzaError = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.resource_constraint).setDescriptiveEnText("Requests block size of " + inBandBytestreamRequest + " exceeds maximum block size of " + n)).build();
            return IQ.createErrorResponse((IQ)object3, (StanzaError)stanzaError);
        }
        StreamNegotiator.signal(object.getFrom().toString() + '\t' + object.getSessionID(), object);
        if (this.manager.getIgnoredBytestreamRequests().remove(object.getSessionID())) {
            return null;
        }
        InBandBytestreamRequest inBandBytestreamRequest2 = new InBandBytestreamRequest(this.manager, (Open)((Object)object));
        if ((object = this.manager.getUserListener(object.getFrom())) != null) {
            object.incomingBytestreamRequest(inBandBytestreamRequest2);
        } else if (!this.manager.getAllRequestListeners().isEmpty()) {
            for (BytestreamListener bytestreamListener : this.manager.getAllRequestListeners()) {
                bytestreamListener.incomingBytestreamRequest(inBandBytestreamRequest2);
            }
        } else {
            object = ((StanzaError.Builder)StanzaError.getBuilder().setCondition(StanzaError.Condition.not_acceptable).setDescriptiveEnText("No file-transfer listeners registered")).build();
            return IQ.createErrorResponse((IQ)object3, (StanzaError)object);
        }
        return null;
    }
}

