/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.geoloc.packet;

import java.io.Serializable;
import java.net.URI;
import java.util.Date;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.HashCode;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.xdata.FormField;
import org.jivesoftware.smackx.xdata.FormFieldChildElement;

public final class GeoLocation
implements Serializable,
ExtensionElement,
FormFieldChildElement {
    private static final long serialVersionUID = 1L;
    public static final String NAMESPACE = "http://jabber.org/protocol/geoloc";
    public static final String ELEMENT = "geoloc";
    public static final QName QNAME = new QName("http://jabber.org/protocol/geoloc", "geoloc");
    public static final GeoLocation EMPTY_GEO_LOCATION = GeoLocation.builder().build();
    private final Double accuracy;
    private final Double alt;
    private final Double altAccuracy;
    private final String area;
    private final Double bearing;
    private final String building;
    private final String country;
    private final String countryCode;
    private final String datum;
    private final String description;
    private final Double error;
    private final String floor;
    private final Double lat;
    private final String locality;
    private final Double lon;
    private final String postalcode;
    private final String region;
    private final String room;
    private final Double speed;
    private final String street;
    private final String text;
    private final Date timestamp;
    private final String tzo;
    private final URI uri;
    private final HashCode.Cache hashCodeCache = new HashCode.Cache();

    private GeoLocation(Builder builder) {
        this.accuracy = builder.accuracy;
        this.alt = builder.alt;
        this.altAccuracy = builder.altAccuracy;
        this.area = builder.area;
        this.bearing = builder.bearing;
        this.building = builder.building;
        this.country = builder.country;
        this.countryCode = builder.countryCode;
        this.datum = builder.datum;
        this.description = builder.description;
        this.error = builder.error;
        this.floor = builder.floor;
        this.lat = builder.lat;
        this.locality = builder.locality;
        this.lon = builder.lon;
        this.postalcode = builder.postalcode;
        this.region = builder.region;
        this.room = builder.room;
        this.speed = builder.speed;
        this.street = builder.street;
        this.text = builder.text;
        this.timestamp = builder.timestamp;
        this.tzo = builder.tzo;
        this.uri = builder.uri;
    }

    public final Double getAccuracy() {
        return this.accuracy;
    }

    public final Double getAlt() {
        return this.alt;
    }

    public final Double getAltAccuracy() {
        return this.altAccuracy;
    }

    public final String getArea() {
        return this.area;
    }

    public final Double getBearing() {
        return this.bearing;
    }

    public final String getBuilding() {
        return this.building;
    }

    public final String getCountry() {
        return this.country;
    }

    public final String getCountryCode() {
        return this.countryCode;
    }

    public final String getDatum() {
        return this.datum;
    }

    public final String getDescription() {
        return this.description;
    }

    @Deprecated
    public final Double getError() {
        return this.error;
    }

    public final String getFloor() {
        return this.floor;
    }

    public final Double getLat() {
        return this.lat;
    }

    public final String getLocality() {
        return this.locality;
    }

    public final Double getLon() {
        return this.lon;
    }

    public final String getPostalcode() {
        return this.postalcode;
    }

    public final String getRegion() {
        return this.region;
    }

    public final String getRoom() {
        return this.room;
    }

    public final Double getSpeed() {
        return this.speed;
    }

    public final String getStreet() {
        return this.street;
    }

    public final String getText() {
        return this.text;
    }

    public final Date getTimestamp() {
        return this.timestamp;
    }

    public final String getTzo() {
        return this.tzo;
    }

    public final URI getUri() {
        return this.uri;
    }

    public final QName getQName() {
        return QNAME;
    }

    public final String getElementName() {
        return ELEMENT;
    }

    public final CharSequence toXML(XmlEnvironment xmlEnvironment) {
        xmlEnvironment = new XmlStringBuilder((ExtensionElement)this);
        xmlEnvironment.rightAngleBracket();
        xmlEnvironment.optElement("accuracy", (Object)this.accuracy);
        xmlEnvironment.optElement("alt", (Object)this.alt);
        xmlEnvironment.optElement("altaccuracy", (Object)this.altAccuracy);
        xmlEnvironment.optElement("area", this.area);
        xmlEnvironment.optElement("bearing", (Object)this.bearing);
        xmlEnvironment.optElement("building", this.building);
        xmlEnvironment.optElement("country", this.country);
        xmlEnvironment.optElement("countrycode", this.countryCode);
        xmlEnvironment.optElement("datum", this.datum);
        xmlEnvironment.optElement("description", this.description);
        xmlEnvironment.optElement("error", (Object)this.error);
        xmlEnvironment.optElement("floor", this.floor);
        xmlEnvironment.optElement("lat", (Object)this.lat);
        xmlEnvironment.optElement("locality", this.locality);
        xmlEnvironment.optElement("lon", (Object)this.lon);
        xmlEnvironment.optElement("postalcode", this.postalcode);
        xmlEnvironment.optElement("region", this.region);
        xmlEnvironment.optElement("room", this.room);
        xmlEnvironment.optElement("speed", (Object)this.speed);
        xmlEnvironment.optElement("street", this.street);
        xmlEnvironment.optElement("text", this.text);
        xmlEnvironment.optElement("timestamp", this.timestamp);
        xmlEnvironment.optElement("tzo", this.tzo);
        xmlEnvironment.optElement("uri", (Object)this.uri);
        xmlEnvironment.closeElement((NamedElement)this);
        return xmlEnvironment;
    }

    public final String getNamespace() {
        return NAMESPACE;
    }

    public final int hashCode() {
        return this.hashCodeCache.getHashCode(builder -> builder.append((Object)this.accuracy).append((Object)this.alt).append((Object)this.altAccuracy).append((Object)this.area).append((Object)this.bearing).append((Object)this.building).append((Object)this.country).append((Object)this.countryCode).append((Object)this.datum).append((Object)this.description).append((Object)this.error).append((Object)this.floor).append((Object)this.lat).append((Object)this.locality).append((Object)this.lon).append((Object)this.postalcode).append((Object)this.region).append((Object)this.room).append((Object)this.speed).append((Object)this.street).append((Object)this.text).append((Object)this.timestamp).append((Object)this.tzo).append((Object)this.uri));
    }

    public final boolean equals(Object object) {
        return EqualsUtil.equals((Object)this, (Object)object, (builder, geoLocation) -> builder.append((Object)this.accuracy, (Object)geoLocation.accuracy).append((Object)this.altAccuracy, (Object)geoLocation.altAccuracy).append((Object)this.area, (Object)geoLocation.area).append((Object)this.bearing, (Object)geoLocation.bearing).append((Object)this.building, (Object)geoLocation.building).append((Object)this.country, (Object)geoLocation.country).append((Object)this.countryCode, (Object)geoLocation.countryCode).append((Object)this.datum, (Object)geoLocation.datum).append((Object)this.description, (Object)geoLocation.description).append((Object)this.error, (Object)geoLocation.error).append((Object)this.floor, (Object)geoLocation.floor).append((Object)this.lat, (Object)geoLocation.lat).append((Object)this.locality, (Object)geoLocation.locality).append((Object)this.lon, (Object)geoLocation.lon).append((Object)this.postalcode, (Object)geoLocation.postalcode).append((Object)this.region, (Object)geoLocation.region).append((Object)this.room, (Object)geoLocation.room).append((Object)this.speed, (Object)geoLocation.speed).append((Object)this.street, (Object)geoLocation.street).append((Object)this.text, (Object)geoLocation.text).append((Object)this.timestamp, (Object)geoLocation.timestamp).append((Object)this.tzo, (Object)geoLocation.tzo).append((Object)this.uri, (Object)geoLocation.uri));
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public final boolean isExclusiveElement() {
        return true;
    }

    public static GeoLocation from(Message message) {
        return (GeoLocation)message.getExtension(GeoLocation.class);
    }

    public static GeoLocation from(FormField formField) {
        return (GeoLocation)formField.getFormFieldChildElement(QNAME);
    }

    public static class Builder {
        private Double accuracy;
        private Double alt;
        private Double altAccuracy;
        private String area;
        private Double bearing;
        private String building;
        private String country;
        private String countryCode;
        private String datum = "WGS84";
        private String description;
        private Double error;
        private String floor;
        private Double lat;
        private String locality;
        private Double lon;
        private String postalcode;
        private String region;
        private String room;
        private Double speed;
        private String street;
        private String text;
        private Date timestamp;
        private String tzo;
        private URI uri;

        public Builder setAccuracy(Double d2) {
            this.accuracy = d2;
            return this;
        }

        public Builder setAlt(Double d2) {
            this.alt = d2;
            return this;
        }

        public Builder setAltAccuracy(Double d2) {
            this.altAccuracy = d2;
            return this;
        }

        public Builder setArea(String string) {
            this.area = string;
            return this;
        }

        public Builder setBearing(Double d2) {
            this.bearing = d2;
            return this;
        }

        public Builder setBuilding(String string) {
            this.building = string;
            return this;
        }

        public Builder setCountry(String string) {
            this.country = string;
            return this;
        }

        public Builder setCountryCode(String string) {
            this.countryCode = string;
            return this;
        }

        public Builder setDatum(String string) {
            this.datum = string;
            return this;
        }

        public Builder setDescription(String string) {
            this.description = string;
            return this;
        }

        @Deprecated
        public Builder setError(Double d2) {
            this.error = d2;
            return this;
        }

        public Builder setFloor(String string) {
            this.floor = string;
            return this;
        }

        public Builder setLat(Double d2) {
            this.lat = d2;
            return this;
        }

        public Builder setLocality(String string) {
            this.locality = string;
            return this;
        }

        public Builder setLon(Double d2) {
            this.lon = d2;
            return this;
        }

        public Builder setPostalcode(String string) {
            this.postalcode = string;
            return this;
        }

        public Builder setRegion(String string) {
            this.region = string;
            return this;
        }

        public Builder setRoom(String string) {
            this.room = string;
            return this;
        }

        public Builder setSpeed(Double d2) {
            this.speed = d2;
            return this;
        }

        public Builder setStreet(String string) {
            this.street = string;
            return this;
        }

        public Builder setText(String string) {
            this.text = string;
            return this;
        }

        public Builder setTimestamp(Date date) {
            this.timestamp = date;
            return this;
        }

        public Builder setTzo(String string) {
            this.tzo = string;
            return this;
        }

        public Builder setUri(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public GeoLocation build() {
            return new GeoLocation(this);
        }
    }
}

