/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.xhtmlim;

import org.jivesoftware.smack.util.XmlStringBuilder;

public class XHTMLText {
    public static final String NAMESPACE = "http://www.w3.org/1999/xhtml";
    private final XmlStringBuilder text = new XmlStringBuilder();
    public static final String A = "a";
    public static final String HREF = "href";
    public static final String STYLE = "style";
    public static final String BLOCKQUOTE = "blockquote";
    public static final String BR = "br";
    public static final String CITE = "cite";
    public static final String CODE = "code";
    public static final String EM = "em";
    public static final String H = "h";
    public static final String IMG = "img";
    public static final String LI = "li";
    public static final String OL = "ol";
    public static final String UL = "ul";
    public static final String P = "p";
    public static final String Q = "q";
    public static final String SPAN = "span";
    public static final String STRONG = "strong";

    public XHTMLText(String string, String string2) {
        this.appendOpenBodyTag(string, string2);
    }

    public XHTMLText appendOpenAnchorTag(String string, String string2) {
        this.text.halfOpenElement(A);
        this.text.optAttribute(HREF, string);
        this.text.optAttribute(STYLE, string2);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseAnchorTag() {
        this.text.closeElement(A);
        return this;
    }

    public XHTMLText appendOpenBlockQuoteTag(String string) {
        this.text.halfOpenElement(BLOCKQUOTE);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseBlockQuoteTag() {
        this.text.closeElement(BLOCKQUOTE);
        return this;
    }

    private XHTMLText appendOpenBodyTag(String string, String string2) {
        this.text.halfOpenElement("body");
        this.text.xmlnsAttribute(NAMESPACE);
        this.text.optAttribute(STYLE, string);
        this.text.xmllangAttribute(string2);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseBodyTag() {
        this.text.closeElement("body");
        return this;
    }

    public XHTMLText appendBrTag() {
        this.text.emptyElement(BR);
        return this;
    }

    public XHTMLText appendOpenCiteTag() {
        this.text.openElement(CITE);
        return this;
    }

    public XHTMLText appendOpenCodeTag() {
        this.text.openElement(CODE);
        return this;
    }

    public XHTMLText appendCloseCodeTag() {
        this.text.closeElement(CODE);
        return this;
    }

    public XHTMLText appendOpenEmTag() {
        this.text.openElement(EM);
        return this;
    }

    public XHTMLText appendCloseEmTag() {
        this.text.closeElement(EM);
        return this;
    }

    public XHTMLText appendOpenHeaderTag(int n, String string) {
        if (n > 3 || n <= 0) {
            throw new IllegalArgumentException("Level must be between 1 and 3");
        }
        this.text.halfOpenElement(H + Integer.toString(n));
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseHeaderTag(int n) {
        if (n > 3 || n <= 0) {
            throw new IllegalArgumentException("Level must be between 1 and 3");
        }
        this.text.closeElement(H + Integer.toBinaryString(n));
        return this;
    }

    public XHTMLText appendImageTag(String string, String string2, String string3, String string4, String string5) {
        this.text.halfOpenElement(IMG);
        this.text.optAttribute("align", string);
        this.text.optAttribute("alt", string2);
        this.text.optAttribute("height", string3);
        this.text.optAttribute("src", string4);
        this.text.optAttribute("width", string5);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendLineItemTag(String string) {
        this.text.halfOpenElement(LI);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseLineItemTag() {
        this.text.closeElement(LI);
        return this;
    }

    public XHTMLText appendOpenOrderedListTag(String string) {
        this.text.halfOpenElement(OL);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseOrderedListTag() {
        this.text.closeElement(OL);
        return this;
    }

    public XHTMLText appendOpenUnorderedListTag(String string) {
        this.text.halfOpenElement(UL);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseUnorderedListTag() {
        this.text.closeElement(UL);
        return this;
    }

    public XHTMLText appendOpenParagraphTag(String string) {
        this.text.halfOpenElement(P);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseParagraphTag() {
        this.text.closeElement(P);
        return this;
    }

    public XHTMLText appendOpenInlinedQuoteTag(String string) {
        this.text.halfOpenElement(Q);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseInlinedQuoteTag() {
        this.text.closeElement(Q);
        return this;
    }

    public XHTMLText appendOpenSpanTag(String string) {
        this.text.halfOpenElement(SPAN);
        this.text.optAttribute(STYLE, string);
        this.text.rightAngleBracket();
        return this;
    }

    public XHTMLText appendCloseSpanTag() {
        this.text.closeElement(SPAN);
        return this;
    }

    public XHTMLText appendOpenStrongTag() {
        this.text.openElement(STRONG);
        return this;
    }

    public XHTMLText appendCloseStrongTag() {
        this.text.closeElement(STRONG);
        return this;
    }

    public XHTMLText append(String string) {
        this.text.escape(string);
        return this;
    }

    public String toString() {
        return this.text.toString();
    }

    public XmlStringBuilder toXML() {
        return this.text;
    }
}

