/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\n\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 -*\n\b\u0000\u0010\u0001*\u0004\u0018\u00010\u00022\u00020\u0003:\u0002-.B\u001b\b\u0007\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u001d\u0010\u001b\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u001c\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002J\u0013\u0010 \u001a\u00020\u00072\b\u0010!\u001a\u0004\u0018\u00010\u0003H\u0096\u0002J\b\u0010\"\u001a\u00020\u0005H\u0016J\u0006\u0010#\u001a\u00020\u0007J\r\u0010$\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010%J\r\u0010&\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010%J\u0013\u0010'\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010(\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00028\u00002\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010)J\b\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u0005H\u0002R\u0011\u0010\t\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\fX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006/"}, d2={"Ldorkbox/collections/BinaryHeap;", "T", "Ldorkbox/collections/BinaryHeap$Node;", "", "capacity", "", "isMaxHeap", "", "(IZ)V", "isEmpty", "()Z", "nodes", "", "[Ldorkbox/collections/BinaryHeap$Node;", "size", "getSize", "()I", "setSize", "(I)V", "add", "node", "(Ldorkbox/collections/BinaryHeap$Node;)Ldorkbox/collections/BinaryHeap$Node;", "value", "", "(Ldorkbox/collections/BinaryHeap$Node;F)Ldorkbox/collections/BinaryHeap$Node;", "clear", "", "contains", "identity", "(Ldorkbox/collections/BinaryHeap$Node;Z)Z", "down", "index", "equals", "other", "hashCode", "notEmpty", "peek", "()Ldorkbox/collections/BinaryHeap$Node;", "pop", "remove", "setValue", "(Ldorkbox/collections/BinaryHeap$Node;F)V", "toString", "", "up", "Companion", "Node", "Collections"})
public final class BinaryHeap<T extends Node> {
    public static final Companion Companion = new Companion(null);
    private final boolean isMaxHeap;
    private int size;
    private Node[] nodes;
    public static final String version = "2.8";

    public BinaryHeap(int n, boolean bl) {
        this.isMaxHeap = bl;
        this.nodes = new Node[n];
    }

    public /* synthetic */ BinaryHeap(int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        if ((n2 & 2) != 0) {
            bl = false;
        }
        this(n, bl);
    }

    public final int getSize() {
        return this.size;
    }

    public final void setSize(int n) {
        this.size = n;
    }

    public final T add(T t) {
        if (this.size == this.nodes.length) {
            Node[] nodeArray = new Node[this.size << 1];
            System.arraycopy(this.nodes, 0, nodeArray, 0, this.size);
            this.nodes = nodeArray;
        }
        T t2 = t;
        Intrinsics.checkNotNull(t2);
        ((Node)t2).setIndex(this.size);
        this.nodes[this.size] = t;
        BinaryHeap binaryHeap = this;
        int n = binaryHeap.size;
        this.size = n + 1;
        binaryHeap.up(n);
        return t;
    }

    public final T add(T t, float f) {
        T t2 = t;
        Intrinsics.checkNotNull(t2);
        ((Node)t2).setValue(f);
        return this.add(t);
    }

    public final boolean contains(T t, boolean bl) {
        if (t == null) {
            String string = "node cannot be null.";
            throw new IllegalArgumentException(string.toString());
        }
        if (bl) {
            for (Node node : this.nodes) {
                if (node != t) continue;
                return true;
            }
        } else {
            for (Node node : this.nodes) {
                if (!Intrinsics.areEqual((Object)node, t)) continue;
                return true;
            }
        }
        return false;
    }

    public final T peek() {
        if (!(this.size != 0)) {
            String string = "The heap is empty.";
            throw new IllegalStateException(string.toString());
        }
        return (T)this.nodes[0];
    }

    public final T pop() {
        Node node = this.nodes[0];
        this.size += -1;
        if (this.size > 0) {
            this.nodes[0] = this.nodes[this.size];
            this.nodes[this.size] = null;
            this.down(0);
        } else {
            this.nodes[0] = null;
        }
        return (T)node;
    }

    public final T remove(T t) {
        this.size += -1;
        if (this.size > 0) {
            Node node = this.nodes[this.size];
            this.nodes[this.size] = null;
            T t2 = t;
            Intrinsics.checkNotNull(t2);
            this.nodes[((Node)t2).getIndex()] = node;
            Node node2 = node;
            Intrinsics.checkNotNull((Object)node2);
            if (node2.getValue() < ((Node)t).getValue() ^ this.isMaxHeap) {
                this.up(((Node)t).getIndex());
            } else {
                this.down(((Node)t).getIndex());
            }
        } else {
            this.nodes[0] = null;
        }
        return t;
    }

    public final boolean notEmpty() {
        return this.size > 0;
    }

    public final boolean isEmpty() {
        return this.size == 0;
    }

    public final void clear() {
        Arrays.fill(this.nodes, 0, this.size, null);
        this.size = 0;
    }

    public final void setValue(T t, float f) {
        T t2 = t;
        Intrinsics.checkNotNull(t2);
        float f2 = ((Node)t2).getValue();
        ((Node)t).setValue(f);
        if (f < f2 ^ this.isMaxHeap) {
            this.up(((Node)t).getIndex());
            return;
        }
        this.down(((Node)t).getIndex());
    }

    private final void up(int n) {
        int n2 = n;
        Node[] nodeArray = this.nodes;
        Node node = this.nodes[n];
        Intrinsics.checkNotNull((Object)node);
        float f = node.getValue();
        while (n2 > 0) {
            Node node2;
            int n3 = n2 - 1 >> 1;
            Node node3 = node2 = nodeArray[n3];
            Intrinsics.checkNotNull((Object)node3);
            if (!(f < node3.getValue() ^ this.isMaxHeap)) break;
            nodeArray[n2] = node2;
            node2.setIndex(n2);
            n2 = n3;
        }
        nodeArray[n2] = node;
        node.setIndex(n2);
    }

    private final void down(int n) {
        int n2;
        int n3 = n;
        Node[] nodeArray = this.nodes;
        int n4 = this.size;
        Node node = nodeArray[n];
        Intrinsics.checkNotNull((Object)node);
        float f = node.getValue();
        while ((n2 = 1 + (n3 << 1)) < n4) {
            float f2;
            Node node2;
            int n5 = n2 + 1;
            Node node3 = nodeArray[n2];
            Intrinsics.checkNotNull((Object)node3);
            float f3 = node3.getValue();
            if (n5 >= n4) {
                node2 = null;
                f2 = this.isMaxHeap ? -3.4028235E38f : Float.MAX_VALUE;
            } else {
                node2 = nodeArray[n5];
                Intrinsics.checkNotNull((Object)node2);
                f2 = node2.getValue();
            }
            if (f3 < f2 ^ this.isMaxHeap) {
                if (f3 == f || f3 > f ^ this.isMaxHeap) break;
                nodeArray[n3] = node3;
                node3.setIndex(n3);
                n3 = n2;
                continue;
            }
            if (f2 == f || f2 > f ^ this.isMaxHeap) break;
            nodeArray[n3] = node2;
            if (node2 != null) {
                node2.setIndex(n3);
            }
            n3 = n5;
        }
        nodeArray[n3] = node;
        node.setIndex(n3);
    }

    public final boolean equals(Object nodeArray) {
        if (!(nodeArray instanceof BinaryHeap)) {
            return false;
        }
        if (((BinaryHeap)nodeArray).size != this.size) {
            return false;
        }
        Node[] nodeArray2 = this.nodes;
        nodeArray = ((BinaryHeap)nodeArray).nodes;
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            Node node = nodeArray2[i];
            Intrinsics.checkNotNull((Object)node);
            float f = node.getValue();
            Node node2 = nodeArray[i];
            Intrinsics.checkNotNull((Object)node2);
            if (f == node2.getValue()) continue;
            return false;
        }
        return true;
    }

    public final int hashCode() {
        int n = 1;
        Node[] nodeArray = this.nodes;
        int n2 = this.size;
        for (int i = 0; i < n2; ++i) {
            Node node = nodeArray[i];
            Intrinsics.checkNotNull((Object)node);
            n = n * 31 + Float.floatToIntBits(node.getValue());
        }
        return n;
    }

    public final String toString() {
        if (this.size == 0) {
            return "[]";
        }
        Node[] nodeArray = this.nodes;
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('[');
        Node node = nodeArray[0];
        Intrinsics.checkNotNull((Object)node);
        stringBuilder.append(node.getValue());
        int n = this.size;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(", ");
            Node node2 = nodeArray[i];
            Intrinsics.checkNotNull((Object)node2);
            stringBuilder.append(node2.getValue());
        }
        stringBuilder.append(']');
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"");
        return string;
    }

    public BinaryHeap(int n) {
        this(n, false, 2, null);
    }

    public BinaryHeap() {
        this(0, false, 3, null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldorkbox/collections/BinaryHeap$Companion;", "", "()V", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u0004\u00a8\u0006\u0010"}, d2={"Ldorkbox/collections/BinaryHeap$Node;", "", "value", "", "(F)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "getValue", "()F", "setValue", "toString", "", "Collections"})
    public static class Node {
        private float value;
        private int index;

        public Node(float f) {
            this.value = f;
        }

        public final float getValue() {
            return this.value;
        }

        public final void setValue(float f) {
            this.value = f;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }

        public String toString() {
            return String.valueOf(this.value);
        }
    }
}

