/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.joran.ReconfigureOnChangeTaskListener;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.ConfigurationWatchList;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.joran.util.ConfigurationWatchListUtil;
import ch.qos.logback.core.model.Model;
import ch.qos.logback.core.model.ModelUtil;
import ch.qos.logback.core.spi.ConfigurationEvent;
import ch.qos.logback.core.spi.ContextAwareBase;
import ch.qos.logback.core.status.StatusUtil;
import java.net.URL;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class ReconfigureOnChangeTask
extends ContextAwareBase
implements Runnable {
    public static final String DETECTED_CHANGE_IN_CONFIGURATION_FILES = "Detected change in configuration files.";
    static final String RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION = "Re-registering previous fallback configuration once more as a fallback configuration point";
    static final String FALLING_BACK_TO_SAFE_CONFIGURATION = "Given previous errors, falling back to previously registered safe configuration.";
    long birthdate = System.currentTimeMillis();
    List<ReconfigureOnChangeTaskListener> listeners = null;
    ScheduledFuture<?> scheduledFuture;

    @Override
    public void run() {
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectorRunningEvent((Object)this));
        Object object = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        if (object == null) {
            this.addWarn("Empty ConfigurationWatchList in context");
            return;
        }
        Object object2 = object.getCopyOfFileWatchList();
        if (object2 == null || object2.isEmpty()) {
            this.addInfo("Empty watch file list. Disabling ");
            return;
        }
        if (!object.changeDetected()) {
            return;
        }
        this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationChangeDetectedEvent((Object)this));
        this.cancelFutureInvocationsOfThisTaskInstance();
        object = object.getMainURL();
        this.addInfo(DETECTED_CHANGE_IN_CONFIGURATION_FILES);
        ReconfigureOnChangeTask reconfigureOnChangeTask = this;
        reconfigureOnChangeTask.addInfo("Will reset and reconfigure context named [" + reconfigureOnChangeTask.context.getName() + "]");
        object2 = (LoggerContext)this.context;
        if (((URL)object).toString().endsWith("xml")) {
            this.performXMLConfiguration((LoggerContext)((Object)object2), (URL)object);
            return;
        }
        if (((URL)object).toString().endsWith("groovy")) {
            this.addError("Groovy configuration disabled due to Java 9 compilation issues.");
        }
    }

    private void cancelFutureInvocationsOfThisTaskInstance() {
        boolean bl = this.scheduledFuture.cancel(false);
        if (!bl) {
            ReconfigureOnChangeTask reconfigureOnChangeTask = this;
            reconfigureOnChangeTask.addWarn("could not cancel " + reconfigureOnChangeTask.toString());
        }
    }

    private void performXMLConfiguration(LoggerContext loggerContext, URL uRL) {
        JoranConfigurator joranConfigurator = new JoranConfigurator();
        joranConfigurator.setContext(this.context);
        StatusUtil statusUtil = new StatusUtil(this.context);
        Model model = joranConfigurator.recallSafeConfiguration();
        URL uRL2 = ConfigurationWatchListUtil.getMainWatchURL((Context)this.context);
        loggerContext.reset();
        long l = System.currentTimeMillis();
        try {
            joranConfigurator.doConfigure(uRL);
            if (statusUtil.hasXMLParsingErrors(l)) {
                this.fallbackConfiguration(loggerContext, model, uRL2);
            }
            return;
        }
        catch (JoranException joranException) {
            this.addWarn("Exception occurred during reconfiguration", joranException);
            this.fallbackConfiguration(loggerContext, model, uRL2);
            return;
        }
    }

    private void fallbackConfiguration(LoggerContext loggerContext, Model model, URL object) {
        object = new JoranConfigurator();
        object.setContext(this.context);
        ConfigurationWatchList configurationWatchList = ConfigurationWatchListUtil.getConfigurationWatchList((Context)this.context);
        configurationWatchList = configurationWatchList.buildClone();
        if (model == null) {
            this.addWarn("No previous configuration to fall back on.");
            return;
        }
        this.addWarn(FALLING_BACK_TO_SAFE_CONFIGURATION);
        this.addInfo("Safe model " + String.valueOf(model));
        try {
            loggerContext.reset();
            ConfigurationWatchListUtil.registerConfigurationWatchList((Context)this.context, (ConfigurationWatchList)configurationWatchList);
            ModelUtil.resetForReuse((Model)model);
            object.processModel(model);
            this.addInfo(RE_REGISTERING_PREVIOUS_SAFE_CONFIGURATION);
            object.registerSafeConfiguration(model);
            this.context.fireConfigurationEvent(ConfigurationEvent.newConfigurationEndedEvent((Object)this));
            this.addInfo("after registerSafeConfiguration");
            return;
        }
        catch (Exception exception) {
            this.addError("Unexpected exception thrown by a configuration considered safe.", exception);
            return;
        }
    }

    public String toString() {
        return "ReconfigureOnChangeTask(born:" + this.birthdate + ")";
    }

    public void setScheduredFuture(ScheduledFuture<?> scheduledFuture) {
        this.scheduledFuture = scheduledFuture;
    }
}

