/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.NamedThreadFactory;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EventDispatch {
    private static int THREAD_PRIORITY = 5;
    private static ExecutorService eventDispatchExecutor = null;
    private static volatile CountDownLatch shutdownLatch = null;
    private static volatile boolean insideDispatch = false;

    public static void runLater(Runnable runnable) {
        Class<EventDispatch> clazz = EventDispatch.class;
        synchronized (EventDispatch.class) {
            if (eventDispatchExecutor == null) {
                if (insideDispatch) {
                    SystemTray.logger.error("Unable to create a new event dispatch, while executing within the same context.");
                    // ** MonitorExit[var1_2] (shouldn't be in output)
                    return;
                }
                shutdownLatch = new CountDownLatch(1);
                eventDispatchExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("SystemTrayEventDispatch", Thread.currentThread().getThreadGroup(), THREAD_PRIORITY, true));
            }
            // ** MonitorExit[var1_2] (shouldn't be in output)
            eventDispatchExecutor.execute(() -> {
                insideDispatch = true;
                runnable.run();
                insideDispatch = false;
            });
            return;
        }
    }

    public static void shutdown() {
        EventDispatch.runLater(() -> {
            Object object = EventDispatch.class;
            synchronized (EventDispatch.class) {
                ExecutorService executorService = eventDispatchExecutor;
                eventDispatchExecutor = null;
                // ** MonitorExit[var1] (shouldn't be in output)
                if (executorService != null) {
                    object = executorService.shutdownNow();
                    for (int i = 0; i < object.size(); ++i) {
                        try {
                            ((Runnable)object.get(i)).run();
                            continue;
                        }
                        catch (Exception exception) {
                            SystemTray.logger.error("Error shutting down EventDispatch", (Throwable)exception);
                        }
                    }
                    shutdownLatch.countDown();
                }
                return;
            }
        });
    }

    public static void waitForShutdown() {
        Class<EventDispatch> clazz = EventDispatch.class;
        synchronized (EventDispatch.class) {
            CountDownLatch countDownLatch = shutdownLatch;
            // ** MonitorExit[var1] (shouldn't be in output)
            if (countDownLatch != null) {
                try {
                    countDownLatch.await(5L, TimeUnit.SECONDS);
                    return;
                }
                catch (InterruptedException interruptedException) {}
            }
            return;
        }
    }
}

