/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.text.input;

import androidx.compose.foundation.text.input.TextFieldState;
import androidx.compose.foundation.text.input.TextUndoManagerKt;
import androidx.compose.foundation.text.input.internal.undo.TextUndoOperation;
import androidx.compose.foundation.text.input.internal.undo.TextUndoOperationKt;
import androidx.compose.foundation.text.input.internal.undo.UndoManager;
import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import androidx.compose.runtime.saveable.Saver;
import androidx.compose.runtime.saveable.SaverScope;
import androidx.compose.runtime.snapshots.Snapshot;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0001\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB#\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0003J\u0006\u0010\u001d\u001a\u00020\u0017J\b\u0010\u001e\u001a\u00020\u0017H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R/\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u00038B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006 "}, d2={"Landroidx/compose/foundation/text/input/TextUndoManager;", "", "initialStagingUndo", "Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "undoManager", "Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "<init>", "(Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;Landroidx/compose/foundation/text/input/internal/undo/UndoManager;)V", "<set-?>", "stagingUndo", "getStagingUndo", "()Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "setStagingUndo", "(Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;)V", "stagingUndo$delegate", "Landroidx/compose/runtime/MutableState;", "canUndo", "", "getCanUndo", "()Z", "canRedo", "getCanRedo", "undo", "", "state", "Landroidx/compose/foundation/text/input/TextFieldState;", "redo", "record", "op", "clearHistory", "flush", "Companion", "foundation"})
public final class TextUndoManager {
    public static final Companion Companion = new Companion(null);
    private final UndoManager<TextUndoOperation> undoManager;
    private final MutableState stagingUndo$delegate;
    public static final int $stable = 8;

    public TextUndoManager(TextUndoOperation textUndoOperation, UndoManager<TextUndoOperation> undoManager) {
        Intrinsics.checkNotNullParameter(undoManager, (String)"");
        this.undoManager = undoManager;
        this.stagingUndo$delegate = SnapshotStateKt.mutableStateOf$default((Object)textUndoOperation, null, (int)2, null);
    }

    public /* synthetic */ TextUndoManager(TextUndoOperation textUndoOperation, UndoManager undoManager, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            textUndoOperation = null;
        }
        if ((n2 & 2) != 0) {
            undoManager = new UndoManager(null, null, 100, 3, null);
        }
        this(textUndoOperation, undoManager);
    }

    private final TextUndoOperation getStagingUndo() {
        State state = (State)this.stagingUndo$delegate;
        return (TextUndoOperation)state.getValue();
    }

    private final void setStagingUndo(TextUndoOperation textUndoOperation) {
        MutableState mutableState = this.stagingUndo$delegate;
        mutableState.setValue((Object)textUndoOperation);
    }

    public final boolean getCanUndo() {
        return this.undoManager.getCanUndo$foundation() || this.getStagingUndo() != null;
    }

    public final boolean getCanRedo() {
        return this.undoManager.getCanRedo$foundation() && this.getStagingUndo() == null;
    }

    public final void undo(TextFieldState textFieldState) {
        Intrinsics.checkNotNullParameter((Object)textFieldState, (String)"");
        if (!this.getCanUndo()) {
            return;
        }
        this.flush();
        TextUndoOperationKt.undo(textFieldState, this.undoManager.undo());
    }

    public final void redo(TextFieldState textFieldState) {
        Intrinsics.checkNotNullParameter((Object)textFieldState, (String)"");
        if (!this.getCanRedo()) {
            return;
        }
        TextUndoOperationKt.redo(textFieldState, this.undoManager.redo());
    }

    public final void record(TextUndoOperation textUndoOperation) {
        TextUndoOperation textUndoOperation2;
        Intrinsics.checkNotNullParameter((Object)textUndoOperation, (String)"");
        Object object = Snapshot.Companion;
        Snapshot snapshot = object.getCurrentThreadSnapshot();
        Function1 function1 = snapshot != null ? snapshot.getReadObserver() : null;
        Snapshot snapshot2 = object.makeCurrentNonObservable(snapshot);
        try {
            textUndoOperation2 = this.getStagingUndo();
        }
        finally {
            object.restoreNonObservable(snapshot, snapshot2, function1);
        }
        object = textUndoOperation2;
        if (object == null) {
            this.setStagingUndo(textUndoOperation);
            return;
        }
        if ((object = TextUndoManagerKt.merge((TextUndoOperation)object, textUndoOperation)) != null) {
            this.setStagingUndo((TextUndoOperation)object);
            return;
        }
        this.flush();
        this.setStagingUndo(textUndoOperation);
    }

    public final void clearHistory() {
        this.setStagingUndo(null);
        this.undoManager.clearHistory();
    }

    private final void flush() {
        TextUndoOperation textUndoOperation;
        Object object = Snapshot.Companion;
        Snapshot snapshot = object.getCurrentThreadSnapshot();
        Function1 function1 = snapshot != null ? snapshot.getReadObserver() : null;
        Snapshot snapshot2 = object.makeCurrentNonObservable(snapshot);
        try {
            textUndoOperation = this.getStagingUndo();
        }
        finally {
            object.restoreNonObservable(snapshot, snapshot2, function1);
        }
        object = textUndoOperation;
        if (object != null) {
            this.undoManager.record((TextUndoOperation)object);
        }
        this.setStagingUndo(null);
    }

    public TextUndoManager() {
        this(null, null, 3, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0004B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0005"}, d2={"Landroidx/compose/foundation/text/input/TextUndoManager$Companion;", "", "<init>", "()V", "Saver", "foundation"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\t\u001a\u00020\u0003*\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\u0003H\u0016R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/compose/foundation/text/input/TextUndoManager$Companion$Saver;", "Landroidx/compose/runtime/saveable/Saver;", "Landroidx/compose/foundation/text/input/TextUndoManager;", "", "<init>", "()V", "undoManagerSaver", "Landroidx/compose/foundation/text/input/internal/undo/UndoManager;", "Landroidx/compose/foundation/text/input/internal/undo/TextUndoOperation;", "save", "Landroidx/compose/runtime/saveable/SaverScope;", "value", "restore", "foundation"})
        public static final class Saver
        implements androidx.compose.runtime.saveable.Saver<TextUndoManager, Object> {
            public static final Saver INSTANCE = new Saver();
            private static final androidx.compose.runtime.saveable.Saver<UndoManager<TextUndoOperation>, Object> undoManagerSaver;
            public static final int $stable;

            private Saver() {
            }

            public final Object save(SaverScope saverScope, TextUndoManager textUndoManager) {
                Object object;
                Object[] objectArray;
                Object object2;
                Object[] objectArray2;
                Intrinsics.checkNotNullParameter((Object)saverScope, (String)"");
                Intrinsics.checkNotNullParameter((Object)textUndoManager, (String)"");
                Object[] objectArray3 = objectArray2 = new Object[2];
                int n2 = 0;
                androidx.compose.runtime.saveable.Saver<UndoManager<TextUndoOperation>, Object> saver = textUndoManager.getStagingUndo();
                if (saver != null) {
                    object2 = saver;
                    objectArray = objectArray3;
                    androidx.compose.runtime.saveable.Saver<TextUndoOperation, Object> saver2 = TextUndoOperation.Companion.getSaver();
                    object2 = saver2.save(saverScope, object2);
                    objectArray3 = objectArray;
                    n2 = 0;
                    object = object2;
                } else {
                    object = null;
                }
                objectArray3[n2] = object;
                object2 = undoManagerSaver;
                objectArray = objectArray2;
                objectArray[1] = object2 = object2.save(saverScope, (Object)textUndoManager.undoManager);
                return CollectionsKt.listOf((Object[])objectArray2);
            }

            public final TextUndoManager restore(Object object) {
                TextUndoOperation textUndoOperation;
                androidx.compose.runtime.saveable.Saver<TextUndoOperation, Object> saver;
                Intrinsics.checkNotNullParameter((Object)object, (String)"");
                object = (List)object;
                Object object2 = object.get(0);
                object = object.get(1);
                Object e = object2;
                if (e != null) {
                    object2 = e;
                    saver = TextUndoOperation.Companion.getSaver();
                    textUndoOperation = (TextUndoOperation)saver.restore(object2);
                } else {
                    textUndoOperation = null;
                }
                object2 = undoManagerSaver;
                saver = textUndoOperation;
                Object object3 = object;
                Intrinsics.checkNotNull((Object)object3);
                UndoManager undoManager = (UndoManager)object2.restore(object3);
                Intrinsics.checkNotNull((Object)undoManager);
                object = undoManager;
                object2 = saver;
                return new TextUndoManager((TextUndoOperation)object2, (UndoManager<TextUndoOperation>)object);
            }

            static {
                androidx.compose.runtime.saveable.Saver<TextUndoOperation, Object> saver = TextUndoOperation.Companion.getSaver();
                undoManagerSaver = (androidx.compose.runtime.saveable.Saver)new androidx.compose.runtime.saveable.Saver<UndoManager<TextUndoOperation>, Object>(saver){
                    final /* synthetic */ androidx.compose.runtime.saveable.Saver $itemSaver;
                    {
                        this.$itemSaver = saver;
                    }

                    public final Object save(SaverScope saverScope, UndoManager<TextUndoOperation> undoManager) {
                        androidx.compose.runtime.saveable.Saver saver;
                        E e;
                        int n2;
                        List list;
                        Intrinsics.checkNotNullParameter((Object)saverScope, (String)"");
                        Intrinsics.checkNotNullParameter(undoManager, (String)"");
                        androidx.compose.runtime.saveable.Saver saver2 = this.$itemSaver;
                        List list2 = list = CollectionsKt.createListBuilder();
                        list.add(UndoManager.access$getCapacity$p(undoManager));
                        list2.add(UndoManager.access$getUndoStack$p(undoManager).size());
                        list2.add(UndoManager.access$getRedoStack$p(undoManager).size());
                        List list3 = (List)UndoManager.access$getUndoStack$p(undoManager);
                        int n3 = ((Collection)list3).size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            e = list3.get(n2);
                            saver = saver2;
                            list2.add(saver.save(saverScope, e));
                        }
                        list3 = (List)UndoManager.access$getRedoStack$p(undoManager);
                        n3 = ((Collection)list3).size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            e = list3.get(n2);
                            saver = saver2;
                            list2.add(saver.save(saverScope, e));
                        }
                        return CollectionsKt.build((List)list);
                    }

                    public final UndoManager<TextUndoOperation> restore(Object object) {
                        int n2;
                        List list;
                        Intrinsics.checkNotNullParameter((Object)object, (String)"");
                        object = (List)object;
                        List list2 = object;
                        int n3 = ((Number)object.get(0)).intValue();
                        int n4 = ((Number)list2.get(1)).intValue();
                        int n5 = ((Number)list2.get(2)).intValue();
                        Object object2 = this.$itemSaver;
                        List list3 = list = CollectionsKt.createListBuilder();
                        for (n2 = 3; n2 < n4 + 3; ++n2) {
                            Object object3 = object2.restore(object.get(n2));
                            Intrinsics.checkNotNull((Object)object3);
                            list3.add(object3);
                        }
                        List list4 = CollectionsKt.build((List)list);
                        list = this.$itemSaver;
                        list3 = CollectionsKt.createListBuilder();
                        object2 = list3;
                        while (n2 < n4 + n5 + 3) {
                            Object object4 = list.restore(object.get(n2));
                            Intrinsics.checkNotNull((Object)object4);
                            object2.add(object4);
                            ++n2;
                        }
                        object2 = CollectionsKt.build((List)list3);
                        return new UndoManager<TextUndoOperation>(list4, (List<TextUndoOperation>)object2, n3);
                    }
                };
                $stable = 8;
            }
        }
    }
}

